/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.shortmatrix.impl;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.impl.DefaultDenseDoubleMatrix2D;
import org.ujmp.core.interfaces.HasShortArray;
import org.ujmp.core.shortmatrix.stub.AbstractDenseShortMatrix2D;

public class DefaultDenseShortMatrix2D
extends AbstractDenseShortMatrix2D
implements HasShortArray {
    private static final long serialVersionUID = 3387495964006716189L;
    private final short[] values;
    private final int rows;
    private final int cols;

    public DefaultDenseShortMatrix2D(int rows, int columns) {
        super((long)rows, (long)columns);
        this.rows = rows;
        this.cols = columns;
        this.values = new short[rows * this.cols];
    }

    public short getShort(long row, long column) {
        return this.values[(int)(column * (long)this.rows + row)];
    }

    public void setShort(short value, long row, long column) {
        this.values[(int)(column * (long)this.rows + row)] = value;
    }

    public short getShort(int row, int column) {
        return this.values[column * this.rows + row];
    }

    public void setShort(short value, int row, int column) {
        this.values[column * this.rows + row] = value;
    }

    public final Matrix plus(double v) {
        double[] result = new double[this.values.length];
        int i = result.length;
        while (--i != -1) {
            result[i] = (double)this.values[i] + v;
        }
        return new DefaultDenseDoubleMatrix2D(result, this.rows, this.cols);
    }

    public final Matrix minus(double v) {
        double[] result = new double[this.values.length];
        int i = result.length;
        while (--i != -1) {
            result[i] = (double)this.values[i] - v;
        }
        return new DefaultDenseDoubleMatrix2D(result, this.rows, this.cols);
    }

    public final Matrix times(double v) {
        double[] result = new double[this.values.length];
        int i = result.length;
        while (--i != -1) {
            result[i] = (double)this.values[i] * v;
        }
        return new DefaultDenseDoubleMatrix2D(result, this.rows, this.cols);
    }

    public final Matrix divide(double v) {
        double[] result = new double[this.values.length];
        int i = result.length;
        while (--i != -1) {
            result[i] = (double)this.values[i] / v;
        }
        return new DefaultDenseDoubleMatrix2D(result, this.rows, this.cols);
    }

    public final Matrix copy() {
        DefaultDenseShortMatrix2D m = new DefaultDenseShortMatrix2D(this.rows, this.cols);
        short[] result = m.values;
        System.arraycopy(this.values, 0, result, 0, this.values.length);
        if (this.getMetaData() != null) {
            m.setMetaData(this.getMetaData().clone());
        }
        return m;
    }

    public final Matrix transpose() {
        DefaultDenseShortMatrix2D m = new DefaultDenseShortMatrix2D(this.cols, this.rows);
        short[] result = m.values;
        int c = this.rows;
        while (--c != -1) {
            int r = this.cols;
            while (--r != -1) {
                result[c * this.cols + r] = this.values[r * this.rows + c];
            }
        }
        return m;
    }

    public short[] getShortArray() {
        return this.values;
    }
}

