/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.calculation;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.objectmatrix.calculation.AbstractObjectCalculation;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.VerifyUtil;

public class Reshape
extends AbstractObjectCalculation {
    private static final long serialVersionUID = -4298270756453090584L;
    private final long[] newSize;
    private final long[] oldSize;

    public Reshape(Matrix source, long ... newSize) {
        super(source);
        this.newSize = newSize;
        this.oldSize = source.getSize();
        VerifyUtil.verifyEquals(Coordinates.product(this.oldSize), Coordinates.product(newSize), "new matrix must have the same number of cells");
    }

    public long[] getSize() {
        return this.newSize;
    }

    public Object getObject(long ... coordinates) {
        long index = MathUtil.pos2IndexColumnMajor(this.newSize, coordinates);
        long[] oldPos = MathUtil.index2PosColumnMajor(this.oldSize, index);
        return this.getSource().getAsObject(oldPos);
    }

    public void setObject(Object value, long ... coordinates) {
        long index = MathUtil.pos2IndexColumnMajor(this.newSize, coordinates);
        long[] oldPos = MathUtil.index2PosColumnMajor(this.oldSize, index);
        this.getSource().setAsObject(value, oldPos);
    }
}

