/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.uiutil;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class FileChooser {
    static JFileChooser fileChooser;
    public static boolean RUNNING_ON_MAC;

    private FileChooser() {
    }

    private static File showFileDialog(Frame parent, int mode, File selectedFile, String title) {
        title = title == null ? "GenePattern" : "GenePattern - " + (String)title;
        FileDialog fc = new FileDialog(parent, (String)title, mode);
        if (selectedFile != null) {
            fc.setDirectory(selectedFile.getPath());
            fc.setFile(selectedFile.getName());
        }
        fc.setModal(true);
        fc.setVisible(true);
        String f = fc.getFile();
        String directory = fc.getDirectory();
        if (f != null) {
            File file = new File(directory, f);
            return file;
        }
        return null;
    }

    public static File showOpenDialog(Frame parent, String title) {
        if (RUNNING_ON_MAC) {
            return FileChooser.showFileDialog(parent, 0, null, title);
        }
        if (fileChooser == null) {
            fileChooser = new JFileChooser();
        }
        fileChooser.setDialogTitle(title);
        if (fileChooser.showOpenDialog(parent) == 0) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }

    public static File showSaveDialog(Frame parent) {
        return FileChooser.showSaveDialog(parent, null);
    }

    public static File showSaveDialog(Frame parent, File selectedFile) {
        if (RUNNING_ON_MAC) {
            return FileChooser.showFileDialog(parent, 1, selectedFile, "GenePattern");
        }
        if (fileChooser == null) {
            fileChooser = new JFileChooser();
        }
        fileChooser.setSelectedFile(selectedFile);
        if (fileChooser.showSaveDialog(parent) == 0) {
            File outputFile = fileChooser.getSelectedFile();
            if (!FileChooser.overwriteFile(parent, outputFile)) {
                return null;
            }
            return outputFile;
        }
        return null;
    }

    public static boolean overwriteFile(Component parent, File f) {
        if (!f.exists()) {
            return true;
        }
        String message = "An item named " + f.getName() + " already exists in this location.\nDo you want to replace it with the one that you are saving?";
        return JOptionPane.showOptionDialog(parent, message, null, 0, 2, null, new Object[]{"Replace", "Cancel"}, "Cancel") == 0;
    }

    static {
        RUNNING_ON_MAC = System.getProperty("mrj.version") != null && UIManager.getSystemLookAndFeelClassName().equals(UIManager.getLookAndFeel().getClass().getName());
    }
}

