/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.objects.Annot;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.SampleAnnot;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserException;
import edu.mit.broad.genome.utils.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class PclParser
extends AbstractParser {
    protected PclParser() {
        super(Dataset.class);
    }

    @Override
    public void export(PersistentObject pob, File file) throws Exception {
        int i;
        PrintWriter pw = new PrintWriter(new FileOutputStream(file));
        Dataset ds = (Dataset)pob;
        FeatureAnnot ann = ds.getAnnot().getFeatureAnnot();
        pw.print("UNIQUID\tNAME\tGWEIGHT\t");
        for (i = 0; i < ds.getNumCol(); ++i) {
            pw.print(ds.getColumnName(i));
            if (i == ds.getNumCol() - 1) continue;
            pw.print('\t');
        }
        pw.println();
        pw.print("EWEIGHT\t\t\t");
        for (i = 0; i < ds.getNumCol(); ++i) {
            pw.print("1");
            if (i == ds.getNumCol() - 1) continue;
            pw.print('\t');
        }
        pw.println();
        for (int r = 0; r < ds.getNumRow(); ++r) {
            StringBuffer buf = new StringBuffer();
            String rowName = ds.getRowName(r);
            buf.append(rowName).append('\t');
            buf.append(ann.getNativeDesc(rowName)).append('\t');
            buf.append("1\t");
            buf.append(ds.getRow(r).toString('\t'));
            pw.println(buf.toString());
        }
        pw.close();
        this.doneExport();
    }

    @Override
    public List parse(String hackINeedFullPath, InputStream is) throws Exception {
        this.startImport(hackINeedFullPath);
        int nlines = FileUtils.countLines(hackINeedFullPath, true);
        int nfloatlines = nlines - 2;
        this.log.debug((Object)("Number of float lines = " + nfloatlines));
        BufferedReader bin = new BufferedReader(new InputStreamReader(is));
        String currLine = this.nextLine(bin);
        List<String> colNames = ParseUtils.string2stringsList(currLine, "\t");
        int expectedNCols = colNames.size();
        colNames.remove(0);
        colNames.remove(0);
        colNames.remove(0);
        this.log.debug((Object)("Number of columns of floats = " + colNames.size()));
        this.nextLine(bin);
        ArrayList<String> rowNames = new ArrayList<String>(nfloatlines);
        ArrayList<String> rowDescs = new ArrayList<String>(nfloatlines);
        Matrix matrix = new Matrix(nfloatlines, colNames.size());
        int r = 0;
        currLine = this.nextLineTrimless(bin);
        while (currLine != null) {
            List fields = PclParser.string2stringsV2(currLine, expectedNCols);
            if (fields.size() != expectedNCols) {
                throw new ParserException("Invalid format on line: " + currLine + " expected # fields = " + expectedNCols + " but found: " + fields.size());
            }
            String rowName = fields.get(0).toString().trim();
            if (rowName.length() == 0) {
                throw new ParserException("Bad rowname - cant be empty at: " + r + " >" + currLine);
            }
            rowNames.add(rowName);
            String desc = fields.get(1).toString().trim();
            if (desc.length() == 0) {
                throw new ParserException("Bad rowdescname - cant be empty at: " + r + " >" + currLine);
            }
            rowDescs.add(desc);
            if (Integer.parseInt(fields.get(2).toString()) != 1) {
                throw new ParserException("Expected field was not 1 for GWEIGHT: " + fields.get(2) + " " + currLine);
            }
            for (int f = 3; f < fields.size(); ++f) {
                String s = fields.get(f).toString().trim();
                float val = s.length() == 0 ? Float.NaN : Float.parseFloat(s);
                matrix.setElement(r, f - 3, val);
            }
            ++r;
            currLine = this.nextLineTrimless(bin);
        }
        bin.close();
        String name = new File(hackINeedFullPath).getName();
        FeatureAnnot fann = new FeatureAnnot(name, rowNames, rowDescs);
        fann.addComment(this.fComment.toString());
        SampleAnnot sann = new SampleAnnot(name, colNames);
        DefaultDataset ds = new DefaultDataset(name, matrix, rowNames, colNames, true, new Annot(fann, sann));
        ds.addComment(this.fComment.toString());
        this.doneImport();
        return PclParser.unmodlist(new PersistentObject[]{ds});
    }
}

