/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.table;

import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.ujmp.gui.MatrixGUIObject;
import org.ujmp.gui.table.TableModel64;
import org.ujmp.gui.table.TableModelEvent64;
import org.ujmp.gui.table.TableModelListener64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowHeaderTableModel64
implements TableModel64,
TableModelListener64 {
    private transient EventListenerList listenerList = null;
    private final MatrixGUIObject model;

    public RowHeaderTableModel64(MatrixGUIObject model) {
        this.model = model;
        model.addTableModelListener(this);
    }

    @Override
    public int getRowCount() {
        return this.model.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.model.getMatrix().getRowLabel(rowIndex);
    }

    @Override
    public String getColumnName(int columnIndex) {
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return !this.model.getMatrix().isReadOnly();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.model.getMatrix().setRowLabel(rowIndex, String.valueOf(aValue));
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.getListenerList().add(TableModelListener.class, l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.getListenerList().remove(TableModelListener.class, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventListenerList getListenerList() {
        if (this.listenerList == null) {
            RowHeaderTableModel64 rowHeaderTableModel64 = this;
            synchronized (rowHeaderTableModel64) {
                if (this.listenerList == null) {
                    this.listenerList = new EventListenerList();
                }
            }
        }
        return this.listenerList;
    }

    @Override
    public long getRowCount64() {
        return this.model.getRowCount64();
    }

    @Override
    public long getColumnCount64() {
        return 1L;
    }

    @Override
    public String getColumnName(long columnIndex) {
        return "RowLabel";
    }

    @Override
    public Class<?> getColumnClass(long columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(long rowIndex, long columnIndex) {
        return !this.model.getMatrix().isReadOnly();
    }

    @Override
    public Object getValueAt(long rowIndex, long columnIndex) {
        return this.model.getMatrix().getRowLabel(rowIndex);
    }

    @Override
    public void setValueAt(Object aValue, long rowIndex, long columnIndex) {
        this.model.getMatrix().setRowLabel(rowIndex, String.valueOf(aValue));
    }

    @Override
    public void addTableModelListener(TableModelListener64 l) {
        this.getListenerList().add(TableModelListener64.class, l);
    }

    @Override
    public void removeTableModelListener(TableModelListener64 l) {
        this.getListenerList().remove(TableModelListener64.class, l);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.fireValueChanged(e.getFirstRow(), e.getColumn(), null);
    }

    @Override
    public void tableChanged(TableModelEvent64 e) {
        this.fireValueChanged(e.firstRow, e.column, null);
    }

    public final void fireValueChanged() {
        for (Object o : this.getListenerList().getListenerList()) {
            if (o instanceof TableModelListener64) {
                ((TableModelListener64)o).tableChanged(new TableModelEvent64(this));
                continue;
            }
            if (!(o instanceof TableModelListener)) continue;
            ((TableModelListener)o).tableChanged(new TableModelEvent(this));
        }
    }

    public final void fireValueChanged(long row, long column, Object value) {
        for (Object o : this.getListenerList().getListenerList()) {
            if (o instanceof TableModelListener64) {
                ((TableModelListener64)o).tableChanged(new TableModelEvent64(this, row, row, column, 0));
                continue;
            }
            if (!(o instanceof TableModelListener)) continue;
            ((TableModelListener)o).tableChanged(new TableModelEvent(this, (int)row, (int)row, (int)column, 0));
        }
    }
}

