/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.alg.ComparatorFactory;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import edu.mit.broad.vdb.VdbRuntimeResources;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.xbench.core.ObjectBindery;
import edu.mit.broad.xbench.prefs.XPreferencesFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import org.genepattern.uiutil.FTPFile;
import org.genepattern.uiutil.FTPList;
import xapps.gsea.GseaWebResources;
import xtools.api.param.AbstractParam;
import xtools.api.param.ChooserHelper;
import xtools.api.param.ParamHelper;
import xtools.api.param.WChipChooserUI;
import xtools.api.ui.NamedModel;

public class ChipOptParam
extends AbstractParam {
    private WChipChooserUI fChooser;

    public ChipOptParam(boolean reqd) {
        this("chip", "Chip platform", "Name of the chip to use - only 1 chip can be choosen", reqd);
    }

    public ChipOptParam(String name, String nameEnglish, String desc, boolean reqd) {
        super(name, nameEnglish, Chip.class, desc, null, (Object[])new Chip[0], reqd);
    }

    public Chip getChip() throws Exception {
        Object val = this.getValue();
        if (val == null) {
            return null;
        }
        return VdbRuntimeResources.getChip(val.toString());
    }

    private String format(Object[] vals) {
        if (vals == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] == null) continue;
            this.log.debug(vals[i].getClass());
            if (vals[i] instanceof PersistentObject) {
                String p = ParserFactory.getCache().getSourcePath(vals[i]);
                buf.append(p);
            } else {
                buf.append(vals[i].toString().trim());
            }
            if (i == vals.length - 1) continue;
            buf.append(',');
        }
        return buf.toString();
    }

    @Override
    public boolean isFileBased() {
        return true;
    }

    @Override
    public String getValueStringRepresentation(boolean full) {
        Object val = this.getValue();
        if (val == null) {
            return null;
        }
        if (val instanceof String) {
            return (String)val;
        }
        if (val instanceof Object[]) {
            Object[] objs = (Object[])val;
            return this.format(objs);
        }
        return this.format(new Object[]{val});
    }

    @Override
    public GFieldPlusChooser getSelectionComponent() {
        if (this.fChooser == null) {
            this.fChooser = new WChipChooserUI();
            MyPobActionListener actionListener = new MyPobActionListener();
            actionListener.setChooser(this.fChooser);
            this.fChooser.setCustomActionListener(actionListener);
            String text = this.getValueStringRepresentation(false);
            if (text == null) {
                text = this.format((Object[])this.getDefault());
            }
            this.fChooser.setText(text);
            ParamHelper.addDocumentListener(this.fChooser.getTextField(), this);
        }
        return this.fChooser;
    }

    static class ChipListRenderer
    extends DefaultListCellRenderer {
        private boolean skipRenderCheck = false;

        ChipListRenderer() {
        }

        public void setSkipRenderCheck(boolean skipRenderCheck) {
            this.skipRenderCheck = skipRenderCheck;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String str;
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                return this;
            }
            if (value instanceof FTPFile) {
                str = ((FTPFile)value).getName();
                this.setText(str);
            } else {
                str = value.toString();
            }
            if (!isSelected && !this.skipRenderCheck) {
                this.setForeground(Color.BLACK);
                this.setIcon(null);
            }
            if (str.contains(ComparatorFactory.ChipNameComparator.getHighestVersionId())) {
                Font font = this.getFont();
                String fontName = font.getFontName();
                int fontSize = font.getSize();
                this.setFont(new Font(fontName, 1, fontSize));
            }
            return this;
        }
    }

    private static class MyPobActionListener
    implements ActionListener {
        private WChipChooserUI fChooser;
        private ChipListRenderer rend = new ChipListRenderer();

        public void setChooser(WChipChooserUI chooser) {
            this.fChooser = chooser;
        }

        private ListModel createFTPModel() {
            if (!XPreferencesFactory.kOnlineMode.getBoolean()) {
                DefaultListModel<String> model = new DefaultListModel<String>();
                model.addElement("Offline mode");
                model.addElement("Change this in Menu=>Preferences");
                model.addElement("Choose chips from other tabs");
                this.rend.setSkipRenderCheck(true);
                return model;
            }
            try {
                FTPList ftpList = new FTPList(GseaWebResources.getGseaFTPServer(), GseaWebResources.getGseaFTPServerUserName(), GseaWebResources.getGseaFTPServerPassword(), GseaWebResources.getGseaFTPServerChipDir(), new ComparatorFactory.ChipNameComparator());
                ftpList.quit();
                return ftpList.getModel();
            }
            catch (Exception e) {
                AbstractParam.klog.error((Object)e);
                DefaultListModel<String> model = new DefaultListModel<String>();
                model.addElement("Error listing Broad website");
                model.addElement(e.getMessage());
                model.addElement("Choose chips from other tabs");
                this.rend.setSkipRenderCheck(true);
                return model;
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.fChooser == null) {
                return;
            }
            NamedModel chipsFromFTPModel = new NamedModel("Chips (from website)", this.createFTPModel());
            NamedModel[] models = new NamedModel[]{chipsFromFTPModel, new NamedModel("Chips (local .chip)", ObjectBindery.getModel(Chip.class))};
            Object[] sels = this.fChooser.getJListWindow().showDirectlyWithModels(models, 0, this.rend);
            if (sels != null && sels.length != 0) {
                String[] paths = new String[sels.length];
                for (int i = 0; i < sels.length; ++i) {
                    paths[i] = sels[i] instanceof FTPFile ? ((FTPFile)sels[i]).getPath() : ParserFactory.getCache().getSourcePath(sels[i]);
                }
                String str = ChooserHelper.formatPob(sels);
                this.fChooser.setText(str);
            }
        }
    }
}

