/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.uiutil;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JOptionPane;

public class UIUtil {
    private static MessageHandler messageHandler = new DefaultMessageHandler();

    private UIUtil() {
    }

    public static boolean showConfirmDialog(Component parent, String message) {
        return JOptionPane.showOptionDialog(parent, message, "", 0, 2, null, new Object[]{"Yes", "No"}, "Yes") == 0;
    }

    public static void showMessageDialog(Component parent, String message) {
        messageHandler.showMessageDialog(parent, message);
    }

    public static void showErrorDialog(Component parent, String message) {
        messageHandler.showErrorDialog(parent, message);
    }

    public static void sizeToScreen(Component c) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        c.setSize(screenSize);
    }

    public static void setMessageHandler(MessageHandler m) {
        messageHandler = m;
    }

    private static class DefaultMessageHandler
    implements MessageHandler {
        private DefaultMessageHandler() {
        }

        @Override
        public void showMessageDialog(Component parent, String message) {
            JOptionPane.showMessageDialog(parent, message, "", 1, null);
        }

        @Override
        public void showErrorDialog(Component parent, String message) {
            JOptionPane.showMessageDialog(parent, message, "", 0, null);
        }
    }

    public static interface MessageHandler {
        public void showMessageDialog(Component var1, String var2);

        public void showErrorDialog(Component var1, String var2);
    }
}

