/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.SortMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DoubleElement {
    public int fIndex;
    public double fValue;

    public DoubleElement(int index, double value) {
        this.fIndex = index;
        this.fValue = value;
    }

    public static void sort(SortMode sort, Order order, List<DoubleElement> felist) {
        Collections.sort(felist, new DoubleElementComparator(sort, order.isAscending()));
    }

    public static DoubleElement[] sort(SortMode sort, Order order, DoubleElement[] dels) {
        List<DoubleElement> list = DoubleElement.toList(dels);
        DoubleElement.sort(sort, order, list);
        return list.toArray(new DoubleElement[list.size()]);
    }

    public static int[] indexArray(List delist) {
        int[] indexes = new int[delist.size()];
        for (int i = 0; i < delist.size(); ++i) {
            indexes[i] = ((DoubleElement)delist.get((int)i)).fIndex;
        }
        return indexes;
    }

    public static double[] valueArray(List delist) {
        double[] values = new double[delist.size()];
        for (int i = 0; i < delist.size(); ++i) {
            values[i] = ((DoubleElement)delist.get((int)i)).fValue;
        }
        return values;
    }

    public static List<DoubleElement> toList(DoubleElement[] dels) {
        ArrayList<DoubleElement> list = new ArrayList<DoubleElement>(dels.length);
        for (int i = 0; i < dels.length; ++i) {
            list.add(dels[i]);
        }
        return list;
    }

    public static float[] toFloats(List dels) {
        float[] floats = new float[dels.size()];
        for (int i = 0; i < dels.size(); ++i) {
            floats[i] = (float)((DoubleElement)dels.get((int)i)).fValue;
        }
        return floats;
    }

    public static class DoubleElementComparator
    implements Comparator<DoubleElement> {
        private final boolean fIsAbsolute;
        private final Boolean fAscending;
        private final int firstObjReturn;
        private final int secondObjReturn;

        public DoubleElementComparator(SortMode sort, boolean ascending) {
            this.fIsAbsolute = sort.isAbsolute();
            this.fAscending = ascending;
            this.firstObjReturn = this.fAscending != false ? -1 : 1;
            this.secondObjReturn = this.fAscending != false ? 1 : -1;
        }

        @Override
        public int compare(DoubleElement obj1, DoubleElement obj2) {
            if (obj1 == null) {
                if (obj2 == null) {
                    return 0;
                }
                return this.firstObjReturn;
            }
            if (obj2 == null) {
                return this.secondObjReturn;
            }
            double d1 = obj1.fValue;
            double d2 = obj2.fValue;
            if (Double.isNaN(d1)) {
                if (Double.isNaN(d2)) {
                    return 0;
                }
                return this.firstObjReturn;
            }
            if (Double.isNaN(d2)) {
                return this.secondObjReturn;
            }
            if (this.fIsAbsolute) {
                d1 = Math.abs(d1);
                d2 = Math.abs(d2);
            }
            if (d1 < d2) {
                return this.firstObjReturn;
            }
            if (d1 > d2) {
                return this.secondObjReturn;
            }
            return 0;
        }
    }
}

