/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.reports.api;

import edu.mit.broad.genome.Conf;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.TraceUtils;
import edu.mit.broad.genome.charts.XChart;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.objects.BitSetDataset;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.IDataframe;
import edu.mit.broad.genome.objects.Id;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.parsers.DataFormat;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.reports.RichDataframe;
import edu.mit.broad.genome.reports.api.Report;
import edu.mit.broad.genome.reports.api.ReportIndexState;
import edu.mit.broad.genome.reports.api.ToolComments;
import edu.mit.broad.genome.reports.api.ToolReportDisplay;
import edu.mit.broad.genome.reports.pages.FileWrapperPage;
import edu.mit.broad.genome.reports.pages.HtmlPage;
import edu.mit.broad.genome.reports.pages.HtmlReportIndexPage;
import edu.mit.broad.genome.reports.pages.KeyValTable;
import edu.mit.broad.genome.reports.pages.Page;
import edu.mit.broad.genome.utils.SystemUtils;
import edu.mit.broad.genome.utils.ZipUtility;
import edu.mit.broad.xbench.core.api.Application;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.io.FileUtils;
import org.apache.ecs.Element;
import org.apache.log4j.Logger;
import org.genepattern.io.ImageUtil;
import xtools.api.Tool;
import xtools.api.param.GeneSetMatrixFormatParam;
import xtools.api.param.ReportLabelParam;

public class ToolReport
implements Report {
    private transient Logger log = Logger.getLogger(this.getClass());
    private static transient Logger klog = Logger.getLogger(ToolReport.class);
    private static String COMMON_ERROR_PREFIX = "The Tool ran successfully but at least one part of the reports production failed\nwith the following details\nThe reports is INcomplete";
    private Tool fTool_opt;
    private Class fProducerClass;
    private String fProducerName;
    private File fReportDir;
    private ToolComments fToolComments;
    private final long fTimestamp = System.currentTimeMillis();
    private transient Date fDate;
    private boolean fClosed = false;
    private int fNumPagesAdded;
    private String fReportName;
    private File fReportParamsFile;
    private List fErrors;
    private Pages fPages;
    private boolean fDoneAddingCss;
    private boolean fRptDirMadeExternally = false;
    private KeyValTable fKvt;
    private HtmlReportIndexPage fHtmlReportIndexPage;
    private File fHtmlIndexPageFile;
    private ReportIndexState fReportIndexState;
    private String fOptWebBase;

    public ToolReport(Tool reportForTool, boolean cacheToolObject, ReportIndexState indexState) throws IOException, IllegalArgumentException {
        if (reportForTool == null) {
            throw new IllegalArgumentException("Parameter reportForTool cannot be null");
        }
        if (reportForTool.getParamSet().getAnalysisDirParam() == null) {
            throw new IllegalArgumentException("Specified tool does not have a declared fAnalysisDirParam(-out) -- cannot generate Report!");
        }
        File analysisEnvBaseDir = reportForTool.getParamSet().getAnalysisDirParam().getAnalysisDir();
        File rptDir = ToolReport.createIfNeededAndGetReportDir(analysisEnvBaseDir, reportForTool, this);
        this.init(reportForTool, cacheToolObject, rptDir, indexState);
    }

    private void init(Tool reportForTool_opt, boolean cacheToolObject, File useThisRptDir, ReportIndexState indexState) throws IllegalArgumentException {
        if (!useThisRptDir.exists()) {
            throw new IllegalArgumentException("Report dir does not exists!!: " + useThisRptDir.getAbsolutePath());
        }
        this.fReportDir = useThisRptDir;
        this.fToolComments = new ToolComments();
        if (reportForTool_opt != null) {
            this.fProducerClass = reportForTool_opt.getClass();
            this.fProducerName = reportForTool_opt.getClass().getName();
            if (cacheToolObject) {
                this.fTool_opt = reportForTool_opt;
            }
            if (reportForTool_opt.getParamSet().getReportLabelParam() == null) {
                throw new IllegalArgumentException("Specified tool does not have a declared ReportLabelParam -- check Tool!");
            }
            this.fReportName = ToolReport.generateReportName(this, reportForTool_opt);
            this.fReportParamsFile = new File(this.fReportDir, this.fReportName);
        }
        this.fPages = new Pages();
        this.fReportIndexState = indexState;
        if (this.fReportIndexState.makeReportIndexPage()) {
            this.fHtmlReportIndexPage = new HtmlReportIndexPage(this, this.fReportIndexState.getHeader());
        }
    }

    private static String generateReportName(Report report, Tool tool) {
        ReportLabelParam lp = tool.getParamSet().getReportLabelParam();
        String label = lp.getReportLabel();
        if (label == null) {
            label = "my_report";
        }
        label = label.trim();
        StringTokenizer tok = new StringTokenizer(tool.getClass().getName(), ".");
        String tn = null;
        while (tok.hasMoreTokens()) {
            tn = tok.nextToken();
        }
        StringBuffer rptName = new StringBuffer();
        rptName.append(label).append('.').append(tn).append('.').append(report.getTimestamp()).append('.');
        rptName.append(DataFormat.RPT_FORMAT.getExtension());
        return rptName.toString();
    }

    public File getZipReportFile() {
        return new File(this.getReportDir(), this.getName() + ".zip");
    }

    public File zipReport() {
        File zipped_file = this.getZipReportFile();
        try {
            File tmp_zipped_file = File.createTempFile(this.getName(), ".zip");
            new ZipUtility().zipDir(this.fReportDir, tmp_zipped_file);
            FileUtils.moveFile((File)tmp_zipped_file, (File)zipped_file);
        }
        catch (Throwable t) {
            this.log.error((Object)t);
            try {
                FileUtils.writeStringToFile((File)zipped_file, (String)t.getMessage());
            }
            catch (IOException ie) {
                this.log.error((Object)ie);
            }
        }
        return zipped_file;
    }

    @Override
    public URI getReportIndex() {
        if (this.fHtmlIndexPageFile == null) {
            return null;
        }
        return this.fHtmlIndexPageFile.toURI();
    }

    public File getParamsFile() {
        return new File(this.fReportParamsFile.getPath());
    }

    @Override
    public void setErroredOut() {
        try {
            if (this.fReportDir != null && this.fReportDir.exists()) {
                File errorDir = new File(this.fReportDir.getParentFile(), "error_" + this.fReportDir.getName());
                if (!this.fRptDirMadeExternally) {
                    this.closeReport(false);
                    this.log.info((Object)("Renaming rpt dir on error to: " + errorDir));
                    boolean renamed = this.fReportDir.renameTo(errorDir);
                    if (!renamed) {
                        this.log.warn((Object)("Could not rename for error to: " + errorDir));
                    }
                } else {
                    this.log.info((Object)("Pseudo Renaming rpt dir on error to: " + errorDir + " (ext made report dir so not renamed)"));
                }
            } else {
                this.log.info((Object)"No report dir was made yet (but an error condition was detected)");
            }
        }
        catch (Throwable t) {
            System.out.println("Error while erroring out! (setErroredOut in ToolReport");
            t.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return this.fReportName;
    }

    @Override
    public long getTimestamp() {
        return this.fTimestamp;
    }

    @Override
    public Date getDate() {
        if (this.fDate == null) {
            this.fDate = new Date(this.fTimestamp);
        }
        return this.fDate;
    }

    public void display() {
        if (SystemUtils.isHeadless()) {
            this.log.info((Object)"Suppressing display reports as headless mode");
        } else if (SystemUtils.isPropertyTrue("GSEA")) {
            this.log.info((Object)"Suppressing display reports as gsea app");
        } else {
            this.log.info((Object)"Displaying reports ...");
            ToolReportDisplay display = new ToolReportDisplay(this);
            display.show();
        }
    }

    @Override
    public Id getId() {
        throw new NotImplementedException();
    }

    @Override
    public String getNameEnglish() {
        return null;
    }

    @Override
    public String getQuickInfo() {
        return "" + this.fNumPagesAdded;
    }

    public HtmlReportIndexPage getIndexPage() {
        if (this.fHtmlReportIndexPage == null) {
            throw new IllegalArgumentException("HtmlReportIndexpage was not made");
        }
        return this.fHtmlReportIndexPage;
    }

    public File getIndexPageFile() {
        return this.fHtmlIndexPageFile;
    }

    @Override
    public File[] getFilesProduced() {
        List files = this.fPages.getFiles_list();
        if (this.fHtmlIndexPageFile != null && this.fHtmlIndexPageFile.exists() && !files.contains(this.fHtmlIndexPageFile)) {
            files.add(this.fHtmlIndexPageFile);
        }
        return files.toArray(new File[files.size()]);
    }

    @Override
    public int getNumPagesMade() {
        return this.fNumPagesAdded;
    }

    @Override
    public void addComment(String comment) {
        this.fToolComments.add(comment);
    }

    public void addError(String msg, Throwable t) {
        if (this.fErrors == null) {
            this.fErrors = new ArrayList();
        }
        this.fErrors.add(t);
        this.log.error((Object)msg, t);
    }

    @Override
    public String getComment() {
        throw new RuntimeException("use getToolComment instead");
    }

    public ToolComments getToolComments() {
        return this.fToolComments;
    }

    @Override
    public File getReportDir() {
        return this.fReportDir;
    }

    @Override
    public Properties getParametersUsed() {
        if (this.fTool_opt != null) {
            return this.fTool_opt.getParamSet().toProperties();
        }
        throw new IllegalStateException("Tool not cached: " + this.fTool_opt);
    }

    public Tool getTool() {
        if (this.fTool_opt != null) {
            return this.fTool_opt;
        }
        throw new IllegalStateException("Tool not cached: " + this.fTool_opt);
    }

    @Override
    public Class getProducer() {
        return this.fProducerClass;
    }

    public String getProducerName() {
        return this.fProducerName;
    }

    public File savePage(XChart xc, int width, int height, File inDir) {
        File file = ToolReport._createFile(xc.getName(), "png", inDir);
        try {
            xc.saveAsPNG(file, width, height);
            return file;
        }
        catch (Throwable t) {
            this.addError("Trouble saving png image", t);
            return file;
        }
    }

    public void savePageSvg(XChart xc, int width, int height, File file) {
        try {
            ImageUtil.saveAsSVG(xc.getFreeChart(), file, width, height, true);
        }
        catch (Throwable t) {
            this.addError("Trouble saving svg image", t);
        }
    }

    private File savePage(Page page, boolean addInvisibly2Cache) {
        File file = null;
        try {
            file = ToolReport._createFile(page.getName(), page.getExt(), this.fReportDir);
            page.write(new FileOutputStream(file));
            if (!addInvisibly2Cache) {
                this._centralAddPage(page, file);
            }
        }
        catch (Throwable t) {
            this.addError("Trouble saving Page", t);
        }
        return file;
    }

    public File savePage(Page page, File inDir) {
        File file = null;
        try {
            file = ToolReport._createFile(page.getName(), page.getExt(), inDir);
            page.write(new FileOutputStream(file));
        }
        catch (Throwable t) {
            this.addError("Trouble saving Page", t);
        }
        return file;
    }

    public File savePage(PersistentObject pob) {
        if (pob == null) {
            this.addError("Null pob specified for saving + " + pob, new Throwable());
            return null;
        }
        try {
            File inDir = this.fReportDir;
            return this.savePage(pob.getName(), pob.getQuickInfo(), pob, inDir, true);
        }
        catch (Throwable t) {
            this.addError("Trouble saving pob to report", t);
            return null;
        }
    }

    public File savePage(PersistentObject pob, boolean add2cache) {
        try {
            return this.savePage(pob.getName(), pob.getQuickInfo(), pob, this.getReportDir(), add2cache);
        }
        catch (Throwable t) {
            this.addError("Trouble saving pob to report", t);
            return null;
        }
    }

    public File savePageXls(IDataframe idf) {
        return this.savePageXls(idf, idf.getName(), this.fReportDir);
    }

    public File savePageXls(IDataframe idf, String fileName, File inDir) {
        if (idf instanceof RichDataframe) {
            StringDataframe sdf = (StringDataframe)((RichDataframe)idf).getDataframe();
            return this.savePageXls(sdf, fileName, inDir);
        }
        if (idf instanceof StringDataframe) {
            ((StringDataframe)idf).replace("NaN", "");
        }
        File file = ToolReport._createFile(fileName, DataFormat.XLS_FORMAT.getExtension(), inDir);
        try {
            ParserFactory.saveInvisibly2Cache(idf, file);
            this._centralAddPage(new FileWrapperPage(file, idf.getQuickInfo()));
        }
        catch (Throwable t) {
            this.addError("Trouble saving sdf to report", t);
        }
        return file;
    }

    private File savePage(String name, String desc, PersistentObject pob, File inDir, boolean centralAddPage) {
        File file = null;
        try {
            if (pob instanceof RankedList) {
                file = ToolReport._createFile(name, "xls", inDir);
                ParserFactory.save((RankedList)pob, file);
            } else if (pob instanceof Dataset) {
                file = ToolReport._createFile(name, DataFormat.GCT_FORMAT.getExtension(), inDir);
                ParserFactory.saveGct((Dataset)pob, file);
            } else if (pob instanceof BitSetDataset) {
                Dataset ds = ((BitSetDataset)pob).toDataset();
                file = ToolReport._createFile(name, "bsd", inDir);
                ParserFactory.saveGct(ds, file);
                File mf = ToolReport._createFile(name, "mat", inDir);
                Matrix.save(ds.getMatrix(), mf);
                this._centralAddPage(new FileWrapperPage(mf, desc));
            } else if (pob instanceof StringDataframe) {
                file = ToolReport._createFile(name, DataFormat.getExtension(pob), inDir);
                ParserFactory.save((StringDataframe)pob, file, false);
            } else if (pob instanceof LabelledVector) {
                String name1 = name;
                String desc1 = desc;
                file = this.savePage(name1, desc1, (LabelledVector)pob, this.fReportDir, true);
            } else {
                file = ToolReport._createFile(name, DataFormat.getExtension(pob), inDir);
                ParserFactory.save(pob, file);
            }
            if (file != null) {
                this._centralAddPage(new FileWrapperPage(file, desc), centralAddPage);
            }
        }
        catch (Throwable t) {
            this.addError("Trouble saving pob to reports", t);
        }
        return file;
    }

    public File savePageGmx(GeneSetMatrix gmx) {
        File saveInDir = this.fReportDir;
        StringBuffer name = new StringBuffer(gmx.getName()).append('.').append(DataFormat.GMX_FORMAT.getExtension());
        File file = ToolReport.createSafeReportFile(name.toString(), saveInDir);
        this.log.debug((Object)("saving gmt in: " + file));
        try {
            ParserFactory.save(gmx, file);
            this._centralAddPage(new FileWrapperPage(file, gmx.getQuickInfo()));
        }
        catch (Throwable t) {
            this.addError("Could not save object to reports object: " + gmx + " in file: " + file.getPath(), t);
        }
        return file;
    }

    private File savePage(String name, String desc, String content) {
        StringBuffer fname = new StringBuffer(name).append('.').append("xls");
        File file = ToolReport.createSafeReportFile(fname.toString(), this.getReportDir());
        try {
            this.log.debug((Object)("saving in: " + file));
            FileUtils.writeStringToFile((File)file, (String)content);
            this._centralAddPage(new FileWrapperPage(file, desc));
        }
        catch (Throwable t) {
            this.addError("Could not save object to reports data: " + name + " in file: " + file.getPath(), t);
        }
        return file;
    }

    private void _centralAddPage(Page page, File file) {
        if (this.fReportIndexState.keepTrackOfPages() && !(page instanceof HtmlReportIndexPage)) {
            this.fPages.add(page, file);
        }
        ++this.fNumPagesAdded;
        if (page instanceof HtmlPage) {
            this.createCss();
        }
    }

    private void createCss() {
        if (!this.fDoneAddingCss) {
            this.createCss(this.fReportDir);
        }
        this.fDoneAddingCss = true;
    }

    private void createCss(File inDir) {
        try {
            File cssFile = ToolReport._createFile("xtools", "css", inDir);
            FileUtils.copyURLToFile((URL)JarResources.toURL("xtools.css"), (File)cssFile);
        }
        catch (Throwable t) {
            this.log.error((Object)"Trouble copying over CSS", t);
        }
    }

    public File createSubDir(String name) {
        boolean made;
        File subDir = NamingConventions.createSafeFile(this.getReportDir(), name);
        if (!subDir.exists() && !(made = subDir.mkdir())) {
            throw new IllegalStateException("Unable to make an output folder for the report at: " + subDir.getPath());
        }
        this.createCss(subDir);
        return subDir;
    }

    private void _centralAddPage(FileWrapperPage page) {
        this._centralAddPage(page, this.fReportIndexState.keepTrackOfPages());
    }

    private void _centralAddPage(FileWrapperPage page, boolean keepTrack) {
        if (page == null) {
            throw new IllegalArgumentException("Param page cannot be null");
        }
        if (keepTrack) {
            this.fPages.add(page);
        }
        ++this.fNumPagesAdded;
        if (this.fReportIndexState.keepTrackOfPagesInHtmlIndex()) {
            if (this.fKvt == null) {
                this.fKvt = new KeyValTable();
            }
            this.fKvt.addRow(page.getDesc(), (Element)page.createLink(this.fReportDir, this.fOptWebBase));
        }
    }

    public void closeReport(boolean add2ParserFactory) {
        if (this.fClosed) {
            return;
        }
        if (this.fReportParamsFile != null && this.fReportParamsFile.exists()) {
            this._centralAddPage(new FileWrapperPage(this.fReportParamsFile, "List of parameters used by the tool (rpt)"));
        }
        StringBuffer ebuf = null;
        try {
            if (this.fErrors != null && this.fErrors.size() != 0) {
                ebuf = new StringBuffer(COMMON_ERROR_PREFIX);
                for (int i = 0; i < this.fErrors.size(); ++i) {
                    ebuf.append("ERROR ").append(i + 1).append('\n');
                    Throwable t = (Throwable)this.fErrors.get(i);
                    ebuf.append(t.getMessage()).append('\n');
                    ebuf.append("---------------------------------------------------");
                    ebuf.append(TraceUtils.getAsString(t)).append('\n');
                }
                this.savePage("there_were_reporting_errors", "reporting errors", ebuf.toString());
            }
        }
        catch (Throwable t) {
            this.log.error((Object)"Errors adding errors to reports!", t);
        }
        if (this.fHtmlReportIndexPage != null) {
            try {
                if (ebuf != null && ebuf.length() > 0) {
                    this.fHtmlReportIndexPage.addError(ebuf.toString());
                }
                if (this.fKvt != null && this.fReportIndexState.keepTrackOfPagesInHtmlIndex()) {
                    this.fHtmlReportIndexPage.addTable("Result files produced in this analysis", this.fKvt);
                }
                this.fHtmlIndexPageFile = this.savePage((Page)this.fHtmlReportIndexPage, false);
            }
            catch (Throwable t) {
                this.log.error((Object)"Error making HtmlIndexPage -- report content may otherwise be OK", t);
            }
        }
        if (this.fTool_opt != null && add2ParserFactory && this.fReportParamsFile != null && !this.fReportParamsFile.exists()) {
            try {
                ParserFactory.save(this, this.fReportParamsFile);
            }
            catch (Throwable t) {
                this.log.error((Object)"Error closing report -- suppressing", t);
            }
        }
        if (add2ParserFactory) {
            try {
                if (this.fReportParamsFile != null) {
                    File cacheFile = new File(Application.getVdbManager().getReportsCacheDir(), this.fReportParamsFile.getName());
                    ParserFactory.save(this, cacheFile, false);
                }
            }
            catch (Throwable t) {
                this.log.error((Object)"Error saving report to cahche -- suppressing", t);
            }
        }
        this.fClosed = true;
    }

    public File createFile(String name, String desc) {
        File file = ToolReport.createSafeReportFile(name, this.fReportDir);
        this._centralAddPage(new FileWrapperPage(file, desc));
        return file;
    }

    public File savePage(GeneSetMatrix gm, GeneSetMatrixFormatParam gmf) {
        return this.savePage(gm.getQuickInfo(), gm, gmf);
    }

    public File savePage(String desc, GeneSetMatrix gm, GeneSetMatrixFormatParam gmf) {
        try {
            if (gmf.getDataFormat() == DataFormat.GMT_FORMAT) {
                return this.savePageGmt(desc, gm);
            }
            if (gmf.getDataFormat() == DataFormat.GMX_FORMAT) {
                return this.savePage(desc, gm);
            }
            this.log.warn((Object)("Unkown gm format: " + gmf.getDataFormat()));
            return this.savePageGmt(desc, gm);
        }
        catch (Throwable t) {
            this.addError("Trouble saving pob to reports", t);
            return null;
        }
    }

    public File savePageGmt(String desc, GeneSetMatrix gmt) {
        StringBuffer name = new StringBuffer(gmt.getName()).append('.').append(DataFormat.GMT_FORMAT.getExtension());
        File file = this.createSafeReportFile(name.toString());
        this.log.debug((Object)("saving gmt in: " + file));
        try {
            ParserFactory.saveGmt(gmt, file);
            this._centralAddPage(new FileWrapperPage(file, desc));
        }
        catch (Throwable t) {
            this.addError("Could not save object to reports object: " + gmt + " in file: " + file.getPath(), t);
        }
        return file;
    }

    public File savePage(String desc, GeneSetMatrix gmx) {
        return this.savePage(desc, gmx, this.fReportDir);
    }

    private File createSafeReportFile(String name) {
        return ToolReport.createSafeReportFile(name, this.fReportDir);
    }

    public File savePage(String desc, GeneSetMatrix gmx, File saveInDir) {
        StringBuffer name = new StringBuffer(gmx.getName()).append('.').append(DataFormat.GMX_FORMAT.getExtension());
        File file = ToolReport.createSafeReportFile(name.toString(), saveInDir);
        this.log.debug((Object)("saving gmt in: " + file));
        try {
            ParserFactory.save(gmx, file);
            this._centralAddPage(new FileWrapperPage(file, desc));
        }
        catch (Throwable t) {
            this.addError("Could not save object to reports object: " + gmx + " in file: " + file.getPath(), t);
        }
        return file;
    }

    public File savePageTxt(String name, String desc, String content, boolean silent, boolean add2cache) {
        return this.savePage(name, desc, content, "txt", silent, add2cache);
    }

    public File savePage(String name, String desc, String content, String ext, boolean silent, boolean add2Cache) {
        return this.savePage(name, desc, content, ext, this.getReportDir(), silent, add2Cache);
    }

    public File savePage(String name, String desc, String content, String ext, File saveInDir, boolean silent, boolean add2Cache) {
        StringBuffer fname = new StringBuffer(name).append('.').append(ext);
        File file = ToolReport.createSafeReportFile(fname.toString(), saveInDir);
        try {
            if (!silent) {
                this.log.debug((Object)("saving in: " + file));
            }
            FileUtils.writeStringToFile((File)file, (String)content);
            if (add2Cache) {
                this._centralAddPage(new FileWrapperPage(file, desc));
            }
        }
        catch (Throwable t) {
            this.addError("Could not save object to reports data: " + name + " in file: " + file.getPath(), t);
        }
        return file;
    }

    private static File _createFile(String fname, String suffix, File inDir) {
        File file = null;
        try {
            boolean made;
            StringBuffer name = fname.endsWith(suffix) ? new StringBuffer(fname) : new StringBuffer(fname).append('.').append(suffix);
            file = ToolReport.createSafeReportFile(name.toString(), inDir);
            if (edu.mit.broad.genome.utils.FileUtils.isLocked(file)) {
                int max = fname.length();
                if (max > 10) {
                    max = 10;
                }
                name = new StringBuffer(fname.substring(0, max)).append(".WARNING_renamed_on_detecting_lock").append(System.currentTimeMillis()).append('.').append(suffix);
                String name_str = NamingConventions.createSafeFileName(name.toString());
                file = new File(inDir, name_str);
            }
            if (!file.exists() && !(made = file.createNewFile())) {
                throw new IOException("Could not make file: " + file.getAbsolutePath());
            }
        }
        catch (Throwable t) {
            if (file == null) {
                file = ToolReport.createSafeReportFile("tmp_report_error_file." + System.currentTimeMillis() + suffix, inDir);
            }
            StringBuffer err = new StringBuffer("Fatal error making file to save a component of the reports in");
            err.append("\nInstead using a result file: ").append(file.getPath());
            klog.fatal((Object)err, t);
        }
        return file;
    }

    private static File createSafeReportFile(String name, File inDir) {
        return NamingConventions.createSafeFile(inDir, name);
    }

    private static File createIfNeededAndGetReportDir(File rptWorkingBaseDir, Tool tool, Report rpt) throws IOException {
        boolean made;
        boolean made2;
        if (!rptWorkingBaseDir.exists() && !(made2 = rptWorkingBaseDir.mkdir())) {
            throw new IOException("Could not make analysis(-out) results dir at: " + rptWorkingBaseDir);
        }
        File rptDir = ToolReport.generateReportDir(rpt, tool);
        if (!rptDir.exists() && !(made = rptDir.mkdir())) {
            throw new IOException("Could not make a directory to store the Tool reports in. The location attempted was: " + rptDir.getAbsolutePath());
        }
        return rptDir;
    }

    private static File generateReportDir(Report report, Tool tool) {
        if (Conf.isMakeReportDirOffMode()) {
            return tool.getParamSet().getAnalysisDirParam().getAnalysisDir();
        }
        ReportLabelParam lp = tool.getParamSet().getReportLabelParam();
        String label = lp.getReportLabel();
        if (label == null || label.length() == 0) {
            label = "my_report";
        }
        label = label.trim();
        StringTokenizer tok = new StringTokenizer(tool.getClass().getName(), ".");
        String toolName = null;
        while (tok.hasMoreTokens()) {
            toolName = tok.nextToken();
        }
        StringBuffer rptName = new StringBuffer(label).append('.').append(toolName);
        rptName.append('.').append(report.getTimestamp());
        return new File(tool.getParamSet().getAnalysisDirParam().getAnalysisDir(), rptName.toString());
    }

    private static class Pages
    implements Serializable {
        private List plist = new ArrayList();
        private List flist = new ArrayList();

        Pages() {
        }

        private void writeObject(ObjectOutputStream out) {
            klog.debug((Object)("Ignoring: " + out));
        }

        private void readObject(ObjectInputStream in) {
            klog.debug((Object)("Ignoring: " + in));
        }

        void add(Page page, File file) {
            this.plist.add(page);
            this.flist.add(file);
        }

        void add(FileWrapperPage page) {
            this.plist.add(page);
            this.flist.add(page.getFile());
        }

        List getFiles_list() {
            return this.flist;
        }
    }
}

