/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.objects.Annot;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.SampleAnnot;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserException;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class TxtDatasetParser
extends AbstractParser {
    public TxtDatasetParser() {
        super(Dataset.class);
    }

    @Override
    public void export(PersistentObject pob, File file) throws Exception {
        PrintWriter pw = this.startExport(pob, file);
        Dataset ds = (Dataset)pob;
        FeatureAnnot ann = ds.getAnnot().getFeatureAnnot();
        pw.print("NAME\tDESCRIPTION\t");
        for (int i = 0; i < ds.getNumCol(); ++i) {
            pw.print(ds.getColumnName(i));
            pw.print('\t');
        }
        pw.println();
        for (int r = 0; r < ds.getNumRow(); ++r) {
            String featname = ds.getRowName(r);
            pw.print(featname);
            pw.print('\t');
            String desc = ann.getNativeDesc(featname);
            if (desc != null) {
                pw.print(desc);
            } else {
                pw.print("na");
            }
            pw.print('\t');
            pw.println(ds.getRow(r).toString('\t'));
        }
        pw.close();
        this.doneExport();
    }

    @Override
    public List parse(String sourcepath, InputStream is) throws Exception {
        this.startImport(sourcepath);
        BufferedReader bin = new BufferedReader(new InputStreamReader(is));
        return this.parse(sourcepath, bin);
    }

    public List parse(String objName, BufferedReader bin) throws Exception {
        objName = NamingConventions.removeExtension(objName);
        String currLine = this.nextLine(bin);
        List<String> colnames = ParseUtils.string2stringsList(currLine, "\t");
        colnames.remove(0);
        boolean hasDesc = false;
        if (colnames.get(0).toString().equalsIgnoreCase("DESCRIPTION") || colnames.get(0).toString().equalsIgnoreCase("DESC")) {
            colnames.remove(0);
            hasDesc = true;
        }
        this.log.debug((Object)("HAS DESC: " + hasDesc));
        ArrayList<String> lines = new ArrayList<String>();
        currLine = this.nextLineTrimless(bin);
        while (currLine != null) {
            lines.add(currLine);
            currLine = this.nextLineTrimless(bin);
        }
        bin.close();
        if (hasDesc) {
            return this._parseHasDesc(objName, lines, colnames);
        }
        return this._parseNoDesc(objName, lines, colnames);
    }

    private List _parseNoDesc(String objName, List lines, List colNames) throws Exception {
        objName = NamingConventions.removeExtension(objName);
        Matrix matrix = new Matrix(lines.size(), colNames.size());
        ArrayList<String> rowNames = new ArrayList<String>();
        ArrayList<String> rowDescs = new ArrayList<String>();
        for (int i = 0; i < lines.size(); ++i) {
            String currLine = (String)lines.get(i);
            List fields = TxtDatasetParser.string2stringsV2(currLine, colNames.size() + 1);
            if (fields.size() != colNames.size() + 1) {
                throw new ParserException("Bad format - expect ncols: " + (colNames.size() + 1) + " but found: " + fields.size() + " on line >" + currLine + "<\nIf this dataset has missing values, use ImputeDataset to fill these in before importing as a Dataset");
            }
            String rowname = fields.get(0).toString().trim();
            if (rowname.length() == 0) {
                throw new ParserException("Bad rowname - cant be empty at: " + i + " >" + currLine);
            }
            String desc = "na";
            rowDescs.add(desc);
            rowNames.add(rowname);
            int coln = 0;
            for (int f = 1; f < fields.size(); ++f) {
                float val;
                String s = fields.get(f).toString().trim();
                if (s.length() == 0) {
                    val = Float.NaN;
                } else {
                    try {
                        val = Float.parseFloat(s);
                    }
                    catch (Exception e) {
                        System.out.println(">" + s + "<");
                        throw e;
                    }
                }
                matrix.setElement(i, coln++, val);
            }
        }
        FeatureAnnot ann = new FeatureAnnot(objName, rowNames, rowDescs);
        ann.addComment(this.fComment.toString());
        SampleAnnot sann = new SampleAnnot(objName, colNames);
        DefaultDataset ds = new DefaultDataset(objName, matrix, rowNames, colNames, true, new Annot(ann, sann));
        ds.addComment(this.fComment.toString());
        this.doneImport();
        return TxtDatasetParser.unmodlist(new PersistentObject[]{ds});
    }

    private List _parseHasDesc(String objName, List lines, List colNames) throws Exception {
        objName = NamingConventions.removeExtension(objName);
        Matrix matrix = new Matrix(lines.size(), colNames.size());
        ArrayList<String> rowNames = new ArrayList<String>();
        ArrayList<String> rowDescs = new ArrayList<String>();
        for (int i = 0; i < lines.size(); ++i) {
            String currLine = (String)lines.get(i);
            List fields = TxtDatasetParser.string2stringsV2(currLine, colNames.size() + 2);
            if (fields.size() != colNames.size() + 2) {
                throw new ParserException("Bad format - expect ncols: " + (colNames.size() + 2) + " but found: " + fields.size() + " on line >" + currLine + "<\nIf this dataset has missing values, use ImputeDataset to fill these in before importing as a Dataset");
            }
            String rowname = fields.get(0).toString().trim();
            if (rowname.length() == 0) {
                throw new ParserException("Bad rowname - cant be empty at: " + i + " >" + currLine);
            }
            String desc = fields.get(1).toString().trim();
            if (desc.length() == 0) {
                desc = "na";
            }
            rowDescs.add(desc);
            rowNames.add(rowname);
            int coln = 0;
            for (int f = 2; f < fields.size(); ++f) {
                float val;
                String s = fields.get(f).toString().trim();
                if (s.length() == 0) {
                    val = Float.NaN;
                } else {
                    try {
                        val = Float.parseFloat(s);
                    }
                    catch (Exception e) {
                        System.out.println(">" + s + "<");
                        throw e;
                    }
                }
                matrix.setElement(i, coln++, val);
            }
        }
        FeatureAnnot ann = new FeatureAnnot(objName, rowNames, rowDescs);
        ann.addComment(this.fComment.toString());
        SampleAnnot sann = new SampleAnnot(objName, colNames);
        DefaultDataset ds = new DefaultDataset(objName, matrix, rowNames, colNames, true, new Annot(ann, sann));
        ds.addComment(this.fComment.toString());
        this.doneImport();
        return TxtDatasetParser.unmodlist(new PersistentObject[]{ds});
    }
}

