/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.alg.RankedListGenerators;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserException;
import gnu.trove.TFloatArrayList;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class RankedListParser
extends AbstractParser {
    public RankedListParser() {
        super(RankedList.class);
    }

    @Override
    public void export(PersistentObject pob, File file) throws Exception {
        RankedList rl = (RankedList)pob;
        PrintWriter pw = this.startExport(pob, file);
        for (int i = 0; i < rl.getSize(); ++i) {
            pw.println(rl.getRankName(i) + "\t" + rl.getScore(i));
        }
        pw.close();
        this.doneExport();
    }

    @Override
    public List parse(String sourcepath, InputStream is) throws Exception {
        this.startImport(sourcepath);
        BufferedReader bin = new BufferedReader(new InputStreamReader(is));
        return this._parse(sourcepath, bin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List _parse(String objname, BufferedReader buf) throws Exception {
        String currLine = this.nextLine(buf);
        objname = NamingConventions.removeExtension(new File(objname).getName());
        ArrayList<String> names = new ArrayList<String>();
        TFloatArrayList floats = new TFloatArrayList();
        int cnt = 0;
        while (currLine != null) {
            String[] fields = ParseUtils.string2strings(currLine, "\t");
            if (fields.length != 2) {
                throw new ParserException("Bad rnk file format exception - expected 2 fields but got: " + fields.length + " line>" + currLine + "<");
            }
            boolean doParse = true;
            if (fields[0].equalsIgnoreCase("Name") || fields[1].equalsIgnoreCase("Rank")) {
                doParse = false;
            }
            if (cnt == 0) {
                try {
                    Float.parseFloat(fields[1]);
                }
                catch (Throwable t) {
                    doParse = false;
                }
                finally {
                    ++cnt;
                }
            }
            if (doParse) {
                names.add(fields[0]);
                floats.add(Float.parseFloat(fields[1]));
            }
            currLine = this.nextLine(buf);
        }
        buf.close();
        this.doneImport();
        RankedList rl = RankedListGenerators.createBySorting(objname, names.toArray(new String[names.size()]), floats.toNativeArray(), SortMode.REAL, Order.DESCENDING);
        return RankedListParser.unmodlist(rl);
    }
}

