/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.markers;

import edu.mit.broad.genome.alg.DatasetMetrics;
import edu.mit.broad.genome.alg.DatasetStatsCore;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.alg.RankedListGenerators;
import edu.mit.broad.genome.alg.markers.AbstractPermutationTest;
import edu.mit.broad.genome.math.LabelledVectorProcessor;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.MetricWeightStruc;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.ScoredDataset;
import edu.mit.broad.genome.objects.Template;
import gnu.trove.TIntArrayList;
import java.util.Map;

public class PermutationTestBuilder
extends AbstractPermutationTest {
    private Template[] fRndTemplates;
    private ScoredDataset fRealScoredDataset;
    private TIntArrayList fMetricCrossOverRanks;
    private MetricWeightStruc[] fRndMetricWeightStrucs;
    private Matrix nMarkersUpMatrix;
    private Matrix nMarkersDnMatrix;
    private int fNumSetCalls;
    private RankedList fRealRankedList;

    public PermutationTestBuilder(String name, int numMarkers, int nperm, LabelledVectorProcessor lvp, Metric metric, SortMode sort, Order order, Map metricParams, Dataset ds, Template template, float[] siglevels, boolean categorical) {
        super.init(name, numMarkers, nperm, lvp, metric, sort, order, metricParams, ds, template, siglevels, categorical);
        DatasetMetrics dm = new DatasetMetrics();
        this.fRealScoredDataset = dm.scoreDataset(this.fMetric, this.fSort, this.fOrder, this.fMetricParams, this.fLabelledVectorProc, this.getDataset(), this.getTemplate());
        if (categorical) {
            Map map = new DatasetStatsCore().calc2ClassCategoricalMetricMarkerScores(this.getDataset(), this.getTemplate(), this.fMetric, this.fMetricParams);
        }
        this.nMarkersUpMatrix = new Matrix(this.fNumMarkers, this.fNumPerms);
        this.nMarkersDnMatrix = new Matrix(this.fNumMarkers, this.fNumPerms);
        this.fRndTemplates = new Template[this.fNumPerms];
        this.fMetricCrossOverRanks = new TIntArrayList(this.fNumPerms);
        this.fRndMetricWeightStrucs = new MetricWeightStruc[this.fNumPerms];
    }

    public void doCalc() {
        this.checkIfDone();
        this.calcAndSetSignificanceLevels(this.nMarkersUpMatrix, this.nMarkersDnMatrix);
    }

    public void addRnd(Template rndTemplate, RankedList rndRl) {
        if (this.fNumSetCalls == this.getNumPerms()) {
            throw new IllegalStateException("Already done fNumSetCalls: " + this.fNumSetCalls + " getNumPerms: " + this.getNumPerms());
        }
        this.fRndTemplates[this.fNumSetCalls] = rndTemplate;
        for (int r = 0; r < this.fNumMarkers; ++r) {
            this.nMarkersUpMatrix.setElement(r, this.fNumSetCalls, rndRl.getScore(r));
        }
        int p = this.getDataset().getNumRow() - 1;
        int cnt = 0;
        while (cnt < this.fNumMarkers) {
            this.nMarkersDnMatrix.setElement(cnt, this.fNumSetCalls, rndRl.getScore(p));
            ++cnt;
            --p;
        }
        for (int r = 0; r < rndRl.getSize(); ++r) {
            if (!XMath.isNegative(rndRl.getScore(r))) continue;
            this.fMetricCrossOverRanks.add(r + 1);
            break;
        }
        this.fRndMetricWeightStrucs[this.fNumSetCalls] = rndRl.getMetricWeightStruc();
        ++this.fNumSetCalls;
    }

    private void checkIfDone() {
        if (this.fNumSetCalls != this.getNumPerms()) {
            throw new IllegalStateException("Not yet done: fNumSetCalls: " + this.fNumSetCalls + " nperm: " + this.getNumPerms());
        }
    }

    @Override
    public RankedList getRankedList() {
        if (this.fRealRankedList == null) {
            this.fRealRankedList = RankedListGenerators.createBySorting(this.fRealScoredDataset, this.fSort, this.fOrder);
        }
        return this.fRealRankedList;
    }
}

