/*
 * Decompiled with CFR 0.152.
 */
package xtools.munge;

import edu.mit.broad.genome.alg.DatasetGenerators;
import edu.mit.broad.genome.math.StringMatrix;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.vdb.chip.Chip;
import java.util.Properties;
import xtools.api.AbstractTool;
import xtools.api.ToolCategory;
import xtools.api.param.BooleanParam;
import xtools.api.param.ChipOptParam;
import xtools.api.param.DatasetReqdParam;
import xtools.api.param.ModeReqdParam;

public class CollapseDataset
extends AbstractTool {
    private final ChipOptParam fChipParam = new ChipOptParam(true);
    private final DatasetReqdParam fDatasetParam = new DatasetReqdParam();
    private final ModeReqdParam fModeParm = new ModeReqdParam("mode", "Collapsing mode for probe sets => 1 gene", "Collapsing mode for probe sets => 1 gene", "Max_probe", new String[]{"Max_probe", "Median_of_probes", "Mean_of_probes", "Sum_of_probes", "Remap_only"});
    private final BooleanParam fIncludeOnlySymbols = new BooleanParam("include_only_symbols", "Omit features with no symbol match", "If there is no known gene symbol match for a probe set omit if from the collapsed dataset", true, false);

    public CollapseDataset(Properties properties) {
        super.init(properties);
    }

    public CollapseDataset(String[] args) {
        super.init(args);
    }

    public CollapseDataset() {
        this.declareParams();
    }

    @Override
    public String getName() {
        return "CollapseDataset";
    }

    @Override
    public void execute() throws Exception {
        this.startExec();
        Chip chip = this.fChipParam.getChip();
        Dataset ds = this.fDatasetParam.getDataset();
        DatasetGenerators.CollapsedDataset cds = new DatasetGenerators().collapse_core(ds, chip, this.fIncludeOnlySymbols.isTrue(), this.fModeParm.getStringIndexChoosen());
        this.log.debug((Object)("# after collapsing: " + cds.symbolized.getNumRow()));
        this.fReport.savePage(cds.symbolized);
        String[] colNames = new String[]{"# MATCHING PROBE SETS", "MATCHING PROBE SET(S)"};
        String[] rowNames = new String[cds.symbolized.getNumRow()];
        StringMatrix sm = new StringMatrix(rowNames.length, colNames.length);
        for (int r = 0; r < cds.symbolized.getNumRow(); ++r) {
            rowNames[r] = cds.symbolized.getRowName(r);
            DatasetGenerators.CollapseStruc cs = (DatasetGenerators.CollapseStruc)cds.symbolCollapseStrucMap.get(cds.symbolized.getRowName(r));
            sm.setElement(r, 0, cs.getProbes().length);
            sm.setElement(r, 1, cs.getProbes());
        }
        this.fReport.savePageXls(new StringDataframe("Symbol_to_probe_set_mapping_details", sm, rowNames, colNames, true));
        this.doneExec();
    }

    @Override
    public String getDesc() {
        return "Collapse expression values from multiple probe sets of a gene to a single value";
    }

    @Override
    public ToolCategory getCategory() {
        return ToolCategory.DATASET;
    }

    @Override
    public void declareParams() {
        this.fParamSet.addParam(this.fChipParam);
        this.fParamSet.addParam(this.fDatasetParam);
        this.fParamSet.addParam(this.fIncludeOnlySymbols);
        this.fParamSet.addParam(this.fModeParm);
    }

    public static void main(String[] args) {
        CollapseDataset tool = new CollapseDataset(args);
        CollapseDataset.tool_main(tool);
    }
}

