/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.ui;

import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.core.api.DialogDescriptor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;
import xtools.api.ui.NamedModel;

public class GeneSetMatrixChooserWindow {
    private static final Logger klog = Logger.getLogger(GeneSetMatrixChooserWindow.class);
    private JList[] jlGenes;
    private final JTextArea taGenes = new JTextArea();
    private NamedModel[] fModels;
    private int fSelectionMode = 0;
    private JTabbedPane tab;

    public Object[] show() {
        int i;
        if (this.jlGenes == null) {
            return null;
        }
        for (i = 0; i < this.jlGenes.length; ++i) {
            this.jlGenes[i].setModel(this.fModels[i].model);
            this.jlGenes[i].setSelectionMode(this.fSelectionMode);
        }
        for (i = 0; i < this.jlGenes.length; ++i) {
        }
        return this._just_show();
    }

    public Object[] showDirectlyWithModels(NamedModel[] models, int selMode, DefaultListCellRenderer rend) {
        int i;
        this.fModels = models;
        if (this.jlGenes == null) {
            this.jlGenes = new JList[models.length];
            for (i = 0; i < models.length; ++i) {
                this.jlGenes[i] = new JList();
                this.jlGenes[i].setCellRenderer(rend);
            }
        }
        this.fSelectionMode = selMode;
        for (i = 0; i < models.length; ++i) {
            this.jlGenes[i].setModel(models[i].model);
            this.jlGenes[i].setSelectionMode(selMode);
        }
        return this._just_show();
    }

    private Object[] _just_show() {
        String[] strs;
        String text = "Select a gene set";
        if (this.fSelectionMode == 2) {
            text = "Select one or more gene sets(s)";
        }
        this.taGenes.setText("");
        this.taGenes.setBorder(BorderFactory.createTitledBorder("Make an 'on-the-fly' gene set: Enter features below, one per line"));
        if (this.tab == null) {
            this.tab = new JTabbedPane();
            for (int i = 0; i < this.jlGenes.length; ++i) {
                this.tab.addTab(this.fModels[i].name, new JScrollPane(this.jlGenes[i]));
            }
            this.tab.addTab("Text entry", new JScrollPane(this.taGenes));
        }
        JPanel dummy = new JPanel(new BorderLayout());
        dummy.add((Component)this.tab, "Center");
        DialogDescriptor desc = Application.getWindowManager().createDialogDescriptor(text, dummy, JarResources.createHelpAction("gmx"), true);
        for (int i = 0; i < this.jlGenes.length; ++i) {
            desc.enableDoubleClickableJList(this.jlGenes[i]);
        }
        int res = desc.show();
        if (res == 2) {
            return null;
        }
        ArrayList<Object> allValues = new ArrayList<Object>();
        for (int j = 0; j < this.jlGenes.length; ++j) {
            Object[] sels = this.jlGenes[j].getSelectedValues();
            if (sels == null) continue;
            for (int i = 0; i < sels.length; ++i) {
                if (sels[i] == null) continue;
                allValues.add(sels[i]);
            }
        }
        String s = this.taGenes.getText();
        if (s != null && (strs = ParseUtils.string2strings(s, "\t\n")).length != 0) {
            GeneSet gset = new GeneSet("from_text_entry_", strs);
            try {
                ParserFactory.save(gset, File.createTempFile(gset.getName(), ".grp"));
            }
            catch (Throwable t) {
                klog.error((Object)t);
            }
            allValues.add(gset);
        }
        return allValues.toArray(new Object[allValues.size()]);
    }
}

