/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.menu.jfree;

import edu.mit.broad.genome.StandardException;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import org.genepattern.io.ImageUtil;
import org.genepattern.menu.PlotAction;
import org.genepattern.uiutil.FileChooser;
import org.genepattern.uiutil.UIUtil;
import org.jfree.chart.ChartPanel;

public class JFreeSaveImageAction
extends PlotAction {
    private final Frame parent;

    public JFreeSaveImageAction(Frame parent) {
        if (parent == null) {
            throw new NullPointerException("Null parent not allowed");
        }
        this.putValue("Name", "Save Image");
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (!FileChooser.RUNNING_ON_MAC) {
                this.saveImage();
            }
        }
        catch (Exception x) {
            this.showError(x, "An error occurred while saving the plot.");
        }
    }

    @Override
    public JMenuItem[] getSubMenuItems() {
        if (!FileChooser.RUNNING_ON_MAC) {
            return null;
        }
        final JMenuItem jpegItem = new JMenuItem("jpeg...");
        final JMenuItem pngItem = new JMenuItem("png...");
        final JMenuItem svgItem = new JMenuItem("svg...");
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String fileFormat = null;
                if (e.getSource() == jpegItem) {
                    fileFormat = "jpeg";
                } else if (e.getSource() == pngItem) {
                    fileFormat = "png";
                } else if (e.getSource() == svgItem) {
                    fileFormat = "svg";
                }
                File outputFile = FileChooser.showSaveDialog(JFreeSaveImageAction.this.parent);
                if (outputFile != null) {
                    JFreeSaveImageAction.this.save(outputFile, fileFormat);
                }
            }
        };
        jpegItem.addActionListener(l);
        pngItem.addActionListener(l);
        svgItem.addActionListener(l);
        return new JMenuItem[]{jpegItem, pngItem, svgItem};
    }

    private void saveImage() throws Exception {
        if (Double.parseDouble(System.getProperty("java.specification.version")) < 1.4) {
            UIUtil.showMessageDialog(this.getPlot().getTopLevelAncestor(), "Java 1.4 is required to save an image.");
            return;
        }
        File outputFile = null;
        String outputFileFormat = null;
        if (!FileChooser.RUNNING_ON_MAC) {
            JFileChooser fc = new JFileChooser();
            fc.setAcceptAllFileFilterUsed(false);
            fc.addChoosableFileFilter(new SaveImageFileFilter(new String[]{"jpeg", "jpg"}, "JPEG image", "JPEG"));
            fc.addChoosableFileFilter(new SaveImageFileFilter(new String[]{"png"}, "PNG image", "PNG"));
            fc.addChoosableFileFilter(new SaveImageFileFilter(new String[]{"svg"}, "SVG image", "SVG"));
            if (fc.showSaveDialog(this.getPlot().getTopLevelAncestor()) == 0) {
                outputFile = fc.getSelectedFile();
                outputFileFormat = ((SaveImageFileFilter)fc.getFileFilter()).getFileFormat();
                if (!FileChooser.overwriteFile(this.getPlot().getTopLevelAncestor(), outputFile)) {
                    return;
                }
            }
        }
        if (outputFile != null) {
            this.save(outputFile, outputFileFormat);
        }
    }

    private void save(File outputFileIn, final String outputFileFormat) {
        final File outputFile = outputFileIn;
        final ChartPanel plot = (ChartPanel)this.getPlot();
        SwingWorker<Object, Void> worker = new SwingWorker<Object, Void>(){

            @Override
            protected Object doInBackground() throws Exception {
                try {
                    ImageUtil.savePlotImage(plot, outputFile, outputFileFormat);
                }
                catch (StandardException se) {
                    UIUtil.showErrorDialog(JFreeSaveImageAction.this.getPlot().getTopLevelAncestor(), se.getMessage());
                }
                return null;
            }
        };
        worker.execute();
    }

    private void showError(Exception e, String msg) {
        if (e.getMessage() != null) {
            msg = (String)msg + "\nCause: " + e.getMessage();
        }
        UIUtil.showErrorDialog(this.getPlot().getTopLevelAncestor(), (String)msg);
    }

    public static class SaveImageFileFilter
    extends FileFilter {
        private final List<String> extensions;
        private final String fileFormat;
        private final String description;

        public SaveImageFileFilter(String[] extensions, String description, String fileFormat) {
            this.extensions = Arrays.asList(extensions);
            this.description = description;
            this.fileFormat = fileFormat;
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            int dotIndex = name.lastIndexOf(".");
            if (dotIndex > 0) {
                String ext = name.substring(dotIndex + 1, name.length());
                return this.extensions.contains(ext.toLowerCase());
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public String getFileFormat() {
            return this.fileFormat;
        }
    }
}

