/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.searchers;

import com.jidesoft.list.QuickListFilterField;
import com.jidesoft.swing.JideTitledBorder;
import com.jidesoft.swing.PartialEtchedBorder;
import com.jidesoft.swing.SearchableUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.log4j.Logger;

public class GeneSearchList {
    private JPanel fMainPanel;
    private List fFeatureNames;
    private JList fSearchList;
    private DefaultListModel listModel;
    private Logger log = Logger.getLogger(GeneSearchList.class);

    public GeneSearchList() {
        this.fFeatureNames = new ArrayList();
    }

    public JComponent getComponent() {
        if (this.fMainPanel == null) {
            this.jbInit();
        }
        return this.fMainPanel;
    }

    public JList getJList() {
        if (this.fMainPanel == null) {
            this.jbInit();
        }
        return this.fSearchList;
    }

    public void setFeatures(List featureNames) {
        this.log.debug((Object)("setFeatures: " + featureNames.size()));
        this.fFeatureNames = featureNames;
        this.listModel.removeAllElements();
        for (int i = 0; i < this.fFeatureNames.size(); ++i) {
            this.listModel.addElement(this.fFeatureNames.get(i));
        }
        this.fSearchList.revalidate();
        this.fMainPanel.revalidate();
    }

    public void jbInit() {
        this.listModel = new DefaultListModel();
        for (int i = 0; i < this.fFeatureNames.size(); ++i) {
            this.listModel.addElement(this.fFeatureNames.get(i));
        }
        this.fMainPanel = new JPanel(new BorderLayout(6, 6));
        JPanel quickSearchPanel = new JPanel(new FlowLayout(3));
        final QuickListFilterField field = new QuickListFilterField((ListModel)this.listModel);
        quickSearchPanel.add((Component)field);
        quickSearchPanel.setBorder((Border)new JideTitledBorder((Border)new PartialEtchedBorder(1, 1), "QuickListFilterField", 4, 1));
        this.fSearchList = new JList(field.getDisplayListModel());
        this.fSearchList.setVisibleRowCount(30);
        field.setList(this.fSearchList);
        SearchableUtils.installSearchable((JList)this.fSearchList);
        JPanel listPanel = new JPanel(new BorderLayout(2, 2));
        listPanel.setBorder(BorderFactory.createCompoundBorder((Border)new JideTitledBorder((Border)new PartialEtchedBorder(1, 1), "Filtered features List", 4, 1), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        final JLabel label = new JLabel(field.getDisplayListModel().getSize() + " out of " + this.listModel.getSize() + " features");
        label.setHorizontalAlignment(0);
        label.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this.fSearchList.registerKeyboardAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i;
                int[] selection = GeneSearchList.this.fSearchList.getSelectedIndices();
                int[] actualSelection = new int[selection.length];
                for (i = 0; i < selection.length; ++i) {
                    actualSelection[i] = field.getDisplayListModel().getActualIndexAt(selection[i]);
                }
                Arrays.sort(actualSelection);
                for (i = actualSelection.length - 1; i >= 0; --i) {
                    int index = actualSelection[i];
                    GeneSearchList.this.listModel.remove(index);
                }
            }
        }, KeyStroke.getKeyStroke(127, 0), 0);
        field.getDisplayListModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                this.updateLabel(e);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                this.updateLabel(e);
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                this.updateLabel(e);
            }

            protected void updateLabel(ListDataEvent e) {
                if (e.getSource() instanceof ListModel) {
                    int count = ((ListModel)e.getSource()).getSize();
                    label.setText(count + " out of " + GeneSearchList.this.listModel.getSize() + " features");
                }
            }
        });
        listPanel.add(new JScrollPane(this.fSearchList));
        listPanel.add((Component)label, "First");
        this.fMainPanel.add((Component)quickSearchPanel, "First");
        this.fMainPanel.add((Component)listPanel, "Center");
    }
}

