/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg;

import edu.mit.broad.genome.alg.AlgMap;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.alg.VectorSplitter;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.Template;
import java.util.Map;
import org.apache.log4j.Logger;

public class Metrics {
    protected static final transient Logger klog = Logger.getLogger(Metrics.class);
    private static final int MIN_NUM_FOR_VAR = 3;

    public static Metric[] createAllMetrics() {
        return new Metric[]{new Pearson(), new Cosine(), new Euclidean(), new Manhatten(), new FeatureVar(), new FeatureVarD(), new tTest(), new Signal2Noise(), new None(), new RegressionSlope(), new Bhattacharyya(), new PearsonD(), new ClassMeansDiff(), new ClassMediansDiff(), new ClassOfInterestMean(), new ClassOfInterestMedian(), new ClassMeansRatio(), new ClassMediansRatio(), new ClassMeansLog2Ratio(), new ClassMediansLog2Ratio(), new ClassRatio(), new ClassDiff(), new ClassLog2Ratio(), new FeatureVar(), new FeatureVarD()};
    }

    private Metrics() {
    }

    public static Metric lookupMetric(Object obj) {
        if (obj == null) {
            throw new NullPointerException("Cannot lookup for null object");
        }
        if (obj instanceof Metric) {
            return (Metric)obj;
        }
        Metric[] all = Metrics.createAllMetrics();
        for (int i = 0; i < all.length; ++i) {
            if (!all[i].getName().equalsIgnoreCase(obj.toString())) continue;
            return all[i];
        }
        throw new RuntimeException("Cannot lookupMetric for: " + obj);
    }

    public static class ClassMediansDiff
    extends AbstractMetric {
        public static final String NAME = "Diff_of_Medians";

        public ClassMediansDiff() {
            super(CATEGORICAL);
        }

        @Override
        public double getScore(Vector profile, Template template, Map params) {
            Vector[] vs = this.fSplitter.splitBiphasic_nansafe(profile, template);
            int coiIndex = template.getClassOfInterestIndex();
            if (coiIndex == 0) {
                return XMath.mediansdiff(vs[0], vs[1]);
            }
            return XMath.mediansdiff(vs[1], vs[0]);
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class ClassOfInterestMedian
    extends AbstractMetric {
        public static final String NAME = "ClassOfInterestMedian";

        public ClassOfInterestMedian() {
            super(CATEGORICAL);
        }

        @Override
        public double getScore(Vector profile, Template template, Map params) {
            Vector[] vs = this.fSplitter.splitBiphasic_nansafe(profile, template);
            int coiIndex = template.getClassOfInterestIndex();
            return vs[coiIndex].median();
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class ClassOfInterestMean
    extends AbstractMetric {
        public static final String NAME = "ClassOfInterestMean";

        public ClassOfInterestMean() {
            super(CATEGORICAL);
        }

        @Override
        public double getScore(Vector profile, Template template, Map params) {
            Vector[] vs = this.fSplitter.splitBiphasic_nansafe(profile, template);
            int coiIndex = template.getClassOfInterestIndex();
            return vs[coiIndex].mean();
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class ClassMediansLog2Ratio
    extends AbstractMetric {
        public static final String NAME = "log2_ratio_of_medians";

        public ClassMediansLog2Ratio() {
            super(CATEGORICAL);
        }

        @Override
        public double getScore(Vector profile, Template template, Map params) {
            Vector[] vs = this.fSplitter.splitBiphasic_nansafe(profile, template);
            int coiIndex = template.getClassOfInterestIndex();
            if (coiIndex == 0) {
                return XMath.log2(XMath.mediansratio(vs[0], vs[1]));
            }
            return XMath.log2(XMath.mediansratio(vs[1], vs[0]));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class ClassMeansLog2Ratio
    extends AbstractMetric {
        public static final String NAME = "log2_ratio_of_means";

        public ClassMeansLog2Ratio() {
            super(CATEGORICAL);
        }

        @Override
        public double getScore(Vector profile, Template template, Map params) {
            Vector[] vs = this.fSplitter.splitBiphasic_nansafe(profile, template);
            int coiIndex = template.getClassOfInterestIndex();
            if (coiIndex == 0) {
                return XMath.log2(XMath.meansratio(vs[0], vs[1]));
            }
            return XMath.log2(XMath.meansratio(vs[1], vs[0]));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class ClassMediansRatio
    extends AbstractMetric {
        public static final String NAME = "Ratio_of_Medians";

        public ClassMediansRatio() {
            super(CATEGORICAL);
        }

        @Override
        public double getScore(Vector profile, Template template, Map params) {
            Vector[] vs = this.fSplitter.splitBiphasic(profile, template);
            int coiIndex = template.getClassOfInterestIndex();
            if (coiIndex == 0) {
                return XMath.mediansratio(vs[0], vs[1]);
            }
            return XMath.mediansratio(vs[1], vs[0]);
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class ClassDiff
    extends AbstractMetric {
        public static final String NAME = "Diff_of_Classes";

        public ClassDiff() {
            super(CATEGORICAL);
        }

        @Override
        public double getScore(Vector profile, Template template, Map params) {
            Vector[] vs = this.fSplitter.splitBiphasic(profile, template);
            int coiIndex = template.getClassOfInterestIndex();
            boolean useMean = AlgMap.isMean(params);
            if (coiIndex == 0) {
                return XMath.meanOrMedianDiff(vs[0], vs[1], useMean);
            }
            return XMath.meanOrMedianDiff(vs[1], vs[0], useMean);
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class ClassLog2Ratio
    extends AbstractMetric {
        public static final String NAME = "log2_Ratio_of_Classes";

        public ClassLog2Ratio() {
            super(CATEGORICAL);
        }

        @Override
        public double getScore(Vector profile, Template template, Map params) {
            Vector[] vs = this.fSplitter.splitBiphasic(profile, template);
            int coiIndex = template.getClassOfInterestIndex();
            boolean useMean = AlgMap.isMean(params);
            if (coiIndex == 0) {
                return XMath.log2(XMath.meanOrMedianRatio(vs[0], vs[1], useMean));
            }
            return XMath.log2(XMath.meanOrMedianRatio(vs[1], vs[0], useMean));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class ClassRatio
    extends AbstractMetric {
        public static final String NAME = "Ratio_of_Classes";

        public ClassRatio() {
            super(CATEGORICAL);
        }

        @Override
        public double getScore(Vector profile, Template template, Map params) {
            Vector[] vs = this.fSplitter.splitBiphasic(profile, template);
            int coiIndex = template.getClassOfInterestIndex();
            boolean useMean = AlgMap.isMean(params);
            if (coiIndex == 0) {
                return XMath.meanOrMedianRatio(vs[0], vs[1], useMean);
            }
            return XMath.meanOrMedianRatio(vs[1], vs[0], useMean);
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class ClassMeansRatio
    extends AbstractMetric {
        public static final String NAME = "Ratio_of_Means";

        public ClassMeansRatio() {
            super(CATEGORICAL);
        }

        @Override
        public double getScore(Vector profile, Template template, Map params) {
            Vector[] vs = this.fSplitter.splitBiphasic(profile, template);
            int coiIndex = template.getClassOfInterestIndex();
            if (coiIndex == 0) {
                return XMath.meansratio(vs[0], vs[1]);
            }
            return XMath.meansratio(vs[1], vs[0]);
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class ClassMeansDiff
    extends AbstractMetric {
        public static final String NAME = "Diff_of_Means";

        public ClassMeansDiff() {
            super(CATEGORICAL);
        }

        @Override
        public double getScore(Vector profile, Template template, Map params) {
            Vector[] vs = this.fSplitter.splitBiphasic_nansafe(profile, template);
            int coiIndex = template.getClassOfInterestIndex();
            if (coiIndex == 0) {
                return XMath.meansdiff(vs[0], vs[1]);
            }
            return XMath.meansdiff(vs[1], vs[0]);
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class PearsonD
    extends Pearson {
        public static final String NAME = "Norm.Pearson";

        @Override
        public double getScore(Vector profile, Template template, Map params) {
            Vector[] vs = this.fSplitter.splitBiphasic_nansafe(profile, template);
            int coiIndex = template.getClassOfInterestIndex();
            if (coiIndex == 0) {
                return XMath.pearsonD(vs[0], vs[1]);
            }
            return XMath.pearsonD(vs[1], vs[0]);
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class RegressionSlope
    extends AbstractMetric {
        public static final String NAME = "RegressionSlope";

        public RegressionSlope() {
            super(CONTINUOUS);
        }

        @Override
        public double getScore(Vector profile, Template template, Map params) {
            boolean usebiased = AlgMap.isBiased(params);
            boolean fixlow = AlgMap.isFixLowVar(params);
            Vector[] splits = template.splitByTemplateClass(profile);
            return XMath.regressionSlope(profile, template.toVector(), splits, usebiased, fixlow);
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Bhattacharyya
    extends AbstractMetric {
        public static final String NAME = "Bhattacharyya";

        public Bhattacharyya() {
            super(CATEGORICAL);
        }

        @Override
        public double getScore(Vector profile, Template template, Map params) {
            boolean usebiased = AlgMap.isBiased(params);
            boolean fixlow = AlgMap.isFixLowVar(params);
            Vector[] vs = this.fSplitter.splitBiphasic_nansafe(profile, template);
            int coiIndex = template.getClassOfInterestIndex();
            if (coiIndex == 0) {
                return XMath.bhat(vs[0], vs[1], usebiased, fixlow);
            }
            return XMath.bhat(vs[1], vs[0], usebiased, fixlow);
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class tTest
    extends AbstractMetric {
        public static final String NAME = "tTest";

        public tTest() {
            super(CATEGORICAL);
        }

        @Override
        public double getScore(Vector profile, Template template, Map params) {
            boolean usemedian = AlgMap.isMedian(params);
            boolean usebiased = AlgMap.isBiased(params);
            boolean fixlow = AlgMap.isFixLowVar(params);
            Vector[] vs = this.fSplitter.splitBiphasic_nansafe(profile, template);
            int coiIndex = template.getClassOfInterestIndex();
            if (coiIndex == 0) {
                return XMath.tTest(vs[0], vs[1], usebiased, usemedian, fixlow);
            }
            return XMath.tTest(vs[1], vs[0], usebiased, usemedian, fixlow);
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public int getMinNumSamplesNeededPerClassForCalculation() {
            return 3;
        }
    }

    public static class None
    extends AbstractMetric {
        public static final String NAME = "None";

        public None() {
            super(CAT_AND_CONT);
        }

        @Override
        public double getScore(Vector profile, Template template, Map params) {
            return profile.getElement(0);
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Signal2Noise2
    extends AbstractMetric {
        public static final String NAME = "Signal2Noise";

        public Signal2Noise2() {
            super(CATEGORICAL);
        }

        @Override
        public double getScore(Vector profile, Template template, Map params) {
            boolean usebiased = AlgMap.isBiased(params);
            boolean fixlow = AlgMap.isFixLowVar(params);
            boolean usemedian = AlgMap.isMedian(params);
            Vector[] vs = this.fSplitter.splitBiphasic_nansafe(profile, template);
            if (vs == null) {
                return 0.0;
            }
            int coiIndex = template.getClassOfInterestIndex();
            if (coiIndex == 0) {
                return XMath.s2n(vs[0], vs[1], usebiased, usemedian, fixlow);
            }
            return XMath.s2n(vs[1], vs[0], usebiased, usemedian, fixlow);
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public int getMinNumSamplesNeededPerClassForCalculation() {
            return 3;
        }
    }

    public static class Signal2Noise
    extends AbstractMetric {
        public static final String NAME = "Signal2Noise";

        public Signal2Noise() {
            super(CATEGORICAL);
        }

        @Override
        public double getScore(Vector profile, Template template, Map params) {
            boolean usebiased = AlgMap.isBiased(params);
            boolean fixlow = AlgMap.isFixLowVar(params);
            boolean usemedian = AlgMap.isMedian(params);
            Vector[] vs = this.fSplitter.splitBiphasic_nansafe(profile, template);
            if (vs == null) {
                return 0.0;
            }
            int coiIndex = template.getClassOfInterestIndex();
            if (coiIndex == 0) {
                return XMath.s2n(vs[0], vs[1], usebiased, usemedian, fixlow);
            }
            return XMath.s2n(vs[1], vs[0], usebiased, usemedian, fixlow);
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public int getMinNumSamplesNeededPerClassForCalculation() {
            return 3;
        }
    }

    public static class FeatureVarD
    extends AbstractMetric {
        public static final String NAME = "Feature_stddev_by_mean";

        public FeatureVarD() {
            super(CONTINUOUS);
        }

        @Override
        public double getScore(Vector profile, Template template, Map params) {
            boolean usebiased = AlgMap.isBiased(params);
            boolean fixlow = AlgMap.isFixLowVar(params);
            return profile.vard(usebiased, fixlow);
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public int getMinNumSamplesNeededPerClassForCalculation() {
            return 3;
        }
    }

    public static class FeatureVar
    extends AbstractMetric {
        public static final String NAME = "FeatureVariation";

        public FeatureVar() {
            super(CONTINUOUS);
        }

        @Override
        public double getScore(Vector profile, Template template, Map params) {
            boolean usebiased = AlgMap.isBiased(params);
            boolean fixlow = AlgMap.isFixLowVar(params);
            return profile.var(usebiased, fixlow);
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public int getMinNumSamplesNeededPerClassForCalculation() {
            return 3;
        }
    }

    public static class Cosine
    extends AbstractMetric {
        public static final String NAME = "Cosine";

        public Cosine() {
            super(CONTINUOUS);
        }

        @Override
        public double getScore(Vector profile, Template template, Map params) {
            return XMath.cosine(template.synchProfile(profile), template.toVector());
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Pearson
    extends AbstractMetric {
        public static final String NAME = "Pearson";

        public Pearson() {
            super(CONTINUOUS);
        }

        @Override
        public double getScore(Vector profile, Template template, Map params) {
            Vector v = template.synchProfile(profile);
            return XMath.pearson(v, template.toVector());
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Manhatten
    extends AbstractMetric {
        public static final String NAME = "Manhatten";

        public Manhatten() {
            super(CONTINUOUS);
        }

        @Override
        public double getScore(Vector profile, Template template, Map params) {
            return XMath.manhatten(template.synchProfile(profile), template.toVector());
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Euclidean
    extends AbstractMetric {
        public static final String NAME = "Euclidean";

        public Euclidean() {
            super(CONTINUOUS);
        }

        @Override
        public double getScore(Vector profile, Template template, Map params) {
            return XMath.euclidean(template.synchProfile(profile), template.toVector());
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static abstract class AbstractMetric
    implements Metric {
        protected VectorSplitter fSplitter;
        private Metric.Type fType;

        public AbstractMetric(Metric.Type type) {
            this.fType = type;
            this.fSplitter = new VectorSplitter(1);
        }

        @Override
        public boolean isCategorical() {
            return this.fType.equals(CATEGORICAL) || this.fType.equals(CAT_AND_CONT);
        }

        @Override
        public boolean isContinuous() {
            return this.fType.equals(CONTINUOUS) || this.fType.equals(CAT_AND_CONT);
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Metric) {
                return this.getName().equalsIgnoreCase(((Metric)obj).getName());
            }
            return false;
        }

        public String toString() {
            return this.getName();
        }

        @Override
        public int getMinNumSamplesNeededPerClassForCalculation() {
            return 1;
        }
    }
}

