/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import org.ujmp.core.Matrix;
import org.ujmp.core.SparseMatrix;
import org.ujmp.core.calculation.MtimesCalculation;
import org.ujmp.core.util.VerifyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MtimesSparseMatrixBoth
implements MtimesCalculation<SparseMatrix, SparseMatrix, Matrix> {
    MtimesSparseMatrixBoth() {
    }

    @Override
    public final void calc(SparseMatrix source1, SparseMatrix source2, Matrix target) {
        VerifyUtil.verify2D(source1);
        VerifyUtil.verify2D(source2);
        VerifyUtil.verify2D(target);
        VerifyUtil.verifyEquals(source1.getColumnCount(), source2.getRowCount(), "matrices have wrong sizes");
        VerifyUtil.verifyEquals(target.getRowCount(), source1.getRowCount(), "matrices have wrong sizes");
        VerifyUtil.verifyEquals(target.getColumnCount(), source2.getColumnCount(), "matrices have wrong sizes");
        target.clear();
        for (long[] c1 : source1.availableCoordinates()) {
            double v1 = source1.getAsDouble(c1);
            if (v1 == 0.0) continue;
            for (long[] c2 : source2.availableCoordinates()) {
                if (c2[0] != c1[1]) continue;
                double v2 = source2.getAsDouble(c2);
                if (v1 == 0.0) continue;
                double temp = v1 * v2;
                double v3 = target.getAsDouble(c1[0], c2[1]);
                target.setAsDouble(v3 + temp, c1[0], c2[1]);
            }
        }
    }
}

