/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.filematrix;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.ujmp.core.Matrix;
import org.ujmp.core.filematrix.FileFormat;
import org.ujmp.core.filematrix.FileOrDirectoryMatrix;
import org.ujmp.core.mapmatrix.AbstractMapMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipEntryMatrix
extends AbstractMapMatrix<String, Matrix>
implements FileOrDirectoryMatrix {
    private static final long serialVersionUID = 7888827379525961742L;
    private final ZipFile zipFile;
    private final ZipEntry zipEntry;
    private final Map<String, Matrix> map = new TreeMap<String, Matrix>();

    public ZipEntryMatrix(ZipFile zipFile, ZipEntry zipEntry) {
        this.zipFile = zipFile;
        this.zipEntry = zipEntry;
        this.setLabel(zipEntry.getName());
        this.setMetaData("CompressedSize", zipEntry.getCompressedSize());
        this.setMetaData("CRC", zipEntry.getCrc());
        this.setMetaData("Method", zipEntry.getMethod());
        this.setMetaData("Size", zipEntry.getSize());
        this.setMetaData("Time", zipEntry.getTime());
        this.setMetaData("IsDirectory", zipEntry.isDirectory());
        this.setMetaData("Comment", zipEntry.getComment());
    }

    @Override
    public Matrix get(Object key) {
        this.ensureData();
        return this.map.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureData() {
        if (this.map.isEmpty()) {
            Map<String, Matrix> map = this.map;
            synchronized (map) {
                if (this.map.isEmpty()) {
                    try {
                        InputStream is = this.zipFile.getInputStream(this.zipEntry);
                        if (!this.zipEntry.isDirectory()) {
                            FileFormat format = FileFormat.guess(is);
                            this.map.put("FileFormat", Matrix.Factory.linkToValue((Object)format));
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    @Override
    public Set<String> keySet() {
        this.ensureData();
        return this.map.keySet();
    }

    @Override
    protected void clearMap() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Matrix removeFromMap(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Matrix putIntoMap(String key, Matrix value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        this.ensureData();
        return this.map.size();
    }
}

