/*
 * Decompiled with CFR 0.152.
 */
package xapps.gsea;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.jgoodies.looks.plastic.theme.ExperienceBlue;
import com.jidesoft.comparator.ObjectComparatorManager;
import com.jidesoft.swing.SplashScreen;
import com.jidesoft.utils.Lm;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.xbench.ComparatorFactory2;
import java.util.Comparator;
import javax.swing.ImageIcon;
import javax.swing.LookAndFeel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import org.broad.gsea.ui.DesktopIntegration;
import xapps.gsea.GseaFijiTabsApplicationFrame;

public class Main {
    private static final Logger klog;

    public Main() {
        this.setLnF();
        ImageIcon splash = JarResources.getImageIcon("gsea_splash.png");
        SplashScreen.create((ImageIcon)splash);
        SplashScreen.show();
        GseaFijiTabsApplicationFrame frame = new GseaFijiTabsApplicationFrame();
        try {
            frame.init_bg_while_splashing();
        }
        catch (Throwable t) {
            System.out.println("Error while initializing .., things may not work");
            t.printStackTrace();
        }
        SplashScreen.hide();
        frame.makeVisible(true);
        ObjectComparatorManager.registerComparator(Integer.class, (Comparator)new ComparatorFactory2.IntegerComparator());
        ObjectComparatorManager.registerComparator(Float.class, (Comparator)new ComparatorFactory2.FloatComparator());
    }

    public static void main(String[] args) {
        try {
            new Main();
        }
        catch (Throwable e) {
            e.printStackTrace();
            klog.fatal((Object)"Could not create application", e);
        }
    }

    public void setLnF() {
        try {
            UIManager.put("ClassLoader", LookUtils.class.getClassLoader());
            try {
                if (!SystemUtils.IS_OS_MAC_OSX) {
                    PlasticXPLookAndFeel.setMyCurrentTheme((PlasticTheme)new ExperienceBlue());
                    UIManager.setLookAndFeel((LookAndFeel)new PlasticXPLookAndFeel());
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            UIManager.put("Application.useSystemFontSettings", Boolean.TRUE);
            UIManager.put("Application.useSystemFontSettings", Boolean.TRUE);
            Options.setUseSystemFonts((boolean)true);
            ToolTipManager.sharedInstance().setEnabled(true);
            ToolTipManager.sharedInstance().setDismissDelay(15000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        Lm.verifyLicense((String)"Broad Institute of MIT and Harvard", (String)"Gene set  enrichment analysis java desktop application", (String)"YSjBO6OJfF9WbavzI73Jt1HgDI4x9L21");
        DesktopIntegration.verifyJavaPlatform();
        DesktopIntegration.setDockIcon(JarResources.getImage("icon_64x64.png"));
        if (SystemUtils.IS_OS_MAC_OSX) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        klog = Logger.getLogger(Main.class);
    }
}

