/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.modules;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class AbstractModule {
    protected static final Pattern COMMA_PATTERN = Pattern.compile(",");
    protected static final Pattern HASH_PATTERN = Pattern.compile("#");

    protected static String copyFileWithoutBadChars(String file, File working) throws IOException {
        if (!StringUtils.containsAny((CharSequence)file, (char[])new char[]{'#', '@'})) {
            return file;
        }
        File f = new File(file);
        String newName = StringUtils.replaceChars((String)f.getName(), (String)"@#", (String)"_");
        File newFile = new File(working, newName);
        System.out.println("Copying file '" + file + "' to '" + newName + "'");
        try {
            FileUtils.copyFile((File)f, (File)newFile);
            return newFile.getPath();
        }
        catch (IOException ioe) {
            System.err.println("An error occurred trying to copy '" + file + "' to '" + newName + "'");
            throw ioe;
        }
    }

    protected static void setParam(String name, String value, Properties paramProps, Logger log) {
        log.info((Object)(name + "\t" + value));
        paramProps.setProperty(name, value);
    }

    protected static void setOptionValueAsParam(String optionName, CommandLine commandLine, Properties paramProps, Logger log) {
        String optionValue = commandLine.getOptionValue(optionName);
        if (optionValue == null) {
            return;
        }
        AbstractModule.setParam(optionName, optionValue, paramProps, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void copyAnalysisToCurrentDir(File cwd, File analysis, boolean createZip, String zipFileName) throws Exception {
        try {
            if (createZip) {
                AbstractModule.copyZipToJobIfPresent(analysis, zipFileName, cwd);
            }
        }
        finally {
            try {
                File edb = new File(analysis, "edb");
                if (edb.exists()) {
                    FileUtils.copyDirectory((File)edb, (File)cwd, (FileFilter)FileFileFilter.FILE);
                }
            }
            finally {
                FileUtils.copyDirectory((File)analysis, (File)cwd, (FileFilter)FileFileFilter.FILE);
            }
        }
    }

    protected static void cleanUpAnalysisDirs(File cwd, File tmp_working) {
        try {
            FileUtils.deleteQuietly((File)tmp_working);
        }
        finally {
            AbstractModule.deleteEmptyDirectories(cwd);
        }
    }

    protected static void copyZipToJobIfPresent(File analysis, String zipFileName, File cwd) throws Exception {
        if (!analysis.exists()) {
            return;
        }
        Collection zips = FileUtils.listFiles((File)analysis, (String[])new String[]{"zip"}, (boolean)false);
        if (zips == null || zips.isEmpty()) {
            return;
        }
        if (zips.size() > 1) {
            throw new Exception("Internal Error: multiple ZIP files created");
        }
        File zip = (File)zips.iterator().next();
        try {
            File dest = new File(cwd, zipFileName);
            System.out.println("Moving from :" + zip.getAbsolutePath());
            System.out.println("To :" + dest.getAbsolutePath());
            FileUtils.moveFile((File)zip, (File)dest);
        }
        catch (IOException ioe) {
            System.err.println("Internal error moving result ZIP: ");
            throw ioe;
        }
    }

    protected static void deleteEmptyDirectories(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                String[] filesInDir;
                if (!files[i].isDirectory() || (filesInDir = files[i].list()) != null && filesInDir.length != 0) continue;
                files[i].delete();
            }
        }
    }

    protected static final List<String> selectGeneSetsFromFiles(List<String> geneSetDBs, List<String> selectedGeneSets, boolean gpMode) {
        if (geneSetDBs.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            Map<String, String> geneSetDBPathMap = AbstractModule.buildFileNameToFilePathMap(geneSetDBs);
            boolean haveSingleFile = geneSetDBPathMap.size() == 1;
            ArrayList<String> selected = new ArrayList<String>();
            for (String selectedGeneSet : selectedGeneSets) {
                String selector = haveSingleFile ? AbstractModule.buildSelector(selectedGeneSet, geneSetDBPathMap.values().iterator().next()) : AbstractModule.buildSelector(selectedGeneSet, geneSetDBPathMap);
                selected.add(selector);
            }
            return selected;
        }
        catch (IllegalArgumentException iae) {
            String paramName = gpMode ? "selected.gene.sets" : "-selected_gene_sets";
            System.err.println("There was a problem processing the '" + paramName + "' parameter");
            iae.printStackTrace(System.err);
            return null;
        }
    }

    protected static final String buildSelector(String selectionToken, String filePath) {
        String fileName = FilenameUtils.getName((String)filePath);
        String[] specifier = HASH_PATTERN.split(selectionToken);
        if (specifier == null || specifier.length != 1 && specifier.length != 2) {
            throw new IllegalArgumentException("Gene Set selection specifier '" + selectionToken + "' is not valid. Selections must be separated with semicolon, and each must be a file name + '#' + gene set name, e.g. my_file1.gmt#selected_gene_set1. The selector can be shortened to selected_gene_set1 when there is only one Gene Set file.");
        }
        if (specifier.length == 2 && !StringUtils.equals((CharSequence)fileName, (CharSequence)specifier[0])) {
            throw new IllegalArgumentException("Gene Set selection specifier '" + selectionToken + "' is not valid; Specified file name must match lone file '" + fileName + "' supplied as the Gene Set database.");
        }
        String geneSetName = specifier[specifier.length - 1];
        return filePath + "#" + geneSetName;
    }

    protected static final String buildSelector(String selectionToken, Map<String, String> geneSetDBPathMap) {
        String[] specifier = HASH_PATTERN.split(selectionToken);
        if (specifier == null || specifier.length != 2) {
            throw new IllegalArgumentException("Gene Set selection specifier '" + selectionToken + "' is not valid. Selections must be separated with semicolon, and each must be a file name + '#' + gene set name, e.g. my_file1.gmt#selected_gene_set1. The selector can be shortened to selected_gene_set1 when there is only one Gene Set file.");
        }
        String fileName = specifier[0];
        String geneSetName = specifier[1];
        String userMatch = geneSetDBPathMap.get(fileName);
        if (userMatch != null) {
            return userMatch + "#" + geneSetName;
        }
        throw new IllegalArgumentException("Selected file name '" + fileName + "' not found in submitted Gene Set files.");
    }

    protected static Map<String, String> buildFileNameToFilePathMap(List<String> geneSetDBs) {
        HashMap<String, String> fileNameToPathMap = new HashMap<String, String>();
        for (String geneSetDB : geneSetDBs) {
            String fileName = FilenameUtils.getName((String)geneSetDB);
            if (fileNameToPathMap.containsKey(fileName)) {
                throw new IllegalArgumentException("Duplicated file name '" + fileName + "' found in submitted Gene Set files.  This is not allowed with selected.gene.gets.");
            }
            System.out.println("Adding baseName '" + fileName + "' to Map with full path '" + geneSetDB + "'");
            fileNameToPathMap.put(fileName, geneSetDB);
        }
        return fileNameToPathMap;
    }

    protected static final String determineSelectorFromParams(String geneSetDBParam, String geneSetDBListParam, String selectedGeneSetsParam, String altDelim, boolean gpMode, File tmpDir, Logger klog) throws IOException {
        List<String> geneSetDBs;
        boolean paramProcessingError = false;
        boolean haveGmx = StringUtils.isNotBlank((CharSequence)geneSetDBParam);
        boolean haveGmxList = StringUtils.isNotBlank((CharSequence)geneSetDBListParam);
        if (gpMode) {
            if (haveGmx) {
                klog.error((Object)"Illegal parameter '-gmx', not valid unless -run_as_genepattern false.");
            }
            if (!haveGmxList) {
                klog.error((Object)"One or more gene set files must be specified using the 'gene.sets.database' parameter.");
            }
        } else if (haveGmx && haveGmxList || !haveGmx && !haveGmxList) {
            klog.error((Object)"One or more gene sets must be specified using either the '-gmx' or '-gmx_list' parameters.  Please use one or the other but not both.");
            klog.error((Object)"For '-gmx_list', provide a single text file listing each gene set file, one per line.");
            paramProcessingError = true;
        } else if (haveGmx) {
            if (!StringUtils.isBlank((CharSequence)selectedGeneSetsParam)) {
                klog.error((Object)"Invalid use of '-selected_gene_sets': must be blank when using '-gmx'.  Valid for '-gmx_list' only");
                paramProcessingError = true;
            } else {
                return geneSetDBParam;
            }
        }
        String delim = ",";
        Pattern delimPattern = COMMA_PATTERN;
        if (StringUtils.isNotBlank((CharSequence)altDelim)) {
            delim = altDelim;
            delimPattern = Pattern.compile(delim);
        }
        List<String> list = geneSetDBs = haveGmxList ? FileUtils.readLines((File)new File(geneSetDBListParam), (Charset)null) : Collections.emptyList();
        if (gpMode) {
            ArrayList<String> safeNameGeneSetDBs = new ArrayList<String>(geneSetDBs.size());
            for (String geneSetDB : geneSetDBs) {
                String renamedFile = AbstractModule.copyFileWithoutBadChars(geneSetDB, tmpDir);
                if (renamedFile != null) {
                    safeNameGeneSetDBs.add(renamedFile);
                    continue;
                }
                paramProcessingError = true;
                safeNameGeneSetDBs.add(geneSetDB);
            }
            geneSetDBs = safeNameGeneSetDBs;
        }
        List<String> selectedGeneSets = StringUtils.isBlank((CharSequence)selectedGeneSetsParam) ? Collections.emptyList() : Arrays.asList(delimPattern.split(selectedGeneSetsParam));
        List<String> geneSetsSelection = selectedGeneSets.isEmpty() ? geneSetDBs : AbstractModule.selectGeneSetsFromFiles(geneSetDBs, selectedGeneSets, gpMode);
        return (paramProcessingError |= geneSetsSelection == null) ? null : StringUtils.join(geneSetsSelection, (String)delim);
    }

    protected static boolean isCollapseOrRemap(String collapseParam) {
        return StringUtils.equals((CharSequence)"Collapse", (CharSequence)collapseParam) || StringUtils.equals((CharSequence)"Remap_Only", (CharSequence)collapseParam) || StringUtils.equals((CharSequence)"true", (CharSequence)collapseParam);
    }
}

