/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.actions.ext;

import edu.mit.broad.genome.JarResources;
import edu.mit.broad.xbench.actions.ExtAction;
import edu.mit.broad.xbench.core.api.Application;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URI;
import org.apache.commons.io.FilenameUtils;

public class FileBrowserAction
extends ExtAction {
    public FileBrowserAction() {
        super("FileBrowserAction", "Launch File", "Launch a File in an External Process", null, null);
    }

    public FileBrowserAction(File path) {
        this();
        this.setPath(path);
    }

    @Override
    public void setPath(File path) {
        super.setPath(path);
        if (path == null) {
            return;
        }
        String ext = FilenameUtils.getExtension((String)path.getName());
        if (ext.equalsIgnoreCase("html")) {
            super.putValue("Name", "Web Browser");
            super.putValue("SmallIcon", JarResources.getIcon("Htm.gif"));
        } else if (ext.equalsIgnoreCase("csv") || ext.equalsIgnoreCase("xls")) {
            super.putValue("Name", "Launch in Excel");
            super.putValue("SmallIcon", JarResources.getIcon("Xls.gif"));
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        File file = this.getPath();
        if (file == null) {
            return;
        }
        try {
            URI outputDirURI = file.toURI();
            outputDirURI = new URI(outputDirURI.getScheme(), "", outputDirURI.getPath(), null, null);
            Desktop.getDesktop().browse(outputDirURI);
        }
        catch (Throwable t) {
            Application.getWindowManager().showError("Trouble launching File on path '" + file.getPath() + "'", t);
        }
    }
}

