/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.chip;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.vdb.chip.NullSymbolMode;
import edu.mit.broad.vdb.chip.Probe;
import edu.mit.broad.vdb.meg.Gene;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Chip
extends AbstractObject {
    private Probe[] fProbes;
    private Map<String, Probe> fProbeNameProbeMap;
    private boolean fDeepDataInited = false;
    private Map<String, Set<String>> fSymbolProbeNameSetMap;
    private String fSourcePath;

    public Chip(String chipName, String sourcePath) {
        super.initialize(chipName);
        if (sourcePath == null) {
            throw new IllegalArgumentException("Parameter sourcePath cannot be null");
        }
        this.fSourcePath = sourcePath;
    }

    public Chip(String chipName, String sourcePath, Probe[] probes) {
        this.initHere(chipName, sourcePath, probes);
        this.fDeepDataInited = true;
    }

    public boolean equals(Object obj) {
        return obj instanceof Chip && ((Chip)obj).getName().equalsIgnoreCase(this.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getName();
    }

    public GeneSet getProbeNamesAsGeneSet() throws Exception {
        return new GeneSet(this.getName(), this.getProbeNames());
    }

    public Gene getHugo(String probeName) throws Exception {
        return this.getProbe(probeName).getGene();
    }

    public String getSymbol(String probeName, NullSymbolMode nmode) {
        try {
            if (this.isProbe(probeName)) {
                return nmode.getSymbol(probeName, this.getHugo(probeName));
            }
            return nmode.getSymbol(probeName, null);
        }
        catch (Throwable t) {
            this.log.error((Object)t);
            return "";
        }
    }

    public String getTitle(String probeName, NullSymbolMode nmode) {
        try {
            if (this.isProbe(probeName)) {
                return nmode.getTitle(probeName, this.getHugo(probeName));
            }
            return nmode.getTitle(probeName, null);
        }
        catch (Throwable t) {
            this.log.error((Object)t);
            return "";
        }
    }

    private void initHere(String chipName, String sourcePath, Probe[] probes) {
        if (!this.isInited()) {
            super.initialize(chipName);
        }
        if (!(NamingConventions.isURL(sourcePath) || sourcePath != null && new File(sourcePath).exists())) {
            this.log.warn((Object)("Missing chip file: >" + sourcePath + "<"));
        }
        if (probes == null) {
            throw new IllegalArgumentException("Param probes cannot be null");
        }
        if (chipName == null) {
            throw new IllegalArgumentException("Param chipName cannot be null");
        }
        HashSet<String> names = new HashSet<String>();
        HashSet<String> duplicates = new HashSet<String>();
        this.fProbes = new Probe[probes.length];
        for (int i = 0; i < probes.length; ++i) {
            this.fProbes[i] = probes[i];
            if (names.contains(probes[i].getName())) {
                duplicates.add(probes[i].getName());
            }
            names.add(probes[i].getName());
        }
        if (!duplicates.isEmpty()) {
            this.log.debug((Object)("There were duplicate probes: " + duplicates.size() + "\n" + duplicates + "\n" + this.getName()));
        } else {
            this.log.debug((Object)("There were no duplicates: " + names.size() + " " + this.getName()));
        }
        names.clear();
        duplicates.clear();
        this.fSourcePath = sourcePath;
    }

    private void readDeepData() throws Exception {
        if (this.fDeepDataInited) {
            return;
        }
        try {
            Chip chip = ParserFactory.readChip(this.fSourcePath);
            this.initHere(chip.getName(), this.fSourcePath, chip.fProbes);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Exception(t);
        }
        finally {
            this.fDeepDataInited = true;
        }
    }

    @Override
    public String getQuickInfo() {
        if (this.fDeepDataInited) {
            return this.fProbes.length + " probes";
        }
        return null;
    }

    public int getNumProbes() throws Exception {
        this.readDeepData();
        return this.fProbes.length;
    }

    public Probe getProbe(int i) throws Exception {
        this.readDeepData();
        return this.fProbes[i];
    }

    public String getProbeName(int i) throws Exception {
        this.readDeepData();
        return this.fProbes[i].getName();
    }

    private void initProbeProbeMap() throws Exception {
        if (this.fProbeNameProbeMap == null) {
            this.readDeepData();
            this.fProbeNameProbeMap = new HashMap<String, Probe>();
            for (int i = 0; i < this.fProbes.length; ++i) {
                this.fProbeNameProbeMap.put(this.fProbes[i].getName(), this.fProbes[i]);
            }
        }
    }

    public Set<String> getProbeNames() throws Exception {
        this.initProbeProbeMap();
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < this.fProbes.length; ++i) {
            set.add(this.getProbe(i).getName());
        }
        return set;
    }

    public boolean isProbe(String probeName) throws Exception {
        if (probeName == null) {
            return false;
        }
        this.initProbeProbeMap();
        return this.fProbeNameProbeMap.containsKey(probeName);
    }

    public Probe getProbe(String probeName_orig) throws Exception {
        if (probeName_orig == null) {
            throw new IllegalArgumentException("Param probeName cannot be null");
        }
        this.initProbeProbeMap();
        Probe obj = this.fProbeNameProbeMap.get(probeName_orig);
        if (obj == null) {
            throw new IllegalArgumentException("No Probe called: " + probeName_orig + " on this chip (chip name is >" + this.getName() + "<)");
        }
        return obj;
    }

    public Set<String> getProbeNames(String geneSymbol) throws Exception {
        this.initSymbolMap();
        Set<String> curr = this.fSymbolProbeNameSetMap.get(geneSymbol);
        if (curr == null) {
            return Collections.emptySet();
        }
        return curr;
    }

    private void initSymbolMap() throws Exception {
        if (this.fSymbolProbeNameSetMap == null) {
            this.readDeepData();
            this.fSymbolProbeNameSetMap = new HashMap<String, Set<String>>();
            for (int i = 0; i < this.fProbes.length; ++i) {
                Gene gene = this.fProbes[i].getGene();
                if (gene == null) continue;
                String symbol = gene.getSymbol();
                Set<String> curr = this.fSymbolProbeNameSetMap.get(symbol);
                if (curr == null) {
                    curr = new HashSet<String>();
                }
                curr.add(this.fProbes[i].getName());
                this.fSymbolProbeNameSetMap.put(symbol, curr);
            }
        }
    }
}

