/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.swing;

import edu.mit.broad.genome.Constants;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.swing.TextIconPair;
import gnu.trove.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.Queue;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class GuiHelper
implements Constants {
    public static final Icon ICON_ERROR16 = JarResources.getIcon("Error.gif");
    public static final Icon ICON_START16 = JarResources.getIcon("Run16.png");
    public static final Icon ICON_PAUSE16 = JarResources.getIcon("Pause16.gif");
    public static final Icon ICON_COPY16 = JarResources.getIcon("Copy16.gif");
    public static final Icon ICON_HELP16 = JarResources.getIcon("Help16_v2.gif");
    public static final Icon ICON_ELLIPSIS = JarResources.getIcon("Ellipsis.png");
    public static final Icon ICON_OPTIONPANE_INFO16 = JarResources.getIcon("Inform16.gif");
    public static final Dimension DIMENSION_STANDARD_WINDOW = new Dimension(500, 500);
    public static final Font FONT_DEFAULT_BOLD = new Font("Helvetica", 1, 12);
    public static final Font FONT_DEFAULT = new Font("Helvetica", 0, 12);
    public static final Color COLOR_LIGHT_ORANGE = new Color(255, 172, 89);
    public static final Color COLOR_LIGHT_YELLOW = Color.decode("#FFFF99");
    public static final Color COLOR_DARK_GREEN = new Color(0, 81, 0);
    public static final Color COLOR_LIGHT_RED = new Color(255, 108, 108);
    public static final Color COLOR_LIGHT_BLUE = new Color(150, 150, 255);
    public static final Color COLOR_DARK_BROWN = new Color(128, 64, 64);
    public static final Color COLOR_VERY_LIGHT_GRAY = new Color(239, 239, 239);
    public static final Color COLOR_DARK_BLUE = new Color(63, 64, 124);
    private static final Logger klog = Logger.getLogger(GuiHelper.class);
    private static final Dimension kPlaceholderSize = new Dimension(200, 50);

    private GuiHelper() {
    }

    public static TitledBorder createTitledBorderForComponent(String title) {
        Border b = BorderFactory.createLineBorder(Color.BLACK);
        return BorderFactory.createTitledBorder(b, title, 0, 2, FONT_DEFAULT, Color.GRAY);
    }

    public static void centerComponent(Component comp) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = comp.getSize();
        comp.setLocation((screenSize.width - size.width) / 2, (screenSize.height - size.height) / 2);
    }

    public static void fill(JComponent filledcomp, JComponent filler) {
        filledcomp.removeAll();
        if (filledcomp instanceof JScrollPane) {
            ((JScrollPane)filledcomp).getViewport().add((Component)filler, null);
        } else {
            filledcomp.setLayout(new GridLayout(1, 1));
            filledcomp.add(filler);
        }
        filledcomp.revalidate();
    }

    public static JPanel createPlaceholderPanel(Dimension prefsize, TextIconPair pair) {
        return GuiHelper._createPanel(prefsize, pair.text, pair.icon);
    }

    public static JPanel createNaPlaceholder() {
        return GuiHelper.createPlaceholderPanel(kPlaceholderSize, TextIconPair.NA_COMPONENT);
    }

    public static JPanel createWaitingPlaceholder() {
        return GuiHelper.createPlaceholderPanel(kPlaceholderSize, TextIconPair.WAITING_FOR_TASK);
    }

    private static JPanel _createPanel(Dimension prefsize, String text, Icon icon) {
        JPanel panel = new JPanel();
        panel.setPreferredSize(prefsize);
        JLabel label = new JLabel(text);
        label.setSize(prefsize);
        label.setIcon(icon);
        panel.setLayout(new FlowLayout(1));
        panel.add(label);
        panel.setBackground(Color.white);
        return panel;
    }

    public static void safeSelect(JComboBox cb) {
        if (cb.getSelectedIndex() != -1) {
            return;
        }
        if (cb.getModel().getSize() > 0) {
            cb.setSelectedIndex(0);
        }
    }

    public static JPanel createGradientHeader(Color background, String title, Icon icon) {
        JPanel panel = new JPanel(new BorderLayout()){
            private final Color control = UIManager.getColor("control");

            @Override
            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                if (this.isOpaque()) {
                    int h = this.getHeight();
                    int w = this.getWidth();
                    Graphics2D graphics2d = (Graphics2D)graphics;
                    Paint storedPaint = graphics2d.getPaint();
                    graphics2d.setPaint(new GradientPaint(0.0f, 0.0f, this.getBackground(), w, 0.0f, this.control));
                    graphics2d.fillRect(0, 0, w, h);
                    graphics2d.setPaint(storedPaint);
                }
            }
        };
        panel.setBackground(background);
        JLabel label = new JLabel(title, icon, 10);
        label.setForeground(Color.white);
        label.setOpaque(false);
        panel.add((Component)label, "West");
        panel.setBorder(BorderFactory.createEmptyBorder(3, 4, 3, 1));
        return panel;
    }

    public static class Tree {
        public static void expandAll(JTree tree, TreePath path) {
            TreeModel model = tree.getModel();
            LinkedList<TreePath> pathsToDescend = new LinkedList<TreePath>();
            pathsToDescend.add(path);
            Tree.expandAllInternalNodes(tree, model, pathsToDescend);
        }

        private static void expandAllInternalNodes(JTree tree, TreeModel model, Queue<TreePath> pathsToDescend) {
            if (pathsToDescend.isEmpty()) {
                return;
            }
            TreePath path = pathsToDescend.remove();
            Object node = path.getLastPathComponent();
            if (model.isLeaf(node)) {
                return;
            }
            tree.expandPath(path);
            int num = model.getChildCount(node);
            for (int i = 0; i < num; ++i) {
                TreePath subPath = path.pathByAddingChild(model.getChild(node, i));
                pathsToDescend.add(subPath);
            }
            Tree.expandAllInternalNodes(tree, model, pathsToDescend);
        }
    }

    public static class List2 {
        public static void setSelected(Object[] selected_vals, JList jlist, DefaultListModel listModel) {
            if (selected_vals == null) {
                klog.error((Object)"Null arg for selected selected_vals");
                return;
            }
            TIntArrayList indices = new TIntArrayList();
            for (int i = 0; i < selected_vals.length; ++i) {
                int index = listModel.indexOf(selected_vals[i]);
                if (index == -1) continue;
                indices.add(index);
            }
            jlist.setSelectedIndices(indices.toNativeArray());
        }
    }

    public static class Table {
        public static void setColumnSize(int size, int col, JTable table, boolean alsoMax) {
            TableColumn column = table.getColumnModel().getColumn(col);
            column.setMinWidth(0);
            if (alsoMax) {
                column.setMaxWidth(size);
            }
            column.setPreferredWidth(size);
        }
    }

    public static class Button {
        public static JButton createStartButton(String text) {
            JButton but = new JButton(text, ICON_START16);
            but.setContentAreaFilled(false);
            but.setBorderPainted(true);
            return but;
        }

        public static void addMouseOverRollOverAction(AbstractButton but) {
            Button.addMouseOverRollOverAction(but, false);
        }

        public static void addMouseOverRollOverAction(final AbstractButton but, final boolean onlyBorders) {
            BevelBorder bevel = new BevelBorder(0, COLOR_DARK_BLUE, COLOR_DARK_BLUE);
            but.setBorder(bevel);
            but.setBorderPainted(false);
            but.setRolloverEnabled(false);
            final Color bgColor = but.getBackground();
            but.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    but.setBorderPainted(true);
                    if (!onlyBorders) {
                        if (but.isSelected()) {
                            but.setBackground(COLOR_DARK_BLUE);
                        } else {
                            but.setBackground(bgColor);
                        }
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    but.setBorderPainted(false);
                }
            });
        }
    }
}

