/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.reports.pages;

import edu.mit.broad.genome.objects.strucs.Hyperlink;
import edu.mit.broad.genome.objects.strucs.Linked;
import java.io.File;
import org.apache.ecs.Doctype;
import org.apache.ecs.Document;
import org.apache.ecs.Element;
import org.apache.ecs.StringElement;
import org.apache.ecs.html.A;
import org.apache.ecs.html.BR;
import org.apache.ecs.html.Caption;
import org.apache.ecs.html.Div;
import org.apache.ecs.html.Link;
import org.apache.ecs.html.TD;
import org.apache.ecs.html.TH;
import org.apache.ecs.html.Title;
import org.apache.log4j.Logger;
import xapps.gsea.GseaWebResources;

public class HtmlFormat {
    private static final Logger klog = Logger.getLogger(HtmlFormat.class);
    private static final String CENTER = "center";
    private static final String image = "image";
    private static final String error = "error";
    private static final String richTable = "richTable";
    private static final String dataTable = "dataTable";
    private static final String keyValTable = "keyValTable";
    private static final String table = "table";
    private static final String lessen = "lessen";
    public static final Link CSS_XTOOLS_CANNED_REPORTS = new Link();
    public static final Link ICON_CANNED_REPORTS = new Link();

    public static void setCommonDocThings(String title, Document doc) {
        doc.setDoctype((Doctype)new Doctype.Html401Transitional());
        doc.setTitle(new Title(title));
        doc.appendHead((Element)CSS_XTOOLS_CANNED_REPORTS);
        doc.appendHead((Element)ICON_CANNED_REPORTS);
    }

    private HtmlFormat() {
    }

    public static Caption caption(String s) {
        Caption c = new Caption();
        c.addElement(s);
        return c;
    }

    public static TD _td(String s) {
        if (s != null) {
            s = s.replace('\u001c', ' ');
        }
        TD td = new TD(s);
        if (s == null || s.equals("-")) {
            td.setAlign(CENTER);
        }
        return td;
    }

    private static boolean isNullOrNA(String s) {
        return s == null || s.length() == 0 || s.equalsIgnoreCase("na") || s.equalsIgnoreCase("NULL");
    }

    public static TD _td(String term, String bgColor, Linked linked) {
        TD td = HtmlFormat._td(term);
        if (linked != null) {
            Hyperlink[] links = linked.createAllLinks();
            if (links.length > 1) {
                td.addElement((Element)new BR());
                for (int i = 0; i < links.length; ++i) {
                    if (HtmlFormat.isNullOrNA(links[i].getURL())) {
                        td.addElement((Element)new StringElement(links[i].getDisplayName()));
                    } else {
                        A a = new A(links[i].getURL(), links[i].getDisplayName());
                        td.addElement((Element)a);
                    }
                    if (i == links.length - 1) continue;
                    td.addElement(", &nbsp");
                }
            } else if (links.length == 1) {
                if (HtmlFormat.isNullOrNA(links[0].getURL())) {
                    td = new TD((Element)new StringElement(term));
                } else {
                    A a = new A(links[0].getURL(), term);
                    td = new TD((Element)a);
                }
            }
        }
        if (bgColor != null) {
            td = td.setBgColor(bgColor);
        }
        return td;
    }

    protected static TD _td(Element s) {
        return HtmlFormat._td(s.toString());
    }

    protected static TD _td(Linked l) {
        if (HtmlFormat.isNullOrNA(l.createDefaultLink().getURL())) {
            return HtmlFormat._td((Element)new StringElement(l.getText()));
        }
        A a = new A(l.createDefaultLink().getURL(), l.getText());
        return HtmlFormat._td((Element)a);
    }

    protected static TD _td(Hyperlink l) {
        if (HtmlFormat.isNullOrNA(l.getURL())) {
            return HtmlFormat._td((Element)new StringElement(l.getDisplayName()));
        }
        A a = new A(l.getURL(), l.getDisplayName());
        return HtmlFormat._td((Element)a);
    }

    protected static TD _td(Object obj) {
        if (obj instanceof Linked) {
            return HtmlFormat._td((Linked)obj);
        }
        if (obj instanceof Hyperlink) {
            return HtmlFormat._td((Hyperlink)obj);
        }
        if (obj instanceof Element) {
            return HtmlFormat._td((Element)obj);
        }
        if (obj == null) {
            TD td = HtmlFormat._td("-");
            td.setAlign(CENTER);
            return td;
        }
        return HtmlFormat._td(obj.toString());
    }

    static {
        CSS_XTOOLS_CANNED_REPORTS.setRel("stylesheet");
        CSS_XTOOLS_CANNED_REPORTS.setHref("xtools.css");
        ICON_CANNED_REPORTS.setRel("shortcut icon");
        ICON_CANNED_REPORTS.setHref(GseaWebResources.getGseaBaseURL() + "/images/icon_16x16.png");
    }

    static class MyTitle
    extends Caption {
        MyTitle(String className) {
            super.setClass(className);
        }

        MyTitle(String className, String text) {
            this(className);
            this.addElement(text);
        }
    }

    static class MyTD
    extends TD {
        MyTD(String className, String text) {
            super(text);
            super.setClass(className);
        }
    }

    static class MyTH
    extends TH {
        MyTH(String className, String text) {
            super(text);
            super.setClass(className);
        }
    }

    static class MyDiv
    extends Div {
        MyDiv(String className) {
            super.setClass(className);
        }
    }

    public static class TDs {
        public static TD lessen(String text) {
            return new MyTD(HtmlFormat.lessen, text);
        }
    }

    public static class THs {
        public static TH richTable(String text) {
            return new MyTH(HtmlFormat.richTable, text);
        }

        public static TH keyValTable(String text) {
            return new MyTH(HtmlFormat.keyValTable, text);
        }
    }

    public static class Titles {
        public static Caption table(String text) {
            return new MyTitle(HtmlFormat.table, "Table: " + text);
        }
    }

    public static class Divs {
        public static Div image() {
            return new MyDiv(HtmlFormat.image);
        }

        public static Div error() {
            return new MyDiv(HtmlFormat.error);
        }

        public static Div richTable() {
            return new MyDiv(HtmlFormat.richTable);
        }

        public static Div dataTable() {
            return new MyDiv(HtmlFormat.dataTable);
        }

        public static Div keyValTable() {
            return new MyDiv(HtmlFormat.keyValTable);
        }
    }

    public static class Links {
        public static StringElement hyper(String hyperLinkThisTerm, File file, String postTerm, File baseDir) {
            A link = new A().addElement(hyperLinkThisTerm);
            Links.setHref(link, file, baseDir);
            StringElement sel = new StringElement();
            sel.addElement((Element)link);
            sel.addElement(" " + postTerm);
            return sel;
        }

        public static StringElement hyper(String hyperLinkThisTerm, String url, String postTerm_opt) {
            A link = new A(url).addElement(hyperLinkThisTerm);
            StringElement sel = new StringElement();
            sel.addElement((Element)link);
            if (postTerm_opt != null) {
                sel.addElement(" " + postTerm_opt);
            }
            return sel;
        }

        public static StringElement hyperDir(String hyperLinkThisTerm, File dir, String postTerm) {
            A link = new A().addElement(hyperLinkThisTerm);
            Links.setHrefToDir(link, dir);
            StringElement sel = new StringElement();
            sel.addElement((Element)link);
            sel.addElement(" " + postTerm);
            return sel;
        }

        public static void setHref(A link, File linkThisFile, File baseDir) {
            if (link == null || linkThisFile == null || baseDir == null) {
                return;
            }
            try {
                File fooBaseDir = linkThisFile.isDirectory() ? linkThisFile : linkThisFile.getParentFile();
                if (fooBaseDir.equals(baseDir)) {
                    link.setHref(linkThisFile.getName());
                } else {
                    link.setHref(fooBaseDir.getName() + "/" + linkThisFile.getName());
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                link.setHref("there was an error: " + t.getMessage());
            }
        }

        public static void setHrefToDir(A link, File linkThisDir) {
            if (link == null || linkThisDir == null) {
                return;
            }
            if (!linkThisDir.isDirectory()) {
                klog.warn((Object)("Not a directory: " + linkThisDir));
            }
            try {
                link.setHref(linkThisDir.toURI().toString());
            }
            catch (Throwable t) {
                t.printStackTrace();
                link.setHref("there was an error: " + t.getMessage());
            }
        }

        public static void setHref(A link, File linkThisFile, String reltoThisBase) {
            if (linkThisFile != null) {
                link.setHref(reltoThisBase + "/" + linkThisFile.getName());
            }
        }

        public static StringElement hyper(String preTerm, String hyperLinkThisTern, File file, String postTerm, File baseDir) {
            A link = new A().addElement(hyperLinkThisTern);
            Links.setHref(link, file, baseDir);
            StringElement sel = new StringElement();
            sel.addElement(preTerm + " ");
            sel.addElement((Element)link);
            sel.addElement(" " + postTerm);
            return sel;
        }
    }
}

