/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.reports.pages;

import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.objects.Dataframe;
import edu.mit.broad.genome.objects.IDataframe;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.parsers.DataframeParser;
import edu.mit.broad.genome.parsers.StringDataframeParser;
import edu.mit.broad.genome.reports.RichDataframe;
import edu.mit.broad.genome.reports.pages.Page;
import java.io.OutputStream;

public class ExcelTxtPage
implements Page {
    private String fName;
    private IDataframe fIdf;

    public ExcelTxtPage(String name, IDataframe idf) {
        if (idf == null) {
            throw new IllegalArgumentException("Param idf cannot be null");
        }
        this.fIdf = idf instanceof RichDataframe ? ((RichDataframe)idf).getDataframe() : idf;
        this.fName = name;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getExt() {
        return "xls";
    }

    @Override
    public void write(OutputStream os) throws Exception {
        if (this.fIdf instanceof StringDataframe) {
            StringDataframeParser parser = new StringDataframeParser();
            parser.setSilentMode(true);
            parser.export((PersistentObject)this.fIdf, os);
        } else if (this.fIdf instanceof Dataframe) {
            DataframeParser parser = new DataframeParser();
            parser.setSilentMode(true);
            parser.export((PersistentObject)this.fIdf, os);
        } else {
            throw new NotImplementedException("idf object: " + this.fIdf);
        }
    }
}

