/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserException;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class GmxParser
extends AbstractParser {
    private boolean fCheckForDuplicates = true;

    public GmxParser() {
        super(GeneSetMatrix.class);
    }

    @Override
    public void export(PersistentObject gmpob, File file) throws Exception {
        int f;
        PrintWriter pw = this.startExport(gmpob, file);
        GeneSetMatrix gm = (GeneSetMatrix)gmpob;
        StringBuffer buf = new StringBuffer();
        GeneSet[] gsets = gm.getGeneSets();
        for (f = 0; f < gsets.length; ++f) {
            buf.append(gsets[f].getName()).append('\t');
        }
        buf.append('\n');
        for (f = 0; f < gsets.length; ++f) {
            String ne = gsets[f].getNameEnglish();
            if (this.isNullorNa(ne)) {
                ne = "na";
            }
            buf.append(ne).append('\t');
        }
        buf.append('\n');
        int max = gm.getMaxGeneSetSize();
        pw.print(buf.toString());
        pw.flush();
        for (int i = 0; i < max; ++i) {
            buf = new StringBuffer();
            for (int f2 = 0; f2 < gsets.length; ++f2) {
                if (i < gsets[f2].getNumMembers()) {
                    buf.append(gsets[f2].getMember(i)).append('\t');
                    continue;
                }
                buf.append("\t");
            }
            buf.append('\n');
            pw.print(buf.toString());
            pw.flush();
        }
        this.doneExport();
        pw.close();
    }

    protected void setCheckForDuplicates(boolean check) {
        this.fCheckForDuplicates = check;
    }

    @Override
    public List parse(String sourcepath, InputStream is) throws Exception {
        int i;
        this.startImport(sourcepath);
        BufferedReader bin = new BufferedReader(new InputStreamReader(is));
        String currLine = this.nextLine(bin);
        String[] gsetNames = this.parseNames(currLine);
        currLine = this.nextLine(bin);
        String[] namesEnglish = this.parseNames(currLine);
        ArrayList[] members = new ArrayList[gsetNames.length];
        for (int i2 = 0; i2 < gsetNames.length; ++i2) {
            members[i2] = new ArrayList();
        }
        currLine = this.nextLine(bin);
        int lineNum = 3;
        int expected = gsetNames.length;
        while (currLine != null) {
            List fields = GmxParser.string2stringsV2(currLine, gsetNames.length);
            if (fields.size() != expected) {
                throw new ParserException("Bad format on line: " + currLine + "< # names expected: " + expected + " but found fields on this line: " + fields.size() + " approx line#: " + lineNum);
            }
            for (i = 0; i < gsetNames.length; ++i) {
                if (this.isNull(fields.get(i))) continue;
                members[i].add(fields.get(i));
            }
            currLine = this.nextLineTrimless(bin);
            ++lineNum;
        }
        bin.close();
        GeneSet[] gsets = new GeneSet[members.length];
        for (i = 0; i < members.length; ++i) {
            String gsetName = sourcepath.concat("#").concat(gsetNames[i].toUpperCase());
            gsets[i] = new GeneSet(gsetName, namesEnglish[i], members[i], this.fCheckForDuplicates);
        }
        this.doneImport();
        return GmxParser.unmodlist(new DefaultGeneSetMatrix(sourcepath, gsets));
    }

    private String[] parseNames(String nameline) {
        return ParseUtils.string2strings(nameline, "\t", false);
    }
}

