/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.plot;

import java.awt.Graphics;
import java.awt.Graphics2D;
import org.ujmp.core.Matrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.gui.plot.PlotSettings;

public class Traces {
    private PlotSettings plotSettings = null;

    public Traces(PlotSettings plotSettings) {
        this.plotSettings = plotSettings;
    }

    public void paintComponent(Graphics g) {
        try {
            long t0 = System.currentTimeMillis();
            Graphics2D g2d = (Graphics2D)g;
            double xf = this.plotSettings.getXFactor();
            double yf = this.plotSettings.getYFactor();
            for (int t = 0; t < Math.min(10, this.plotSettings.getMatrixGUIObject().getColumnCount()); ++t) {
                long t1;
                if (this.plotSettings.isShowTrace(t)) {
                    long column = t;
                    g2d.setStroke(this.plotSettings.getTraceStroke(t));
                    g2d.setColor(this.plotSettings.getTraceColor(t));
                    double xs = this.plotSettings.getXStepSize();
                    long dots = 0L;
                    for (double xr = this.plotSettings.getMinXValue() + xs; xr <= this.plotSettings.getMaxXValue(); xr += xs) {
                        ++dots;
                        long row1 = (long)(xr - xs);
                        long row2 = (long)xr;
                        double yv1 = 0.0;
                        Object o1 = this.plotSettings.getMatrixGUIObject().getValueAt((int)row1, (int)column);
                        yv1 = o1 instanceof Matrix ? Double.NaN : MathUtil.getDouble(o1);
                        double yv2 = 0.0;
                        Object o2 = this.plotSettings.getMatrixGUIObject().getValueAt((int)row2, (int)column);
                        yv2 = o2 instanceof Matrix ? Double.NaN : MathUtil.getDouble(o2);
                        int x1 = (int)((xr - xs) * xf);
                        int x2 = (int)(xr * xf);
                        x2 = x2 == x1 ? x2++ : x2;
                        int y1 = (int)((double)(this.plotSettings.getHeight() - 1) - yv1 * yf + this.plotSettings.getMinYValue() * yf);
                        int y2 = (int)((double)(this.plotSettings.getHeight() - 1) - yv2 * yf + this.plotSettings.getMinYValue() * yf);
                        g2d.drawLine(x1, y1, x2, y2);
                    }
                }
                if ((t1 = System.currentTimeMillis()) - t0 <= this.plotSettings.getTimeLimit()) continue;
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

