/*
 * Decompiled with CFR 0.152.
 */
package xtools.gsea;

import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.objects.BitSetDataset;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.GPWrappers;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetSignal;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.reports.api.ReportIndexState;
import edu.mit.broad.genome.reports.pages.HtmlFormat;
import edu.mit.broad.genome.reports.pages.HtmlReportIndexPage;
import edu.mit.broad.xbench.heatmap.DisplayState;
import edu.mit.broad.xbench.heatmap.GramImagerImpl;
import java.awt.Dimension;
import java.io.File;
import java.util.Properties;
import org.apache.ecs.Element;
import org.apache.ecs.StringElement;
import org.apache.ecs.html.A;
import org.apache.ecs.html.Div;
import org.apache.ecs.html.H2;
import org.apache.ecs.html.H4;
import org.apache.ecs.html.LI;
import org.apache.ecs.html.TD;
import org.apache.ecs.html.TH;
import org.apache.ecs.html.TR;
import org.apache.ecs.html.Table;
import org.apache.ecs.html.UL;
import org.genepattern.gsea.GeneHistogram;
import org.genepattern.gsea.HCLAlgorithm;
import org.genepattern.gsea.JaccardHistogram;
import org.genepattern.gsea.LeadingEdgeAnalysis;
import org.genepattern.heatmap.HeatMapComponent;
import org.genepattern.heatmap.image.HeatMap;
import org.genepattern.io.ImageUtil;
import xtools.api.AbstractTool;
import xtools.api.ToolCategory;
import xtools.api.param.BooleanParam;
import xtools.api.param.DirParam;
import xtools.api.param.Param;
import xtools.api.param.StringInputParam;
import xtools.api.param.StringMultiInputParam;

public class LeadingEdgeTool
extends AbstractTool {
    private DirParam fGseaResultDirParam = new DirParam(true);
    private StringInputParam fAltDelimParam = new StringInputParam("altDelim", "alternate delimiter", "Optional alternate delimiter character for gene set names instead of comma", null, false, new char[]{';'}, Param.ADVANCED);
    private StringMultiInputParam fGeneSetNamesParam = new StringMultiInputParam("gsets", "gene sets", false);
    private StringInputParam fImageFormat = new StringInputParam("imgFormat", "image format", "File format to use for generated images: png (default), svg (will be GZ compressed), or jpg", "png", false);
    private BooleanParam fCreateExtraPlotsParam = new BooleanParam("extraPlots", "create extra LEV plots", false, false);
    private final BooleanParam fMakeZippedReportParam = AbstractTool.createZipReportParam(false);

    public LeadingEdgeTool(Properties properties) {
        super.init(properties);
    }

    public LeadingEdgeTool(String[] args) {
        super.init(args);
    }

    public LeadingEdgeTool() {
        this.declareParams();
    }

    @Override
    public String getName() {
        return "LeadingEdgeTool";
    }

    private Dataset _morph(Dataset ds, RankedList rl) {
        Matrix m = new Matrix(ds.getNumRow(), ds.getNumCol());
        for (int r = 0; r < ds.getNumRow(); ++r) {
            for (int c = 0; c < ds.getNumCol(); ++c) {
                float score = rl.getScore(ds.getColumnName(c));
                float value = ds.getElement(r, c);
                if (value == 1.0f) {
                    m.setElement(r, c, score);
                    continue;
                }
                m.setElement(r, c, value);
            }
        }
        return new DefaultDataset(ds.getName(), m, ds.getRowNames(), ds.getColumnNames(), true, ds.getAnnot());
    }

    @Override
    public void execute() throws Exception {
        ReportIndexState state = new ReportIndexState(true, false, false, LeadingEdgeTool.getHeader(this.fGseaResultDirParam));
        this.startExec(state);
        File gseaResultDir = this.fGseaResultDirParam.getFile();
        EnrichmentDb edb = ParserFactory.readEdb(gseaResultDir, true);
        if (this.fAltDelimParam.isSpecified()) {
            this.fGeneSetNamesParam.setAlternateDelimiter(this.fAltDelimParam.getValue().toString());
        }
        String[] gsetNames = null;
        if (this.fGeneSetNamesParam.isSpecified()) {
            gsetNames = this.fGeneSetNamesParam.getStrings();
        }
        boolean createExtraPlots = this.fCreateExtraPlotsParam.isSpecified() && this.fCreateExtraPlotsParam.isTrue();
        String imgFormat = this.fImageFormat.isSpecified() ? this.fImageFormat.getValue().toString() : "png";
        EnrichmentResult[] enrichmentResults = null;
        GeneSet[] gsets = null;
        if (gsetNames == null || gsetNames.length == 0) {
            enrichmentResults = LeadingEdgeAnalysis.getAllResultsFromEdb(edb);
            if (enrichmentResults == null || enrichmentResults.length == 0) {
                return;
            }
            gsetNames = new String[enrichmentResults.length];
            gsets = new GeneSet[enrichmentResults.length];
            for (int i = 0; i < enrichmentResults.length; ++i) {
                gsets[i] = enrichmentResults[i].getGeneSet();
                gsetNames[i] = gsets[i].getName(true);
            }
        } else {
            enrichmentResults = new EnrichmentResult[gsetNames.length];
            gsets = new GeneSet[gsetNames.length];
            for (int r = 0; r < gsetNames.length; ++r) {
                enrichmentResults[r] = edb.getResultForGeneSet(gsetNames[r]);
                gsets[r] = enrichmentResults[r].getSignal().getAsGeneSet();
            }
        }
        DefaultGeneSetMatrix lev_gmx = new DefaultGeneSetMatrix("leading_edge_matrix_for_" + edb.getName(), gsets);
        BitSetDataset lev_bsd = new BitSetDataset(lev_gmx);
        Dataset lev_ds = lev_bsd.toDataset();
        File lev_ds_file = this.fReport.savePage(lev_ds, false);
        Dataset lev_ds_clustered = null;
        try {
            this.log.info((Object)("Clustering signal matrix: " + lev_ds.getQuickInfo() + " " + lev_ds_file.getPath()));
            lev_ds_clustered = HCLAlgorithm.cluster(lev_ds);
        }
        catch (Throwable t) {
            this.fReport.addError("Trouble clustering", t);
        }
        if (createExtraPlots) {
            LeadingEdgeAnalysis analysis = LeadingEdgeAnalysis.runAnalysis(edb, gsetNames, null);
            JaccardHistogram jaccardHistogram = analysis.getJaccardHistogram();
            jaccardHistogram.getChartPanel().setPreferredSize(new Dimension(680, 420));
            File jaccardHistFile = this.fReport.createFile("jaccard_histogram." + imgFormat, "Jaccard Histogram");
            jaccardHistFile = ImageUtil.saveReportPlotImage(jaccardHistogram.getChartPanel(), jaccardHistFile, imgFormat);
            GeneHistogram geneHistogram = analysis.getGeneHistogram();
            geneHistogram.getChartPanel().setPreferredSize(new Dimension(680, 420));
            File geneHistFile = this.fReport.createFile("gene_histogram." + imgFormat, "Gene Histogram");
            geneHistFile = ImageUtil.saveReportPlotImage(geneHistogram.getChartPanel(), geneHistFile, imgFormat);
            HeatMapComponent geneSetSimilarityHeatmap = analysis.getGeneSetSimilarityHeatmap();
            File geneSetSimFile = this.fReport.createFile("gene_set_similarity_heatmap." + imgFormat, "Gene Set Similarity Heatmap");
            geneSetSimFile = ImageUtil.saveReportPlotImage(geneSetSimilarityHeatmap.getHeatMap(), geneSetSimFile, imgFormat);
            HeatMapComponent leadingEdgeHeatmap = analysis.getLeadingEdgePanel().getHeatMapComponent();
            File leHeatmapFile = this.fReport.createFile("leading_edge_heatmap." + imgFormat, "Leading Edge Heatmap");
            leHeatmapFile = ImageUtil.saveReportPlotImage(leadingEdgeHeatmap.getHeatMap(), leHeatmapFile, imgFormat);
        }
        HtmlReportIndexPage reportIndexPage = this.fReport.getIndexPage();
        Div div = new Div();
        H2 h2 = new H2("Leading edge results for enrichment database: <b>" + edb.getName() + "</b>");
        div.addElement((Element)h2);
        div = new Div();
        div.addElement((Element)new H4("Leading edge analysis: Clustered results"));
        UL ul = new UL();
        ul.addElement((Element)new LI("There were " + enrichmentResults.length + " gene sets used in the leading edge analysis (see below for details)"));
        Dataset lev_ds_clustered_m = this._morph(lev_ds_clustered, edb.getRankedList());
        HeatMap heatMap = new GramImagerImpl(new DisplayState(GPWrappers.createColorScheme_for_lev_with_score(lev_ds_clustered_m))).createBpogHeatMap(lev_ds_clustered_m);
        File lev_clust_hm_file = this.fReport.createFile("leading_edge_heat_map_clustered." + imgFormat, "foo");
        lev_clust_hm_file = ImageUtil.saveReportPlotImage(heatMap, lev_clust_hm_file, imgFormat);
        StringElement line3 = HtmlFormat.Links.hyper("Heat map of clustered leading edge subsets", lev_clust_hm_file, ". Rows are gene sets and columns are genes. This matrix is clustered", this.fReport.getReportDir());
        ul.addElement((Element)new LI((Element)line3));
        div.addElement((Element)ul);
        reportIndexPage.addBlock(div, true);
        Table table = new Table();
        TH th = new TH();
        th.addElement((Element)new TD("# members"));
        th.addElement((Element)new TD("# members<br>in signal"));
        th.addElement((Element)new TD("Tag %"));
        th.addElement((Element)new TD("List %"));
        th.addElement((Element)new TD("Signal strength"));
        table.addElement((Element)th);
        for (int r = 0; r < enrichmentResults.length; ++r) {
            TR tr = new TR();
            String gsetName = enrichmentResults[r].getGeneSetName();
            File gsetGseaFile = new File(gseaResultDir, gsetName + ".html");
            A link = new A(gsetGseaFile.toURI().toString(), gsetName);
            tr.addElement((Element)new TD((Element)link));
            tr.addElement((Element)new TD("" + enrichmentResults[r].getGeneSet().getNumMembers()));
            GeneSetSignal signal = enrichmentResults[r].getSignal();
            tr.addElement((Element)new TD("" + signal.getSize()));
            tr.addElement((Element)new TD(Printf.format(signal.getTagFraction() * 100.0f, 0) + "%"));
            tr.addElement((Element)new TD(Printf.format(signal.getListFraction() * 100.0f, 0) + "%"));
            tr.addElement((Element)new TD(Printf.format(signal.getSignalStrength() * 100.0f, 0) + "%"));
            table.addElement((Element)tr);
        }
        div = new Div();
        div.addElement((Element)new H4("Details of gene sets and signals used in this analysis"));
        div.addElement((Element)table);
        reportIndexPage.addBlock(div, true);
        div = new Div();
        div.addElement((Element)new H4("Leading edge analysis: other files made"));
        ul = new UL();
        File lev_ds_clustered_file = this.fReport.savePage(lev_ds_clustered, false);
        StringElement line2 = HtmlFormat.Links.hyper("Clustered dataset (gct)", lev_ds_clustered_file, "for the specified gene sets. 1's denote membership of a gene in the leading edge subset", this.fReport.getReportDir());
        ul.addElement((Element)new LI((Element)line2));
        File lev_gmx_file = this.fReport.savePageGmx(lev_gmx);
        StringElement line1 = HtmlFormat.Links.hyper("GeneSetMatrix (gmx)", lev_gmx_file, "of leading edge subsets", this.fReport.getReportDir());
        ul.addElement((Element)new LI((Element)line1));
        line2 = HtmlFormat.Links.hyper("Dataset (gct)", lev_ds_file, "for the specified gene sets. 1's denote membership of a gene in the leading edge subset", this.fReport.getReportDir());
        ul.addElement((Element)new LI((Element)line2));
        HeatMap lev_image = new GramImagerImpl(new DisplayState(GPWrappers.createColorScheme_for_lev_with_score(lev_ds))).createBpogHeatMap(this._morph(lev_ds, edb.getRankedList()));
        File lev_hm_file = this.fReport.createFile("leading_edge_heat_map_unclustered." + imgFormat, "foo");
        lev_hm_file = ImageUtil.saveReportPlotImage(lev_image, lev_hm_file, imgFormat);
        line3 = HtmlFormat.Links.hyper("Heat map of leading edge subsets", lev_hm_file, ". Rows are gene sets and columns are genes. This matrix is NOT clustered", this.fReport.getReportDir());
        ul.addElement((Element)new LI((Element)line3));
        div.addElement((Element)ul);
        reportIndexPage.addBlock(div, true);
        div = new Div();
        ul = new UL();
        div.addElement((Element)new H4("Other"));
        ul.addElement((Element)new LI((Element)HtmlFormat.Links.hyper("Parameters", this.fReport.getParamsFile(), "used for this analysis", this.fReport.getReportDir())));
        div.addElement((Element)ul);
        reportIndexPage.addBlock(div, false);
        reportIndexPage.setAddBrowseFooter(false);
        if (this.fMakeZippedReportParam.isTrue()) {
            this.fReport.closeReport(true);
            this.fReport.zipReport();
        }
        this.doneExec();
    }

    @Override
    public ToolCategory getCategory() {
        return ToolCategory.GSEA;
    }

    @Override
    public void declareParams() {
        this.fParamSet.addParam(this.fGseaResultDirParam);
        this.fParamSet.addParam(this.fAltDelimParam);
        this.fParamSet.addParam(this.fGeneSetNamesParam);
        this.fParamSet.addParam(this.fImageFormat);
        this.fParamSet.addParam(this.fCreateExtraPlotsParam);
        this.fParamSet.addParam(this.fMakeZippedReportParam);
    }

    public static void main(String[] args) {
        LeadingEdgeTool tool = new LeadingEdgeTool(args);
        LeadingEdgeTool.tool_main(tool);
    }

    private static String getHeader(DirParam dirp) {
        try {
            if (dirp.isSpecified()) {
                String dpn = dirp.getDir().getName();
                StringBuffer buf = new StringBuffer();
                buf.append("<div id=\"footer\" style=\"width: 905; height: 35\">\n").append("<h3 style=\"text-align: left\"><font color=\"#808080\">Leading edge report for ").append("GSEA result folder: ").append(dpn).append("</font></h3>\n").append("</div>");
                return buf.toString();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }
}

