/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.math.RandomSeedGenerator;
import edu.mit.broad.genome.math.RandomSeedGenerators;
import edu.mit.broad.genome.swing.fields.GComboBoxField;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import xtools.api.param.AbstractParam;
import xtools.api.param.ParamHelper;

public class RandomSeedTypeParam
extends AbstractParam
implements ActionListener {
    private GComboBoxField cbOptions;

    public RandomSeedTypeParam(boolean reqd) {
        this(RandomSeedTypeParam.createAll(), reqd);
    }

    public RandomSeedTypeParam(String[] rsts, boolean reqd) {
        super("rnd_seed", "Seed for permutation", String.class, "Seed to use for randomization (a long number)", (Object)rsts[0], (Object[])rsts, reqd);
    }

    @Override
    public boolean isFileBased() {
        return false;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            super.setValue(null);
        } else {
            super.setValue(RandomSeedGenerators.lookup(value));
        }
    }

    public RandomSeedGenerator createSeed() {
        Object val = super.getValue();
        if (val == null) {
            throw new NullPointerException("Null param value. Always check isSpecified() before calling");
        }
        return RandomSeedGenerators.lookup(val);
    }

    @Override
    public GFieldPlusChooser getSelectionComponent() {
        if (this.cbOptions == null) {
            this.cbOptions = ParamHelper.createActionListenerBoundHintsComboBox(true, this, this);
            ParamHelper.safeSelectValueDefaultByString(this.cbOptions.getComboBox(), this);
        }
        return this.cbOptions;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.setValue(((JComboBox)this.cbOptions.getComponent()).getSelectedItem());
    }

    public static String[] createAll() {
        return new String[]{new RandomSeedGenerators.Timestamp().toString(), new RandomSeedGenerators.Standard().toString()};
    }
}

