/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.swing.fields.GComboBoxField;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import xtools.api.param.AbstractParam;
import xtools.api.param.ParamHelper;

public class OrderParam
extends AbstractParam
implements ActionListener {
    private GComboBoxField cbOptions;

    public OrderParam(boolean reqd) {
        this(Order.DESCENDING, reqd);
    }

    public OrderParam(Order def, boolean reqd) {
        super("order", "Gene list ordering mode", Order.class, "Direction in which the gene list should be ordered", (Object)def, (Object[])Order.ALL, reqd);
    }

    @Override
    public boolean isFileBased() {
        return false;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            super.setValue(null);
        } else {
            super.setValue(Order.lookup(value));
        }
    }

    public void setValue(Order order) {
        super.setValue(order);
    }

    public Order getOrder() {
        Object val = super.getValue();
        if (val == null) {
            throw new NullPointerException("Null param value. Always check isSpecified() before calling");
        }
        return (Order)val;
    }

    @Override
    public GFieldPlusChooser getSelectionComponent() {
        if (this.cbOptions == null) {
            this.cbOptions = ParamHelper.createActionListenerBoundHintsComboBox(false, this, this);
            ParamHelper.safeSelectValueDefaultByString(this.cbOptions.getComboBox(), this);
        }
        return this.cbOptions;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.setValue((Order)((JComboBox)this.cbOptions.getComponent()).getSelectedItem());
    }
}

