/*
 * Decompiled with CFR 0.152.
 */
package xtools.api;

import edu.mit.broad.genome.Conf;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.alg.GeneSetGenerators;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.reports.api.Report;
import edu.mit.broad.genome.reports.api.ReportIndexState;
import edu.mit.broad.genome.reports.api.ToolReport;
import edu.mit.broad.genome.utils.ClassUtils;
import edu.mit.broad.genome.utils.CmdLineArgs;
import edu.mit.broad.genome.utils.SystemUtils;
import edu.mit.broad.genome.utils.Timer;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.xbench.core.api.Application;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.apache.ecs.Element;
import org.apache.ecs.html.Div;
import org.apache.ecs.html.H4;
import org.apache.log4j.Logger;
import xapps.gsea.UpdateChecker;
import xtools.api.Tool;
import xtools.api.XToolsApplication;
import xtools.api.param.BooleanParam;
import xtools.api.param.ChipOptParam;
import xtools.api.param.GuiParam;
import xtools.api.param.IntegerParam;
import xtools.api.param.Param;
import xtools.api.param.ParamSet;
import xtools.api.param.ReportDirParam;
import xtools.api.param.ReportLabelParam;
import xtools.api.param.ToolParamSet;

public abstract class AbstractTool
implements Tool {
    public static final String REPORT_INDEX = "xtools.report_index";
    private PrintStream fOut;
    protected transient Logger log;
    protected static final transient Logger klog;
    protected ToolParamSet fParamSet;
    private Timer fTimer;
    private boolean fHelpMode;
    protected static final Object[] EMPTY_OBJECTS;
    protected final BooleanParam fHelpParam = new BooleanParam("help", "Usage information on the tool", false);
    private ReportDirParam fReportDirParam;
    private GuiParam fGuiParam;
    private ReportLabelParam fRptLabelParam;
    protected ToolReport fReport;
    private static int SHARED_PARAM_CNT;

    protected AbstractTool() {
        this("dummy");
    }

    @Override
    public String getHelpURL() {
        return JarResources.getHelpURL(this.getClass().getName());
    }

    public PrintStream getOutputStream() {
        if (this.fOut == null) {
            this.fOut = System.out;
        }
        return this.fOut;
    }

    protected AbstractTool(String toolName) {
        this.fTimer = new Timer();
        this.log = Logger.getLogger(this.getClass());
        if (!Application.isHandlerSet()) {
            Application.registerHandler(new XToolsApplication());
        }
        this.fParamSet = new ToolParamSet();
        this.fGuiParam = new GuiParam();
        this.fRptLabelParam = new ReportLabelParam(false);
        this.fReportDirParam = new ReportDirParam(false);
        this.fParamSet.addParam(this.fGuiParam);
        this.fParamSet.addParam(this.fReportDirParam);
        this.fParamSet.addParam(this.fRptLabelParam);
    }

    protected void init(Properties prp) {
        this.fParamSet.addParam(this.fHelpParam);
        this.declareParams();
        if (prp != null && (prp.containsKey("help") || prp.containsKey("HELP"))) {
            this.fHelpMode = true;
        }
        if (this.isHelpMode()) {
            this.fParamSet.printfUsage();
            Conf.exitSystem(false);
        } else {
            this.fParamSet.fill(prp);
            this.fParamSet.check();
            this.ensureAllDeclaredWereAdded();
            this.checkHeadlessState();
        }
    }

    protected void init(String[] args) {
        try {
            String param_file_path;
            Properties prp = CmdLineArgs.parse(args);
            String argline = CmdLineArgs.toString(args);
            int index = argline.indexOf("help");
            if (index != -1) {
                prp.setProperty("help", Boolean.TRUE.toString());
            }
            if ((param_file_path = prp.getProperty("param_file")) != null && param_file_path.length() > 0) {
                this.enhanceParams(param_file_path, prp);
            }
            this.init(prp);
        }
        catch (Throwable t) {
            t.printStackTrace();
            if (this.fReport != null) {
                this.fReport.setErroredOut();
            } else {
                this.log.info((Object)"No report dir was made yet (analysis errored out)");
            }
            Conf.exitSystem(true);
        }
    }

    private void enhanceParams(String filepath, Properties prp) throws Exception {
        Properties addPrp = ParseUtils.readKeyVal(filepath, false, true, false);
        Iterator<Object> it = addPrp.keySet().iterator();
        while (it.hasNext()) {
            String param_name = it.next().toString();
            String param_val = addPrp.getProperty(param_name);
            if (prp.containsKey(param_name)) {
                String extant_param_val = prp.getProperty(param_name);
                if (param_val.equals(extant_param_val)) continue;
                this.log.warn((Object)("Ignoring param_file key: " + param_name + " value: " + param_val + " in favor of cmd line value: " + extant_param_val));
                continue;
            }
            prp.setProperty(param_name, param_val);
        }
    }

    protected void startExec() throws IOException {
        this.startExec(this.getHeader());
    }

    protected String getHeader() {
        StringBuffer buf = new StringBuffer();
        buf.append("<div id=\"footer\" style=\"width: 905; height: 35\">\n").append("<h3 style=\"text-align: left\"><font color=\"#808080\">Report for: ").append(this.getClass().getName()).append("</font></h3>\n").append("</div>");
        return buf.toString();
    }

    protected void startExec(String optHeader) throws IOException {
        this.startExec(this.makeReportIndexPage(), optHeader);
    }

    protected void startExec(ReportIndexState indexState) throws IOException {
        UpdateChecker.oneTimeGseaUpdateCheck(null);
        this.fTimer.start();
        this.fReport = new ToolReport(this, true, indexState);
    }

    protected void startExec(boolean makeReportIndexPage, String headerOpt) throws IOException {
        this.startExec(new ReportIndexState(makeReportIndexPage, headerOpt));
    }

    private boolean makeReportIndexPage() {
        String p = System.getProperty(REPORT_INDEX);
        if (p == null || p.length() == 0) {
            return true;
        }
        return Boolean.valueOf(p);
    }

    public void doneExec() {
        if (!this.fReport.getToolComments().isEmpty()) {
            Div div = new Div();
            H4 h4 = new H4("Comments");
            div.addElement((Element)h4);
            div.addElement((Element)this.fReport.getToolComments().toHTML());
            if (this.fReport.getIndexPage() != null) {
                this.fReport.getIndexPage().addBlock(div, false);
            }
        }
        this.fReport.closeReport(true);
        if (this.fGuiParam.isTrue()) {
            this.fReport.display();
        }
        this.fTimer.stop();
        this.fTimer.printTimeTakenS();
    }

    @Override
    public Report getReport() {
        return this.fReport;
    }

    private void checkHeadlessState() {
    }

    private int countParamFields(Class cl) {
        Field[] fields = cl.getDeclaredFields();
        int paramcnt = 0;
        for (int i = 0; i < fields.length; ++i) {
            Class<?> fc = fields[i].getType();
            boolean isParam = Param.class.isAssignableFrom(fc);
            if (!isParam) continue;
            ++paramcnt;
        }
        return paramcnt;
    }

    protected void ensureAllDeclaredWereAdded() {
        int paramCnt = SHARED_PARAM_CNT;
        paramCnt += this.countParamFields(this.getClass());
        if (!this.getClass().getSuperclass().getName().equals("xtools.api.AbstractTool")) {
            paramCnt += this.countParamFields(this.getClass().getSuperclass());
        }
        if (!this.getClass().getSuperclass().getSuperclass().getName().equals("xtools.api.AbstractTool")) {
            paramCnt += this.countParamFields(this.getClass().getSuperclass().getSuperclass());
        }
        if (this.fParamSet.getNumParams() != paramCnt) {
            StringBuffer buf = new StringBuffer("Have you forgotten to update declareParams()?").append('\n');
            buf.append("In ParamSet # declared: ").append(this.fParamSet.getNumParams()).append(" is NOT equal to deduced thro reflection # : ").append(paramCnt);
            throw new IllegalStateException(buf.toString());
        }
    }

    public boolean isHelpMode() {
        return this.fHelpMode;
    }

    @Override
    public ParamSet getParamSet() {
        this.fParamSet.sort();
        return this.fParamSet;
    }

    @Override
    public String getTitle() {
        String sn = ClassUtils.shorten(this.getClass().getName());
        String desc = this.getDesc();
        if (desc == null || desc.length() == 0) {
            return "<html><body><b>" + sn + "</b></body></html>";
        }
        return "<html><body><b>" + sn + "</b>: " + desc + "</body></html>";
    }

    @Override
    public String getDesc() {
        return "";
    }

    public static BooleanParam createZipReportParam(boolean reqd) {
        return new BooleanParam("zip_report", "Make a zipped file with all reports", "Create a zipped file with all files made by the report. This can be emailed to share results", false, reqd, Param.ADVANCED);
    }

    protected static void tool_main(AbstractTool tool) {
        if (tool == null) {
            throw new IllegalArgumentException("Param tool cannot be null");
        }
        boolean was_error = false;
        try {
            tool.execute();
        }
        catch (Throwable t) {
            was_error = true;
            t.printStackTrace();
        }
        if (was_error && tool.getReport() != null) {
            tool.getReport().setErroredOut();
        }
        if (tool.getParamSet().getGuiParam().isFalse()) {
            Conf.exitSystem(was_error);
        }
    }

    public static boolean module_main(AbstractTool tool) {
        if (tool == null) {
            throw new IllegalArgumentException("Param tool cannot be null");
        }
        try {
            tool.execute();
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            if (tool.getReport() != null) {
                tool.getReport().setErroredOut();
            }
            return false;
        }
    }

    public static void setChip(Dataset ds, ChipOptParam chipOptParam) throws Exception {
        if (chipOptParam != null && chipOptParam.isSpecified()) {
            AbstractTool.setChip(ds, chipOptParam.getChip());
        }
    }

    private static void setChip(Dataset ds, Chip chip) throws Exception {
        if (chip != null) {
            ds.getAnnot().setChip(chip);
        }
    }

    static {
        if (!SystemUtils.isPropertyDefined("java.awt.headless")) {
            System.setProperty("java.awt.headless", "true");
        }
        klog = Logger.getLogger(AbstractTool.class);
        EMPTY_OBJECTS = new Object[0];
        SHARED_PARAM_CNT = 4;
    }

    public static class Helper {
        public static GeneSet[] getGeneSets(Object ds_or_rl, GeneSet[] gsets, IntegerParam geneSetMinSizeParam, IntegerParam geneSetMaxSizeParam) throws Exception {
            if (geneSetMaxSizeParam.getIValue() < geneSetMinSizeParam.getIValue()) {
                throw new IllegalArgumentException("Max size cannot be less than min size");
            }
            klog.info((Object)("Got gsets: " + gsets.length + " now preprocessing them ... min: " + geneSetMinSizeParam.getIValue() + " max: " + geneSetMaxSizeParam.getIValue()));
            if (geneSetMinSizeParam.getIValue() != geneSetMaxSizeParam.getIValue()) {
                boolean do_cloning;
                if (geneSetMinSizeParam.isSpecified()) {
                    gsets = GeneSetGenerators.removeGeneSetsSmallerThan(gsets, geneSetMinSizeParam.getIValue(), ds_or_rl, true);
                    do_cloning = false;
                } else {
                    do_cloning = true;
                }
                klog.info((Object)("Done preproc for smaller than: " + geneSetMinSizeParam.getIValue()));
                if (geneSetMaxSizeParam.isSpecified()) {
                    gsets = GeneSetGenerators.removeGeneSetsLargerThan(gsets, geneSetMaxSizeParam.getIValue(), ds_or_rl, do_cloning);
                }
            } else {
                klog.info((Object)"Skipped gene set size filtering");
            }
            klog.debug((Object)"Done geneset preproc starting analysis ...");
            return Helper.removeAllZeroMemberSets(gsets);
        }

        private static GeneSet[] removeAllZeroMemberSets(GeneSet[] gsets) {
            ArrayList<GeneSet> list = new ArrayList<GeneSet>();
            for (int i = 0; i < gsets.length; ++i) {
                if (gsets[i].getNumMembers() <= 0) continue;
                list.add(gsets[i]);
            }
            return list.toArray(new GeneSet[list.size()]);
        }
    }
}

