/*
 * Decompiled with CFR 0.152.
 */
package xapps.gsea;

import edu.mit.broad.genome.Constants;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.parsers.ParserWorker;
import edu.mit.broad.genome.reports.api.Report;
import edu.mit.broad.genome.viewers.DatasetViewerAction;
import edu.mit.broad.genome.viewers.GeneSetMatrixViewerAction;
import edu.mit.broad.genome.viewers.GeneSetViewerAction;
import edu.mit.broad.genome.viewers.PhenotypeViewerAction;
import edu.mit.broad.genome.viewers.RankedListViewerAction;
import edu.mit.broad.genome.viewers.ReportViewerAction;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.xbench.actions.ChipViewerAction;
import edu.mit.broad.xbench.actions.PobActions;
import edu.mit.broad.xbench.actions.XAction;
import edu.mit.broad.xbench.actions.ext.OsExplorerAction;
import edu.mit.broad.xbench.actions.misc_actions.GeneSetMatrix2GeneSetAction;
import edu.mit.broad.xbench.actions.misc_actions.GeneSetMatrix2GeneSetsAction;
import edu.mit.broad.xbench.actions.misc_actions.GeneSetRemoveDuplicatesAction;
import edu.mit.broad.xbench.actions.misc_actions.LoadAction;
import edu.mit.broad.xbench.core.api.Application;
import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import xapps.api.frameworks.AbstractActionLookup;

class GseaActionRegistry
extends AbstractActionLookup
implements Constants {
    static final Logger klog = Logger.getLogger(GseaActionRegistry.class);
    private static PobActions COMMON_ACTIONS;
    private static PobActions GEX_ACTIONS;
    private static PobActions CHIP_ACTIONS;
    private static PobActions GRP_ACTIONS;
    private static PobActions CLS_ACTIONS;
    private static PobActions RNK_ACTIONS;
    private static PobActions GMX_ACTIONS;
    private static PobActions GMT_ACTIONS;
    private static PobActions RPT_ACTIONS;
    private static GseaActionRegistry kSingleton;

    protected static GseaActionRegistry getInstance() {
        if (kSingleton == null) {
            kSingleton = new GseaActionRegistry();
        }
        return kSingleton;
    }

    private GseaActionRegistry() {
        this.fExtActionsMap.put("res", GEX_ACTIONS);
        this.fExtActionsMap.put("txt", GEX_ACTIONS);
        this.fExtActionsMap.put("pcl", GEX_ACTIONS);
        this.fExtActionsMap.put("gct", GEX_ACTIONS);
        this.fExtActionsMap.put("cls", CLS_ACTIONS);
        this.fExtActionsMap.put("grp", GRP_ACTIONS);
        this.fExtActionsMap.put("gmx", GMX_ACTIONS);
        this.fExtActionsMap.put("gmt", GMT_ACTIONS);
        this.fExtActionsMap.put("def", COMMON_ACTIONS);
        this.fExtActionsMap.put("rpt", RPT_ACTIONS);
        this.fExtActionsMap.put("chip", CHIP_ACTIONS);
        this.fExtActionsMap.put("rnk", RNK_ACTIONS);
    }

    private static PobActions _addCommon(XAction[] customs) {
        ArrayList<XAction> all = new ArrayList<XAction>();
        int cnt = 0;
        int i = 0;
        while (i < customs.length) {
            all.add(customs[i]);
            ++i;
            ++cnt;
        }
        if (cnt != 0) {
            all.add(null);
        }
        for (i = 0; i < GseaActionRegistry.COMMON_ACTIONS.allActions.length; ++i) {
            all.add(GseaActionRegistry.COMMON_ACTIONS.allActions[i]);
        }
        return new PobActions(all.toArray(new XAction[all.size()]));
    }

    @Override
    protected PobActions lookupActions(Object obj) {
        String name = "";
        if (obj instanceof Dataset || name.endsWith("res") || name.endsWith("gct") || name.endsWith("pcl") || name.endsWith("txt")) {
            return GEX_ACTIONS;
        }
        if (obj instanceof GeneSet || name.endsWith(".grp")) {
            return GRP_ACTIONS;
        }
        if (obj instanceof GeneSetMatrix || name.endsWith("gmx") || name.endsWith("gmt")) {
            return GMX_ACTIONS;
        }
        if (obj instanceof Report || name.endsWith("rpt")) {
            return RPT_ACTIONS;
        }
        if (obj instanceof Chip || name.endsWith("chip")) {
            return CHIP_ACTIONS;
        }
        if (obj instanceof Template || name.endsWith("cls")) {
            return CLS_ACTIONS;
        }
        if (obj instanceof RankedList) {
            return RNK_ACTIONS;
        }
        return new PobActions();
    }

    public boolean runDefaultAction(Object obj) {
        if (obj instanceof File || obj instanceof File[]) {
            String filename;
            File[] files = obj instanceof File ? new File[]{(File)obj} : (File[])obj;
            if (files.length == 1 && (StringUtils.endsWithIgnoreCase((CharSequence)(filename = files[0].getName()), (CharSequence)"html") || StringUtils.endsWithIgnoreCase((CharSequence)filename, (CharSequence)"xls"))) {
                URI fileURI = files[0].toURI();
                try {
                    fileURI = new URI(fileURI.getScheme(), "", fileURI.getPath(), null, null);
                    Desktop.getDesktop().browse(fileURI);
                }
                catch (Exception e) {
                    Application.getWindowManager().showError(e.toString());
                }
                return true;
            }
            new ParserWorker(files).execute();
            return true;
        }
        return false;
    }

    static {
        klog.debug((Object)"Initializing GseaActionRegistry");
        COMMON_ACTIONS = new PobActions(new XAction[]{new LoadAction(), null, new OsExplorerAction()});
        GEX_ACTIONS = GseaActionRegistry._addCommon(new XAction[]{new DatasetViewerAction()});
        CHIP_ACTIONS = GseaActionRegistry._addCommon(new XAction[]{new ChipViewerAction()});
        GRP_ACTIONS = GseaActionRegistry._addCommon(new XAction[]{new GeneSetViewerAction(), null, new GeneSetRemoveDuplicatesAction()});
        CLS_ACTIONS = GseaActionRegistry._addCommon(new XAction[]{new PhenotypeViewerAction()});
        RNK_ACTIONS = GseaActionRegistry._addCommon(new XAction[]{new RankedListViewerAction()});
        GMT_ACTIONS = GMX_ACTIONS = GseaActionRegistry._addCommon(new XAction[]{new GeneSetMatrixViewerAction(), null, new GeneSetMatrix2GeneSetsAction(), new GeneSetMatrix2GeneSetAction()});
        RPT_ACTIONS = GseaActionRegistry._addCommon(new XAction[]{new ReportViewerAction()});
    }
}

