/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.heatmap;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jidesoft.plaf.xerto.VerticalLabelUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.LabelUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.genepattern.annotation.FeatureAnnotatorPanel;
import org.genepattern.annotation.SampleAnnotatorPanel;
import org.genepattern.annotation.SetAnnotator;
import org.genepattern.annotation.SetAnnotatorModel;
import org.genepattern.annotation.SparseClassVector;
import org.genepattern.data.expr.ExpressionData;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.data.expr.Util;
import org.genepattern.data.matrix.IExpressionDataUtil;
import org.genepattern.heatmap.ColorScheme;
import org.genepattern.heatmap.HeatMapPanel;
import org.genepattern.heatmap.image.DisplaySettings;
import org.genepattern.heatmap.image.FeatureAnnotator;
import org.genepattern.heatmap.image.HeatMap;
import org.genepattern.heatmap.image.SampleAnnotator;
import org.genepattern.io.ImageUtil;
import org.genepattern.menu.FileMenu;
import org.genepattern.menu.FindAction;
import org.genepattern.module.VisualizerUtil;
import org.genepattern.plot.ProfilePlot;
import org.genepattern.table.GPTable;
import org.genepattern.uiutil.CenteredDialog;
import org.genepattern.uiutil.FileChooser;
import org.genepattern.uiutil.UIUtil;

public class HeatMapComponent
extends JComponent {
    private Component accessoryComponent;
    private boolean allowChangeColumnNameVisibility = true;
    private boolean allowChangeRowDescriptionsVisibility = true;
    private boolean allowChangeRowNameVisibility = true;
    private JPanel bottomPanel;
    private IExpressionData data;
    private FeatureAnnotatorPanel featureAnnotatorPanel;
    private JTable featureTable;
    private AbstractTableModel featureTableModel;
    private String featureUIString = "Feature";
    private JPanel heatMapAndAnnotatorPanel;
    private HeatMapPanel heatMapPanel;
    protected OptionsDialog optionsDialog;
    private Frame parent;
    private ProfilePlot plot;
    private JPopupMenu popupMenu;
    private boolean showPopupMenu = true;
    private SampleAnnotatorPanel sampleAnnotatorPanel;
    private JTable sampleTable;
    private AbstractTableModel sampleTableModel;
    private String sampleUIString = "Sample";
    private SaveDataset saveDataset;
    private JScrollPane scrollPane;
    private SetAnnotator setFeatureAnnotator;
    private SetAnnotator setSampleAnnotator;
    private boolean showColorSchemeOptions = true;
    private boolean showColumnNames = true;
    private boolean showRowDescriptions = true;
    private boolean showRowNames = true;
    private JLabel statusLabel = new JLabel("");
    private JPanel topPanel;
    private HeatMap heatMap = null;

    public static Map getFeatureName2ColorsMap(SparseClassVector featureCV, IExpressionData data, boolean byRow) {
        int end;
        HashMap featureName2Colors = new HashMap();
        int n = end = byRow ? data.getRowCount() : data.getColumnCount();
        for (int i = 0; i < end; ++i) {
            List numbers = featureCV.getClassNumbers(i);
            if (numbers == null || numbers.size() <= 0) continue;
            String name = byRow ? data.getRowName(i) : data.getColumnName(i);
            ArrayList<Color> colors = new ArrayList<Color>();
            featureName2Colors.put(name, colors);
            for (int k = 0; k < numbers.size(); ++k) {
                Integer n2 = (Integer)numbers.get(k);
                colors.add(featureCV.getColor(n2));
            }
        }
        return featureName2Colors;
    }

    public HeatMapComponent(Frame parent, IExpressionData _data, Component accessoryComponent) {
        this.accessoryComponent = accessoryComponent;
        this.parent = parent;
        this.popupMenu = new JPopupMenu();
        JMenuItem profile2MenuItem = new JMenuItem("Profile");
        profile2MenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeatMapComponent.this.showProfilePlot();
            }
        });
        this.popupMenu.add(profile2MenuItem);
        this.data = _data;
        this.saveDataset = parent != null ? new SaveDataset() : null;
        this.heatMapPanel = new HeatMapPanel(this.data);
        this.featureTableModel = this.createRowTableModel();
        String[] rowNames = new String[this.data.getRowCount()];
        int rows = this.data.getRowCount();
        for (int i = 0; i < rows; ++i) {
            rowNames[i] = this.data.getRowName(i);
        }
        this.setFeatureAnnotator = new SetAnnotator(parent, new SetAnnotatorModel(){

            @Override
            public int getFeatureCount() {
                return HeatMapComponent.this.data.getRowCount();
            }

            @Override
            public int getIndex(String name) {
                return HeatMapComponent.this.data.getRowIndex(name);
            }

            @Override
            public String getName(int index) {
                return HeatMapComponent.this.data.getRowName(index);
            }
        }, true);
        this.featureTable = new GPTable(this.featureTableModel){

            @Override
            public void processMouseEvent(MouseEvent e) {
                if (e.isPopupTrigger() && HeatMapComponent.this.showPopupMenu) {
                    HeatMapComponent.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                } else {
                    super.processMouseEvent(e);
                }
            }
        };
        this.featureTable.setColumnSelectionAllowed(false);
        this.featureTable.setGridColor(new Color(239, 239, 255));
        this.featureTable.setRowHeight(this.heatMapPanel.getRowSize());
        this.featureTable.setFont(new Font("monospaced", 0, this.heatMapPanel.getRowSize()));
        this.sampleTableModel = new AbstractTableModel(){

            public Class getColumnClass(int c) {
                return String.class;
            }

            @Override
            public int getColumnCount() {
                return HeatMapComponent.this.data.getColumnCount();
            }

            @Override
            public int getRowCount() {
                return HeatMapComponent.this.showColumnNames ? 1 : 0;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return HeatMapComponent.this.data.getColumnName(columnIndex);
            }
        };
        this.setSampleAnnotator = new SetAnnotator(parent, new SetAnnotatorModel(){

            @Override
            public int getFeatureCount() {
                return HeatMapComponent.this.data.getColumnCount();
            }

            @Override
            public int getIndex(String name) {
                return HeatMapComponent.this.data.getColumnIndex(name);
            }

            @Override
            public String getName(int index) {
                return HeatMapComponent.this.data.getColumnName(index);
            }
        }, false);
        this.sampleTable = new GPTable(null){

            @Override
            public void addColumn(TableColumn c) {
                super.addColumn(c);
                HeatMapComponent.this.layoutSampleTableColumn(c, HeatMapComponent.this.heatMapPanel.getColumnSize());
            }
        };
        VerticalLabelUI renderer = new VerticalLabelUI(false){

            public void installUI(JComponent c) {
                super.installUI(c);
                c.setBackground(UIManager.getDefaults().getColor("Table.background"));
            }
        };
        ((JLabel)((Object)this.sampleTable.getDefaultRenderer(String.class))).setUI((LabelUI)renderer);
        this.sampleTable.setRowSelectionAllowed(false);
        this.sampleTable.setModel(this.sampleTableModel);
        this.sampleTable.setGridColor(new Color(239, 239, 255));
        this.sampleTable.setColumnSelectionAllowed(true);
        System.setProperty("org.genepattern.menu.showAccelerators", "false");
        this.plot = new ProfilePlot(parent, this.data);
        System.setProperty("org.genepattern.menu.showAccelerators", "true");
        FormLayout fl = new FormLayout("pref, pref, pref:g(1)", "pref");
        CellConstraints cc = new CellConstraints();
        this.bottomPanel = new JPanel((LayoutManager)fl);
        this.heatMapAndAnnotatorPanel = new JPanel((LayoutManager)new FormLayout("pref, pref", "pref"));
        this.heatMapAndAnnotatorPanel.add((Component)this.heatMapPanel, cc.xy(1, 1, CellConstraints.FILL, CellConstraints.TOP));
        this.featureAnnotatorPanel = new FeatureAnnotatorPanel(this.setFeatureAnnotator.getClassVector(), _data, this.heatMapPanel.getRowSize(), this.heatMapAndAnnotatorPanel);
        this.heatMapAndAnnotatorPanel.add((Component)this.featureAnnotatorPanel, cc.xy(2, 1, CellConstraints.LEFT, CellConstraints.TOP));
        this.bottomPanel.add((Component)this.heatMapAndAnnotatorPanel, cc.xy(2, 1, CellConstraints.LEFT, CellConstraints.TOP));
        JPanel temp = new JPanel(new BorderLayout());
        temp.setBorder(BorderFactory.createEmptyBorder(2, 1, 0, 0));
        temp.add(this.featureTable);
        this.bottomPanel.add((Component)temp, cc.xy(3, 1, CellConstraints.FILL, CellConstraints.TOP));
        this.topPanel = new JPanel((LayoutManager)new FormLayout("pref, pref:g", "pref, pref, pref"));
        this.topPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        this.topPanel.add((Component)this.sampleTable, cc.xy(1, 2));
        this.topPanel.add((Component)this.featureTable.getTableHeader(), cc.xy(2, 3, CellConstraints.FILL, CellConstraints.BOTTOM));
        this.setAccessoryComponent(accessoryComponent, 1);
        this.sampleAnnotatorPanel = new SampleAnnotatorPanel(this.setSampleAnnotator.getClassVector(), _data, this.heatMapPanel.getColumnSize(), this.topPanel);
        this.topPanel.add((Component)this.sampleAnnotatorPanel, cc.xywh(1, 3, 2, 1, CellConstraints.LEFT, CellConstraints.TOP));
        this.scrollPane = new JScrollPane(this.bottomPanel);
        this.scrollPane.setColumnHeaderView(this.topPanel);
        this.setColumnSize(this.heatMapPanel.getColumnSize());
        this.layoutSampleTable(this.heatMapPanel.getColumnSize());
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.statusLabel, "South");
    }

    public HeatMap getHeatMap() {
        if (this.heatMap == null) {
            this.heatMap = this.buildHeatMap();
        }
        return this.heatMap;
    }

    public JMenuBar createMenuBar(boolean standalone, boolean showFind, boolean showAnnotations, boolean showViewMenu) {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        if (showAnnotations) {
            fileMenu.add(this.setFeatureAnnotator.getOpenFeaturesMenuItem());
            fileMenu.add(this.setSampleAnnotator.getOpenFeaturesMenuItem());
        }
        final JMenuItem saveDataMenu = new JMenuItem("Save Dataset...");
        fileMenu.add(saveDataMenu);
        JMenu saveImageMenu = new JMenu("Save Image");
        final JMenuItem saveJpeg = new JMenuItem("jpeg...");
        final JMenuItem savePng = new JMenuItem("png...");
        final JMenuItem saveSvg = new JMenuItem("svg...");
        saveImageMenu.add(saveJpeg);
        saveImageMenu.add(savePng);
        saveImageMenu.add(saveSvg);
        fileMenu.add(saveImageMenu);
        if (standalone) {
            fileMenu.add(FileMenu.createExitMenuItem());
        }
        JMenu editMenu = new JMenu("Edit");
        JMenu viewMenu = new JMenu("View");
        if (showAnnotations) {
            editMenu.add(this.setFeatureAnnotator.getViewFeatureListsMenuItem());
            editMenu.add(this.setSampleAnnotator.getViewFeatureListsMenuItem());
        }
        final JMenuItem legendMenuItem = new JMenuItem("Legend");
        viewMenu.add(legendMenuItem);
        final JMenuItem profileMenuItem = new JMenuItem("Profile");
        viewMenu.add(profileMenuItem);
        editMenu.add(new JSeparator());
        JMenuItem optionsMenu = new JMenuItem("Display Options...");
        editMenu.add(optionsMenu);
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == saveDataMenu) {
                    HeatMapComponent.this.saveDataset.show();
                } else if (e.getSource() == profileMenuItem) {
                    HeatMapComponent.this.showProfilePlot();
                } else if (e.getSource() == legendMenuItem) {
                    CenteredDialog d = new CenteredDialog(HeatMapComponent.this.parent);
                    d.setTitle("Legend");
                    Component p = HeatMapComponent.this.heatMapPanel.getColorConverter().getLegend();
                    d.getContentPane().add(p);
                    d.pack();
                    ((Dialog)d).setVisible(true);
                } else if (e.getSource() == saveJpeg) {
                    HeatMapComponent.this.showSaveImageDialog("jpeg");
                } else if (e.getSource() == savePng) {
                    HeatMapComponent.this.showSaveImageDialog("png");
                } else if (e.getSource() == saveSvg) {
                    HeatMapComponent.this.showSaveImageDialog("svg");
                } else {
                    HeatMapComponent.this.showOptionsDialog();
                }
            }
        };
        legendMenuItem.addActionListener(l);
        profileMenuItem.addActionListener(l);
        optionsMenu.addActionListener(l);
        saveJpeg.addActionListener(l);
        savePng.addActionListener(l);
        saveSvg.addActionListener(l);
        saveDataMenu.addActionListener(l);
        if (showFind) {
            editMenu.add(new JSeparator());
            editMenu.add(new FindAction(this.parent, this.featureTable, this.data, 0));
        }
        menuBar.add(editMenu);
        if (showViewMenu) {
            menuBar.add(viewMenu);
        }
        return menuBar;
    }

    private AbstractTableModel createRowTableModel() {
        AbstractTableModel rowTableModel = new AbstractTableModel(){

            public Class getColumnClass(int col) {
                return String.class;
            }

            @Override
            public int getColumnCount() {
                int columns = 0;
                if (HeatMapComponent.this.showRowNames) {
                    ++columns;
                }
                if (HeatMapComponent.this.showRowDescriptions) {
                    ++columns;
                }
                return columns;
            }

            @Override
            public String getColumnName(int col) {
                if (HeatMapComponent.this.showRowNames && col == 0) {
                    return HeatMapComponent.this.featureUIString;
                }
                if (HeatMapComponent.this.showRowNames && HeatMapComponent.this.showRowDescriptions && col == 1) {
                    return "Description";
                }
                if (!HeatMapComponent.this.showRowNames && HeatMapComponent.this.showRowDescriptions && col == 0) {
                    return "Description";
                }
                return "";
            }

            @Override
            public int getRowCount() {
                return HeatMapComponent.this.data.getRowCount();
            }

            @Override
            public Object getValueAt(int row, int col) {
                if (HeatMapComponent.this.showRowNames && col == 0) {
                    return HeatMapComponent.this.data.getRowName(row);
                }
                if (HeatMapComponent.this.showRowNames && HeatMapComponent.this.showRowDescriptions && col == 1) {
                    return HeatMapComponent.this.data.getRowMetadata(row, "description");
                }
                if (!HeatMapComponent.this.showRowNames && HeatMapComponent.this.showRowDescriptions && col == 0) {
                    return HeatMapComponent.this.data.getRowMetadata(row, "description");
                }
                int offset = 0;
                if (HeatMapComponent.this.showRowNames) {
                    ++offset;
                }
                if (HeatMapComponent.this.showRowDescriptions) {
                    ++offset;
                }
                return null;
            }
        };
        return rowTableModel;
    }

    private void fireFeatureTableChanged() {
        this.featureTableModel.fireTableChanged(new TableModelEvent(this.featureTableModel, -1));
    }

    public IExpressionData getExpressionData() {
        return this.data;
    }

    public JTable getFeatureTable() {
        return this.featureTable;
    }

    public HeatMapPanel getHeatMapPanel() {
        return this.heatMapPanel;
    }

    public JTable getSampleTable() {
        return this.sampleTable;
    }

    public boolean isShowColumnNames() {
        return this.showColumnNames;
    }

    public boolean isShowRowDescriptions() {
        return this.showRowDescriptions;
    }

    public boolean isShowRowNames() {
        return this.showRowNames;
    }

    private void layoutSampleTable(int columnSize) {
        for (int i = 0; i < this.sampleTable.getColumnCount(); ++i) {
            TableColumn c = this.sampleTable.getColumnModel().getColumn(i);
            c.setMinWidth(columnSize);
            c.setMaxWidth(columnSize);
            c.setPreferredWidth(columnSize);
            c.setWidth(columnSize);
        }
    }

    private void layoutSampleTableColumn(TableColumn c, int columnSize) {
        c.setMinWidth(columnSize);
        c.setMaxWidth(columnSize);
        c.setPreferredWidth(columnSize);
        c.setWidth(columnSize);
    }

    public void setAccessoryComponent(Component c, int column) {
        if (this.accessoryComponent != null) {
            this.topPanel.remove(this.accessoryComponent);
        }
        this.accessoryComponent = c;
        if (this.accessoryComponent != null) {
            CellConstraints cc = new CellConstraints();
            int gridWidth = column == 1 ? 2 : 1;
            CellConstraints.Alignment alignment = column == 1 ? CellConstraints.TOP : CellConstraints.BOTTOM;
            this.topPanel.add(this.accessoryComponent, cc.xywh(column, 1, gridWidth, 1, CellConstraints.LEFT, alignment));
        }
    }

    public void setColorConverter(ColorScheme colorConverter) {
        this.heatMapPanel.setColorConverter(colorConverter);
    }

    public void setColumnSize(int columnSize) {
        this.heatMapPanel.setColumnSize(columnSize);
        this.layoutSampleTable(columnSize);
        this.sampleTable.setFont(new Font("monospaced", 0, columnSize));
        JLabel test = new JLabel();
        test.setFont(new Font("monospaced", 0, columnSize));
        int size = 0;
        for (int j = 0; j < this.data.getColumnCount(); ++j) {
            test.setText(this.data.getColumnName(j));
            size = Math.max(size, test.getPreferredSize().width);
        }
        this.sampleAnnotatorPanel.setColumnSize(columnSize);
        this.sampleTable.setRowHeight(size + 10);
        this.heatMapAndAnnotatorPanel.invalidate();
        this.heatMapAndAnnotatorPanel.validate();
    }

    public void setExpressionData(IExpressionData d) {
        this.data = d;
        this.heatMapPanel.setExpressionData(d);
        this.featureTableModel.fireTableStructureChanged();
        this.sampleTableModel.fireTableStructureChanged();
        this.setColumnSize(this.heatMapPanel.getColumnSize());
        this.plot = new ProfilePlot(this.parent, this.data);
    }

    public void setFeatureUIString(String s) {
        this.featureUIString = s;
    }

    public void setOptionsDialogOptions(boolean allowChangeColumnNameVisibility, boolean allowChangeRowNameVisibility, boolean allowChangeRowDescriptionsVisibility) {
        this.allowChangeColumnNameVisibility = allowChangeColumnNameVisibility;
        this.allowChangeRowNameVisibility = allowChangeRowNameVisibility;
        this.allowChangeRowDescriptionsVisibility = allowChangeRowDescriptionsVisibility;
    }

    public void setRowSize(int rowSize) {
        this.featureAnnotatorPanel.setRowSize(rowSize);
        this.featureTable.setRowHeight(rowSize);
        this.heatMapPanel.setRowSize(rowSize);
        this.featureTable.setFont(new Font("monospaced", 0, rowSize));
    }

    public void setSampleUIString(String s) {
        this.sampleUIString = s;
    }

    public void setShowColorSchemeOptions(boolean b) {
        this.showColorSchemeOptions = b;
    }

    public void setShowColumnNames(boolean showColumnNames) {
        if (this.showColumnNames == showColumnNames) {
            return;
        }
        this.showColumnNames = showColumnNames;
        this.sampleTableModel.fireTableStructureChanged();
    }

    public void setShowFeatureAnnotator(boolean b) {
        this.setFeatureAnnotator.getOpenFeaturesMenuItem().setVisible(b);
        this.setFeatureAnnotator.getViewFeatureListsMenuItem().setVisible(b);
    }

    public void setShowFeatureTableHeader(boolean b) {
        this.featureTable.getTableHeader().setVisible(b);
    }

    public void setShowRowDescriptions(boolean showRowDescriptions) {
        if (this.showRowDescriptions == showRowDescriptions) {
            return;
        }
        this.showRowDescriptions = showRowDescriptions;
        this.fireFeatureTableChanged();
    }

    public void setShowRowNames(boolean showRowNames) {
        if (this.showRowNames == showRowNames) {
            return;
        }
        this.showRowNames = showRowNames;
        this.fireFeatureTableChanged();
    }

    public void setShowSampleAnnotator(boolean b) {
        this.setSampleAnnotator.getOpenFeaturesMenuItem().setVisible(b);
        this.setSampleAnnotator.getViewFeatureListsMenuItem().setVisible(b);
    }

    public void showOptionsDialog() {
        if (this.optionsDialog != null && this.optionsDialog.isShowing()) {
            this.optionsDialog.toFront();
        } else {
            this.optionsDialog = new OptionsDialog(this.parent, this, this.heatMapPanel, this.allowChangeColumnNameVisibility, this.allowChangeRowNameVisibility, this.allowChangeRowDescriptionsVisibility);
        }
    }

    public void showProfilePlot() {
        final int[] indices = this.featureTable.getSelectedRows();
        if (indices.length == 0) {
            UIUtil.showMessageDialog(this.parent, "Please select " + Character.toLowerCase(this.featureUIString.charAt(0)) + this.featureUIString.substring(1, this.featureUIString.length()) + "s to view.");
            return;
        }
        SwingWorker<Object, Void> worker = new SwingWorker<Object, Void>(){

            @Override
            protected Object doInBackground() throws Exception {
                HeatMapComponent.this.plot.plot(indices);
                return null;
            }
        };
        worker.execute();
    }

    public void showSaveImageDialog(final String format) {
        final File f = FileChooser.showSaveDialog(this.parent);
        if (f != null) {
            SwingWorker<Object, Void> worker = new SwingWorker<Object, Void>(){

                @Override
                protected Object doInBackground() throws Exception {
                    HeatMapComponent.this.saveImageToFile(f, format);
                    return null;
                }
            };
            worker.execute();
        }
    }

    private HeatMap buildHeatMap() {
        final Map featureName2Colors = HeatMapComponent.getFeatureName2ColorsMap(this.setFeatureAnnotator.getClassVector(), this.data, true);
        final Map sampleName2Colors = HeatMapComponent.getFeatureName2ColorsMap(this.setSampleAnnotator.getClassVector(), this.data, false);
        DisplaySettings ds = new DisplaySettings();
        ds.columnSize = this.heatMapPanel.getColumnSize();
        ds.rowSize = this.heatMapPanel.getRowSize();
        ds.drawGrid = this.heatMapPanel.isDrawGrid();
        ds.drawRowNames = this.showRowNames;
        ds.drawRowDescriptions = this.showRowDescriptions;
        ds.gridLinesColor = Color.black;
        ds.colorConverter = this.heatMapPanel.getColorConverter();
        ds.upperTriangular = this.heatMapPanel.isUpperTriangular();
        boolean columns = false;
        final ArrayList columnDataList = new ArrayList();
        FeatureAnnotator fa = new FeatureAnnotator(){

            @Override
            public String getAnnotation(String feature, int j) {
                String[] columnData = (String[])columnDataList.get(j);
                return columnData[HeatMapComponent.this.data.getRowIndex(feature)];
            }

            @Override
            public List getColors(String featureName) {
                return (List)featureName2Colors.get(featureName);
            }

            @Override
            public int getColumnCount() {
                return 0;
            }
        };
        SampleAnnotator sa = new SampleAnnotator(){

            @Override
            public List getColors(String sampleName) {
                return (List)sampleName2Colors.get(sampleName);
            }

            @Override
            public String getLabel(int i) {
                return null;
            }

            @Override
            public Color getPhenotypeColor(String sampleName) {
                return null;
            }

            @Override
            public boolean hasPhenotypeColors() {
                return false;
            }
        };
        return HeatMap.createHeatMap(this.data, ds, fa, sa);
    }

    public void saveImageToFile(File f, String format) {
        try {
            HeatMap heatMap = this.getHeatMap();
            ImageUtil.savePlotImage(heatMap, f, format);
        }
        catch (IOException e) {
            UIUtil.showErrorDialog(this.parent, "An error occurred while saving the image '" + f.getName() + "'");
        }
        catch (OutOfMemoryError ome) {
            UIUtil.showErrorDialog(this.parent, "Not enough memory available to save the image.");
        }
    }

    private class SaveDataset {
        final JDialog d;

        SaveDataset() {
            this.d = new CenteredDialog(HeatMapComponent.this.parent);
            this.d.setTitle("Save Dataset");
            JLabel label = new JLabel("Output File:");
            JPanel filePanel = new JPanel();
            FormLayout f = new FormLayout("left:pref:none, 3dlu, left:pref:none, left:pref:none", "pref, 5dlu, pref");
            filePanel.setLayout((LayoutManager)f);
            final JTextField input = new JTextField(30);
            JButton btn = new JButton("Browse...");
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File f = FileChooser.showSaveDialog(HeatMapComponent.this.parent);
                    if (f != null) {
                        try {
                            input.setText(f.getCanonicalPath());
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            });
            CellConstraints cc = new CellConstraints();
            JLabel instructionsLabel = new JLabel("The selected columns and rows will be included in the dataset.");
            filePanel.add((Component)label, cc.xy(1, 1));
            filePanel.add((Component)input, cc.xy(3, 1));
            filePanel.add((Component)btn, cc.xy(4, 1));
            JButton cancelBtn = new JButton("Cancel");
            final JButton importBtn = new JButton("Save");
            JPanel buttonPanel = new JPanel();
            buttonPanel.add(cancelBtn);
            buttonPanel.add(importBtn);
            this.d.getContentPane().add((Component)instructionsLabel, "North");
            this.d.getContentPane().add((Component)filePanel, "Center");
            this.d.getContentPane().add((Component)buttonPanel, "South");
            this.d.pack();
            ActionListener l = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == importBtn) {
                        int[] rows;
                        String outputFileFormat;
                        Object pathname = input.getText().trim();
                        if (((String)pathname).equals("")) {
                            UIUtil.showErrorDialog(HeatMapComponent.this.parent, "Please enter an output file.");
                            return;
                        }
                        String string = outputFileFormat = Util.containsData(HeatMapComponent.this.data, "calls") ? "res" : "gct";
                        if (outputFileFormat.equals("gct") && !((String)pathname).toLowerCase().endsWith(".gct")) {
                            pathname = (String)pathname + ".gct";
                        } else if (outputFileFormat.equals("res") && !((String)pathname).toLowerCase().endsWith(".res")) {
                            pathname = (String)pathname + ".res";
                        }
                        if (!FileChooser.overwriteFile(HeatMapComponent.this.parent, new File((String)pathname))) {
                            return;
                        }
                        int[] columns = HeatMapComponent.this.sampleTable.getSelectedColumns();
                        if (columns.length == 0) {
                            columns = null;
                        }
                        if ((rows = HeatMapComponent.this.featureTable.getSelectedRows()).length == 0) {
                            rows = null;
                        }
                        IExpressionData slicedData = HeatMapComponent.this.data instanceof ExpressionData ? ((ExpressionData)HeatMapComponent.this.data).slice(rows, columns) : IExpressionDataUtil.sliceView(HeatMapComponent.this.data, rows, columns);
                        VisualizerUtil.write(HeatMapComponent.this.parent, slicedData, outputFileFormat, (String)pathname, false);
                        SaveDataset.this.d.dispose();
                    } else {
                        SaveDataset.this.d.dispose();
                    }
                }
            };
            importBtn.addActionListener(l);
            cancelBtn.addActionListener(l);
        }

        void show() {
            this.d.setVisible(true);
        }
    }

    private static class OptionsDialog
    extends CenteredDialog {
        public OptionsDialog(final Frame parent, final HeatMapComponent heatMapComponent, final HeatMapPanel heatMapPanel, boolean showColumnNames, boolean showRowNames, boolean showRowDescriptions) {
            super(parent);
            this.setTitle("Options");
            this.setDefaultCloseOperation(2);
            FormLayout fl = new FormLayout("pref", "");
            CellConstraints cc = new CellConstraints();
            JPanel optionsPanel = new JPanel((LayoutManager)fl);
            fl.appendRow(new RowSpec("pref"));
            JPanel p1 = new JPanel(new FlowLayout(0));
            JLabel colorSchemeMenu = new JLabel("Color Scheme: ");
            p1.add(colorSchemeMenu);
            final JRadioButton rowButton = new JRadioButton("Relative");
            rowButton.setSelected(heatMapPanel.getNormalization() == HeatMapPanel.NORMALIZATION_ROW);
            p1.add(rowButton);
            final JRadioButton globalButton = new JRadioButton("Global");
            globalButton.setSelected(heatMapPanel.getNormalization() == HeatMapPanel.NORMALIZATION_GLOBAL);
            p1.add(globalButton);
            ButtonGroup bg = new ButtonGroup();
            bg.add(rowButton);
            bg.add(globalButton);
            if (heatMapComponent.showColorSchemeOptions) {
                optionsPanel.add((Component)p1, cc.xy(1, fl.getRowCount()));
            }
            fl.appendRow(new RowSpec("pref"));
            JPanel p2 = new JPanel(new FlowLayout(0));
            final JCheckBox showGridCheckBox = new JCheckBox("Show Grid");
            showGridCheckBox.setSelected(heatMapPanel.isDrawGrid());
            p2.add(showGridCheckBox);
            optionsPanel.add((Component)p2, cc.xy(1, fl.getRowCount()));
            fl.appendRow(new RowSpec("pref"));
            JPanel p3b = new JPanel(new FlowLayout(0));
            JLabel gridLabel = new JLabel("Grid Size: ");
            final JSlider gridSizeSlider = new JSlider(2, 30, heatMapPanel.getRowSize());
            p3b.add(gridLabel);
            p3b.add(gridSizeSlider);
            final JTextField gridSizeTextField = new JTextField(String.valueOf(heatMapPanel.getRowSize()) + "  ");
            p3b.add(gridSizeTextField);
            optionsPanel.add((Component)p3b, cc.xy(1, fl.getRowCount()));
            fl.appendRow(new RowSpec("pref"));
            JPanel p3 = new JPanel(new FlowLayout(0));
            JLabel rowSizeLabel = new JLabel("Row Size: ");
            final JTextField rowSizeTextField = new JTextField(10);
            rowSizeTextField.setText(String.valueOf(heatMapPanel.getRowSize()));
            p3.add(rowSizeLabel);
            p3.add(rowSizeTextField);
            fl.appendRow(new RowSpec("pref"));
            JPanel p4 = new JPanel(new FlowLayout(0));
            JLabel columnSizeLabel = new JLabel("Column Size: ");
            final JTextField columnSizeTextField = new JTextField(10);
            columnSizeTextField.setText(String.valueOf(heatMapPanel.getColumnSize()));
            p4.add(columnSizeLabel);
            p4.add(columnSizeTextField);
            final JCheckBox showFeatureDescriptionsCheckBox = new JCheckBox("Show " + heatMapComponent.featureUIString + " Descriptions");
            showFeatureDescriptionsCheckBox.setSelected(heatMapComponent.isShowRowDescriptions());
            if (showRowDescriptions) {
                fl.appendRow(new RowSpec("pref"));
                JPanel p5 = new JPanel(new FlowLayout(0));
                p5.add(showFeatureDescriptionsCheckBox);
                optionsPanel.add((Component)p5, cc.xy(1, fl.getRowCount()));
            }
            final JCheckBox showRowNamesCheckBox = new JCheckBox("Show " + heatMapComponent.featureUIString + " Names");
            showRowNamesCheckBox.setSelected(heatMapComponent.isShowRowNames());
            if (showRowNames) {
                fl.appendRow(new RowSpec("pref"));
                JPanel p6 = new JPanel(new FlowLayout(0));
                p6.add(showRowNamesCheckBox);
                optionsPanel.add((Component)p6, cc.xy(1, fl.getRowCount()));
            }
            final JCheckBox showColumnNamesCheckBox = new JCheckBox("Show " + heatMapComponent.sampleUIString + " Names");
            showColumnNamesCheckBox.setSelected(heatMapComponent.isShowColumnNames());
            if (showColumnNames) {
                fl.appendRow(new RowSpec("pref"));
                JPanel p7 = new JPanel(new FlowLayout(0));
                p7.add(showColumnNamesCheckBox);
                optionsPanel.add((Component)p7, cc.xy(1, fl.getRowCount()));
            }
            fl.appendRow(new RowSpec("pref"));
            JPanel btnPanel = new JPanel();
            ChangeListener cl = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JSlider source = (JSlider)e.getSource();
                    int value = source.getValue();
                    if (value != heatMapPanel.getRowSize()) {
                        heatMapComponent.setRowSize(value);
                    }
                    if (value != heatMapPanel.getColumnSize()) {
                        heatMapComponent.setColumnSize(value);
                    }
                    gridSizeTextField.setText(String.valueOf(value));
                    heatMapComponent.featureTable.invalidate();
                    heatMapComponent.featureTable.validate();
                    heatMapPanel.repaint();
                }
            };
            gridSizeSlider.setMinorTickSpacing(1);
            gridSizeSlider.setPaintTicks(true);
            gridSizeSlider.setPaintLabels(true);
            Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
            labels.put(new Integer(2), new JLabel("2", 0));
            labels.put(new Integer(10), new JLabel("10", 0));
            labels.put(new Integer(20), new JLabel("20", 0));
            labels.put(new Integer(30), new JLabel("30", 0));
            gridSizeSlider.setLabelTable(labels);
            gridSizeSlider.addChangeListener(cl);
            ActionListener l = new ActionListener(){

                /*
                 * Unable to fully structure code
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == gridSizeTextField) {
                        try {
                            value = Integer.parseInt(gridSizeTextField.getText());
                            if (value != heatMapPanel.getRowSize()) {
                                heatMapComponent.setRowSize(value);
                            }
                            if (value != heatMapPanel.getColumnSize()) {
                                heatMapComponent.setColumnSize(value);
                            }
                            gridSizeSlider.setValue(value);
                        }
                        catch (NumberFormatException e1) {
                            UIUtil.showErrorDialog(parent, "Grid size is not a number.");
                            return;
                        }
                    } else if (e.getSource() == rowSizeTextField) {
                        try {
                            rowSize = Integer.parseInt(rowSizeTextField.getText());
                            if (rowSize == heatMapPanel.getRowSize()) ** GOTO lbl50
                            heatMapComponent.setRowSize(rowSize);
                        }
                        catch (NumberFormatException e1) {
                            UIUtil.showErrorDialog(parent, "Row size is not a number.");
                            return;
                        }
                    } else if (e.getSource() == columnSizeTextField) {
                        try {
                            columnSize = Integer.parseInt(columnSizeTextField.getText());
                            if (columnSize == heatMapPanel.getColumnSize()) ** GOTO lbl50
                            heatMapComponent.setColumnSize(columnSize);
                        }
                        catch (NumberFormatException e1) {
                            UIUtil.showErrorDialog(parent, "Column size is not a number.");
                            return;
                        }
                    } else if (e.getSource() == showColumnNamesCheckBox) {
                        showColumnNames = showColumnNamesCheckBox.isSelected();
                        heatMapComponent.setShowColumnNames(showColumnNames);
                    } else if (e.getSource() == showGridCheckBox) {
                        showGrid = showGridCheckBox.isSelected();
                        heatMapPanel.setDrawGrid(showGrid);
                    } else if (e.getSource() == showRowNamesCheckBox) {
                        showRowNames = showRowNamesCheckBox.isSelected();
                        heatMapComponent.setShowRowNames(showRowNames);
                    } else if (e.getSource() == showFeatureDescriptionsCheckBox) {
                        showRowDescriptions = showFeatureDescriptionsCheckBox.isSelected();
                        heatMapComponent.setShowRowDescriptions(showRowDescriptions);
                    } else if (e.getSource() == rowButton || e.getSource() == globalButton) {
                        colorScheme = rowButton.isSelected() != false ? HeatMapPanel.NORMALIZATION_ROW : HeatMapPanel.NORMALIZATION_GLOBAL;
                        heatMapPanel.setNormalization(colorScheme);
                    }
lbl50:
                    // 12 sources

                    HeatMapComponent.access$300(heatMapComponent).invalidate();
                    HeatMapComponent.access$300(heatMapComponent).validate();
                    heatMapPanel.repaint();
                }
            };
            rowSizeTextField.addActionListener(l);
            columnSizeTextField.addActionListener(l);
            showColumnNamesCheckBox.addActionListener(l);
            showGridCheckBox.addActionListener(l);
            showRowNamesCheckBox.addActionListener(l);
            showFeatureDescriptionsCheckBox.addActionListener(l);
            rowButton.addActionListener(l);
            globalButton.addActionListener(l);
            this.getContentPane().add((Component)optionsPanel, "Center");
            this.getContentPane().add((Component)btnPanel, "South");
            this.pack();
            this.setResizable(false);
            this.show();
        }
    }
}

