/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.gsea;

import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.utils.Lm;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentScore;
import edu.mit.broad.genome.parsers.EdbFolderParser;
import edu.mit.broad.genome.reports.EnrichmentReports;
import edu.mit.broad.genome.utils.ZipUtility;
import edu.mit.broad.xbench.core.Widget;
import edu.mit.broad.xbench.tui.TaskManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.genepattern.gsea.LeadingEdgeAnalysis;
import org.genepattern.gsea.ViewAndSearchComponent;
import org.genepattern.gsea.XToolsMessageHandler;
import org.genepattern.uiutil.UIUtil;
import xtools.api.param.ToolParamSet;
import xtools.gsea.LeadingEdgeTool;

public class LeadingEdgeWidget
implements Widget {
    private static final Icon ICON = JarResources.getIcon("Lev16_b.gif");
    private EnrichmentDb edb;
    private JideTabbedPane tabbedPane;
    private static int runs = 0;
    private ViewAndSearchComponent viewAndSearchComponent;
    private JLabel positiveLabel;
    private JLabel negativeLabel;
    private JPanel phenotypePanel;
    private boolean runningInGenePattern;
    private JFileChooser htmlReportDirChooser;
    private static final int GENE_SET_INDEX = 0;
    private static final int SCORE_INDEX = 2;

    public LeadingEdgeWidget(EnrichmentDb edb) {
        if (edb == null) {
            throw new IllegalArgumentException("Param edb cannot be null");
        }
        this.runningInGenePattern = true;
        this.tabbedPane = new JideTabbedPane();
        this.tabbedPane.setHideOneTab(true);
        this.tabbedPane.setTabEditingAllowed(true);
        this.tabbedPane.setShowCloseButtonOnTab(true);
        this.edb = edb;
        this.init(edb);
        this.tabbedPane.addTab("GSEA Results", (Component)this.viewAndSearchComponent);
        this.tabbedPane.setTabClosableAt(0, false);
    }

    public LeadingEdgeWidget(JideTabbedPane tabbedPane, EnrichmentDb edb) {
        if (edb == null) {
            throw new IllegalArgumentException("Param edb cannot be null");
        }
        this.runningInGenePattern = false;
        this.tabbedPane = tabbedPane;
        UIUtil.setMessageHandler(new XToolsMessageHandler());
        this.edb = edb;
        this.init(edb);
        tabbedPane.addTab("GSEA Results", (Component)this.viewAndSearchComponent);
    }

    @Override
    public JMenuBar getJMenuBar() {
        return EMPTY_MENU_BAR;
    }

    @Override
    public JComponent getWrappedComponent() {
        return this.tabbedPane;
    }

    public JComponent getViewAndSearchComponent() {
        return this.viewAndSearchComponent;
    }

    @Override
    public String getAssociatedTitle() {
        return null;
    }

    @Override
    public Icon getAssociatedIcon() {
        return ICON;
    }

    private void init(EnrichmentDb edb) {
        this.positiveLabel = new JLabel(" ");
        this.positiveLabel.setForeground(Color.RED);
        String tcp = "na pos";
        String tcn = "na neg";
        if (edb.getTemplate() != null) {
            tcn = edb.getTemplate().getClassName(0);
            tcn = edb.getTemplate().getClassName(1);
        }
        this.positiveLabel.setText("positive phenotype: " + tcp + "   ");
        this.negativeLabel = new JLabel(" ");
        this.negativeLabel.setForeground(Color.BLUE);
        this.negativeLabel.setText("negative phenotype: " + tcn);
        this.phenotypePanel = new JPanel();
        this.phenotypePanel.add(this.positiveLabel);
        this.phenotypePanel.add(this.negativeLabel);
        ActionListener runListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LeadingEdgeWidget.this.runAnalysis();
            }
        };
        ActionListener reportListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LeadingEdgeWidget.this.buildHtmlReport();
            }
        };
        this.viewAndSearchComponent = new ViewAndSearchComponent("Run leading edge analysis", new int[]{0}, runListener, reportListener, true, this.phenotypePanel);
        this.viewAndSearchComponent.setTableModel(this.createTableModel());
        this.viewAndSearchComponent.getTable().setDefaultRenderer(String.class, (TableCellRenderer)new ESRenderer(0, 2));
    }

    private void buildHtmlReport() {
        File outputDir = this.edb.getEdbDir();
        if (this.runningInGenePattern) {
            if (this.htmlReportDirChooser == null) {
                this.htmlReportDirChooser = new JFileChooser();
                this.htmlReportDirChooser.setDialogTitle("Choose output directory");
                this.htmlReportDirChooser.setFileSelectionMode(1);
            }
            if (this.htmlReportDirChooser.showOpenDialog(this.tabbedPane.getTopLevelAncestor()) != 0) {
                return;
            }
            outputDir = this.htmlReportDirChooser.getSelectedFile();
        }
        final File _outputDir = outputDir;
        this.tabbedPane.setCursor(Cursor.getPredefinedCursor(3));
        try {
            SwingWorker<Object, Void> worker = new SwingWorker<Object, Void>(){

                @Override
                protected Object doInBackground() throws Exception {
                    LeadingEdgeTool tool = new LeadingEdgeTool();
                    ToolParamSet paramSet = (ToolParamSet)tool.getParamSet();
                    if (LeadingEdgeWidget.this.runningInGenePattern) {
                        paramSet.getAnalysisDirParam().setValue(_outputDir);
                    }
                    paramSet.getParam("altDelim").setValue(";");
                    String gsets = StringUtils.join((Object[])LeadingEdgeWidget.this.viewAndSearchComponent.getSelectedColumnArray(0), (String)";");
                    paramSet.getParam("gsets").setValue(gsets);
                    paramSet.getParam("dir").setValue(LeadingEdgeWidget.this.edb.getEdbDir());
                    if (!LeadingEdgeWidget.this.runningInGenePattern) {
                        TaskManager.getInstance().run(tool, paramSet, 1);
                    } else {
                        tool.execute();
                    }
                    return null;
                }
            };
            worker.execute();
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.tabbedPane.setCursor(Cursor.getPredefinedCursor(0));
            UIUtil.showErrorDialog(this.tabbedPane.getTopLevelAncestor(), "An error occurred while building the HTML report");
        }
        this.tabbedPane.setCursor(Cursor.getPredefinedCursor(0));
    }

    private TableModel createTableModel() {
        return new MyTableModel(LeadingEdgeAnalysis.getAllResultsFromEdb(this.edb));
    }

    private void runAnalysis() {
        this.tabbedPane.setCursor(Cursor.getPredefinedCursor(3));
        try {
            SwingWorker<LeadingEdgeAnalysis, Void> worker = new SwingWorker<LeadingEdgeAnalysis, Void>(){

                @Override
                protected LeadingEdgeAnalysis doInBackground() throws Exception {
                    runs++;
                    try {
                        return LeadingEdgeAnalysis.runAnalysis(LeadingEdgeWidget.this.edb, LeadingEdgeWidget.this.viewAndSearchComponent.getSelectedColumnArray(0), (Frame)LeadingEdgeWidget.this.tabbedPane.getTopLevelAncestor());
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        LeadingEdgeWidget.this.tabbedPane.setCursor(Cursor.getPredefinedCursor(0));
                        UIUtil.showErrorDialog(LeadingEdgeWidget.this.tabbedPane.getTopLevelAncestor(), "An error occurred while running leading edge analysis");
                        return null;
                    }
                }

                @Override
                protected void done() {
                    try {
                        LeadingEdgeAnalysis analysis = (LeadingEdgeAnalysis)this.get();
                        if (analysis == null) {
                            return;
                        }
                        LeadingEdgeWidget.this.tabbedPane.addTab("Leading Edge Analysis-" + runs, analysis.getComponent());
                        LeadingEdgeWidget.this.tabbedPane.setSelectedComponent(analysis.getComponent());
                        LeadingEdgeWidget.this.tabbedPane.setCursor(Cursor.getPredefinedCursor(0));
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        LeadingEdgeWidget.this.tabbedPane.setCursor(Cursor.getPredefinedCursor(0));
                        UIUtil.showErrorDialog(LeadingEdgeWidget.this.tabbedPane.getTopLevelAncestor(), "An error occurred while running leading edge analysis");
                    }
                }
            };
            worker.execute();
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.tabbedPane.setCursor(Cursor.getPredefinedCursor(0));
            UIUtil.showErrorDialog(this.tabbedPane.getTopLevelAncestor(), "An error occurred while running leading edge analysis");
        }
    }

    public static void main(String[] args) {
        Lm.verifyLicense((String)"Broad Institute of MIT and Harvard", (String)"Gene set  enrichment analysis java desktop application", (String)"YSjBO6OJfF9WbavzI73Jt1HgDI4x9L21");
        if (!SystemUtils.IS_OS_MAC_OSX) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (args.length != 1) {
            UIUtil.showMessageDialog(null, "org.genepattern.gsea.LeadingEdgeWidget.main expecting single command line argument");
            System.exit(0);
        }
        String zipFile = args[0];
        File dir = null;
        try {
            dir = File.createTempFile("gsea", null);
        }
        catch (IOException e) {
            e.printStackTrace();
            UIUtil.showMessageDialog(null, "An error occurred while reading the input zip file");
            System.exit(0);
        }
        dir.delete();
        dir.mkdir();
        final File f = dir;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    FileUtils.deleteDirectory((File)f);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    UIUtil.showMessageDialog(null, "unable to delete directory containing unpacked GSEA zip file");
                }
            }
        });
        ZipUtility zipUtil = new ZipUtility();
        try {
            zipUtil.unzip(new File(zipFile), dir);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            UIUtil.showMessageDialog(null, "An error occurred while unzipping directory archive");
            System.exit(0);
        }
        String title = "Leading Edge Viewer - " + new File(zipFile).getName();
        EnrichmentDb edb = null;
        try {
            EdbFolderParser folderParser = new EdbFolderParser();
            folderParser.setSilentMode(true);
            edb = (EnrichmentDb)folderParser.parse(dir.getCanonicalPath(), (InputStream)null).get(0);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            UIUtil.showMessageDialog(null, "An error occurred while reading the input file");
            System.exit(0);
        }
        JFrame frame = new JFrame();
        frame.setTitle(title);
        frame.setDefaultCloseOperation(3);
        LeadingEdgeWidget widget = new LeadingEdgeWidget(edb);
        frame.getContentPane().add((Component)widget.tabbedPane);
        UIUtil.sizeToScreen(frame);
        frame.setVisible(true);
    }

    static {
        System.setProperty("org.genepattern.menu.showAccelerators", "false");
    }

    private class ESRenderer
    extends DefaultTableCellRenderer {
        private int nameColumnIndex;
        private int scoreColumnIndex;

        public ESRenderer(int nameColumnIndex, int scoreColumnIndex) {
            this.nameColumnIndex = nameColumnIndex;
            this.scoreColumnIndex = scoreColumnIndex;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            row = LeadingEdgeWidget.this.viewAndSearchComponent.getTable().getActualRowAt(row);
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            if (col == this.nameColumnIndex) {
                float es = ((Float)table.getValueAt(row, this.scoreColumnIndex)).floatValue();
                if (XMath.isPositive(es)) {
                    this.setForeground(Color.RED);
                } else {
                    this.setForeground(Color.BLUE);
                }
                this.setText(value.toString());
            } else {
                this.setForeground(Color.BLACK);
            }
            return this;
        }
    }

    private static class MyTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"Gene Set", "Size", "ES", "NES", "NOM p-val", "FDR q-val", "FWER p-val", "Rank at Max", "Leading Edge"};
        private Class[] columnClasses = new Class[]{String.class, Integer.class, Float.class, Float.class, Float.class, Float.class, Float.class, Integer.class, String.class};
        private EnrichmentResult[] enrichmentResults;

        public MyTableModel(EnrichmentResult[] enrichmentResults) {
            this.enrichmentResults = enrichmentResults;
        }

        @Override
        public int getRowCount() {
            return this.enrichmentResults.length;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        public Class getColumnClass(int j) {
            return this.columnClasses[j];
        }

        @Override
        public String getColumnName(int j) {
            return this.columnNames[j];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            GeneSet gset = this.enrichmentResults[rowIndex].getGeneSet();
            EnrichmentScore score = this.enrichmentResults[rowIndex].getScore();
            switch (columnIndex) {
                case 0: {
                    return gset.getName(true);
                }
                case 1: {
                    return new Integer(gset.getNumMembers());
                }
                case 2: {
                    return new Float(score.getES());
                }
                case 3: {
                    return new Float(score.getNES());
                }
                case 4: {
                    return new Float(score.getNP());
                }
                case 5: {
                    return new Float(score.getFDR());
                }
                case 6: {
                    return new Float(score.getFWER());
                }
                case 7: {
                    return new Integer(this.enrichmentResults[rowIndex].getSignal().getRankAtMax());
                }
                case 8: {
                    return EnrichmentReports.getLeadingEdge(this.enrichmentResults[rowIndex]);
                }
            }
            return null;
        }
    }
}

