/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.tui;

import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.xbench.actions.ext.BrowserAction;
import edu.mit.broad.xbench.core.ApplicationDialog;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.tui.ReportStub;
import edu.mit.broad.xbench.tui.SingleToolLauncherAction;
import edu.mit.broad.xbench.tui.TaskManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.SwingWorker;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import xtools.api.Tool;
import xtools.api.param.ParamSet;

public class ToolRunnerControl
extends JPanel {
    private static final Logger klog = Logger.getLogger(ToolRunnerControl.class);
    private JButton bRun;
    private JButton bResetDefaults;
    private JButton bCmd;
    private JButton bHelp;
    private JButton bLastRunParams;
    private DisplayHook fHook;
    private JComponent fCompOpt;
    private ToolRunnerControl fInstance = this;

    public ToolRunnerControl(DisplayHook hook) {
        this(hook, null);
    }

    public ToolRunnerControl(DisplayHook hook, JComponent compOpt) {
        if (hook == null) {
            throw new IllegalArgumentException("Param hook cannot be null");
        }
        this.fHook = hook;
        this.fCompOpt = compOpt;
        this.init();
    }

    private void init() {
        JPanel rhsPanel;
        String run_str = "";
        String cmd_str = "";
        String reset_str = "";
        String last_str = "";
        Dimension dim = new Dimension(25, 25);
        Dimension cdim = new Dimension(25, 25);
        if (this.fCompOpt == null) {
            run_str = "Run";
            cmd_str = "Command";
            last_str = "Last";
            reset_str = "Reset";
            dim = new Dimension(75, 25);
            cdim = new Dimension(100, 25);
        }
        Dimension hdim = new Dimension(100, 25);
        this.bResetDefaults = new JButton(reset_str, JarResources.getIcon("Reset16.gif"));
        this.bResetDefaults.setEnabled(false);
        this.bResetDefaults.setToolTipText("Reset to default parameters");
        this.bResetDefaults.setPreferredSize(dim);
        this.bResetDefaults.setSize(dim);
        this.bLastRunParams = new JButton(last_str, JarResources.getIcon("History16_v2.gif"));
        this.bLastRunParams.setEnabled(true);
        this.bLastRunParams.setToolTipText("Set to the previous run");
        this.bLastRunParams.setPreferredSize(dim);
        this.bLastRunParams.setSize(dim);
        this.bRun = GuiHelper.Button.createStartButton(run_str);
        this.bRun.setEnabled(false);
        this.bRun.setToolTipText("Execute the tool with specified parameters");
        this.bRun.setPreferredSize(dim);
        this.bRun.setSize(dim);
        this.bCmd = new JButton(cmd_str, JarResources.getIcon("CommandLine16_v2.gif"));
        this.bCmd.setEnabled(false);
        this.bCmd.setToolTipText("Commandline representation (for running from a unix terminal, dos window etc)");
        this.bCmd.setPreferredSize(cdim);
        this.bCmd.setSize(cdim);
        this.bHelp = new JButton("", JarResources.getIcon("Help16_v2.gif"));
        this.bHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                klog.debug((Object)("launching help for: " + ToolRunnerControl.this.fHook.getCurrentTool()));
                if (ToolRunnerControl.this.fHook.getCurrentTool() != null) {
                    String url = ToolRunnerControl.this.fHook.getCurrentTool().getHelpURL();
                    BrowserAction ba = new BrowserAction("Help", "Online documentation for this tool", GuiHelper.ICON_HELP16, url);
                    ba.actionPerformed(evt);
                }
            }
        });
        this.bHelp.setEnabled(true);
        this.bHelp.setToolTipText("Online HELP!! for this tool");
        this.bHelp.setPreferredSize(hdim);
        this.bHelp.setSize(dim);
        this.bRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SwingWorker<Object, Void> worker = new SwingWorker<Object, Void>(){

                        @Override
                        protected Object doInBackground() throws Exception {
                            Tool tool = ToolRunnerControl.this.fHook.getCurrentTool();
                            ParamSet pset = ToolRunnerControl.this.fHook.getCurrentParamSet();
                            if (ToolRunnerControl.this.fHook.isRecordToolRun()) {
                                try {
                                    Application.getToolManager().setLastToolName(tool);
                                }
                                catch (Throwable t) {
                                    klog.warn((Object)"Unable to save last tool info", t);
                                }
                            }
                            if (tool != null) {
                                TaskManager.getInstance().run(tool, pset, 5);
                            }
                            return null;
                        }
                    };
                    worker.execute();
                }
                catch (Throwable t) {
                    Application.getWindowManager().showError(t);
                }
            }
        });
        this.bResetDefaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringBuffer msg = new StringBuffer("Confirm reset parameters to defaults");
                boolean res = Application.getWindowManager().showConfirm("Confirm reset", msg.toString());
                if (res) {
                    ToolRunnerControl.this.fHook.resetParamSet();
                }
            }
        });
        this.bLastRunParams.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingWorker<Object, Void> worker = new SwingWorker<Object, Void>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        ReportStub rs = Application.getToolManager().getLastReportStub(ToolRunnerControl.this.fHook.getCurrentTool().getClass().getName());
                        if (rs == null) {
                            Application.getWindowManager().showMessage("No history available for: " + ToolRunnerControl.this.fHook.getCurrentTool().getClass().getName());
                            return null;
                        }
                        boolean proc = Application.getWindowManager().showConfirm("Load data files from the last analysis: " + rs.getName());
                        if (!proc) {
                            return null;
                        }
                        try {
                            Properties source_params = rs.getReport(true).getParametersUsed();
                            Tool tool = TaskManager.createTool(ToolRunnerControl.this.fHook.getCurrentTool().getClass().getName());
                            Runnable runnable = ToolRunnerControl.createLoadToolTask(tool, rs.getName(), true, source_params, ToolRunnerControl.this.fInstance, false);
                            runnable.run();
                            Application.getWindowManager().showMessage("Data from the last run of this tool was automagically loaded in. They are now available as parameter options");
                        }
                        catch (Throwable t) {
                            Application.getWindowManager().showError(t);
                        }
                        return null;
                    }
                };
                worker.execute();
            }
        });
        this.bCmd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton bCopy = new JButton("Copy", GuiHelper.ICON_COPY16);
                String launcherCmd = SystemUtils.IS_OS_WINDOWS ? "gsea-cli.bat" : "gsea-cli.sh";
                StringBuffer buf = new StringBuffer(launcherCmd).append(" ").append(ToolRunnerControl.this.fHook.getCurrentTool().getName()).append(' ');
                buf.append(ToolRunnerControl.this.fHook.getCurrentParamSet().getAsCommand(true).trim());
                final JTextArea ta = new JTextArea(buf.toString(), 5, 50);
                bCopy.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        StringSelection stsel = new StringSelection(ta.getText());
                        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
                        clip.setContents(stsel, stsel);
                    }
                });
                ApplicationDialog dd = new ApplicationDialog("Command Line for: " + ToolRunnerControl.this.fHook.getCurrentTool().getClass().getName(), new JScrollPane(ta));
                dd.setButtons(new JButton[]{bCopy});
                dd.show();
            }
        });
        this.setLayout(new BorderLayout());
        JPanel lhsPanel = new JPanel(new FlowLayout(0));
        lhsPanel.add((Component)this.bHelp, "West");
        this.add((Component)lhsPanel, "West");
        this.set(lhsPanel);
        this.set(this.bCmd);
        this.set(this.bHelp);
        this.set(this.bLastRunParams);
        this.set(this.bResetDefaults);
        this.set(this.bRun);
        if (this.fCompOpt == null) {
            rhsPanel = new JPanel(new FlowLayout(0));
            rhsPanel.add(this.bResetDefaults);
            rhsPanel.add(this.bLastRunParams);
            rhsPanel.add(this.bCmd);
            rhsPanel.add(this.bRun);
        } else {
            rhsPanel = new JPanel(new FlowLayout());
            rhsPanel.add(this.fCompOpt);
            rhsPanel.add(this.bResetDefaults);
            rhsPanel.add(this.bLastRunParams);
            rhsPanel.add(this.bRun);
            rhsPanel.add(this.bCmd);
        }
        this.set(rhsPanel);
        JScrollPane sp = new JScrollPane(rhsPanel, 21, 30);
        sp.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)sp, "Center");
    }

    private void set(JComponent comp) {
        comp.setBackground(GuiHelper.COLOR_VERY_LIGHT_GRAY);
        if (comp instanceof JPanel) {
            comp.setBorder(BorderFactory.createEmptyBorder());
        }
        if (comp instanceof JButton) {
            GuiHelper.Button.addMouseOverRollOverAction((JButton)comp);
        }
    }

    public void setEnabledControls(boolean enabled) {
        this.bRun.setEnabled(enabled);
        this.bCmd.setEnabled(enabled);
        this.bResetDefaults.setEnabled(true);
    }

    public static Runnable createLoadToolTask(final Tool fill_this_tool, final String rptName, final boolean loadFiles, final Properties source_params, final Component parentComponent, final boolean launchANewToolWindow) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    ParamSet.FoundMissingFile fmf = fill_this_tool.getParamSet().fileCheckingFill(source_params);
                    if (fmf.missingFiles.length == 0 || !ToolRunnerControl.showMissingDialog(fmf.missingFiles)) {
                        // empty if block
                    }
                    StringBuffer errs = new StringBuffer("<html><body>There were parsing errors<pre>");
                    boolean atleastoneerr = false;
                    if (loadFiles) {
                        for (int i = 0; i < fmf.foundFiles.length; ++i) {
                            try {
                                if (!fmf.foundFiles[i].isFile()) continue;
                                String path = fmf.foundFiles[i].getPath();
                                klog.debug((Object)("Trying to parse: " + path + " for param: " + fmf.foundFilesParamNames[i]));
                                ProgressMonitorInputStream pis = new ProgressMonitorInputStream(parentComponent, "Loading: " + path, new FileInputStream(fmf.foundFiles[i]));
                                ParserFactory.read(path, pis);
                                continue;
                            }
                            catch (Throwable t) {
                                klog.debug((Object)("Parsing error for file from param: " + fmf.foundFilesParamNames[i] + " file >" + fmf.foundFiles[i].getPath()), t);
                                atleastoneerr = true;
                                errs.append(t.getMessage()).append("<br>");
                            }
                        }
                        errs.append("</pre></body></html>");
                    }
                    if (atleastoneerr) {
                        Application.getWindowManager().showMessage(errs.toString());
                    }
                    if (launchANewToolWindow) {
                        SingleToolLauncherAction a = new SingleToolLauncherAction(fill_this_tool, fill_this_tool.getParamSet(), rptName);
                        a.createTask();
                        Application.getWindowManager().showMessage("Created a new ToolRunner with parameters from the earlier run. Data files (when found) were automagically imported");
                    }
                }
                catch (Throwable t) {
                    Application.getWindowManager().showError(t);
                }
            }
        };
    }

    private static boolean showMissingDialog(File[] files) {
        StringBuffer buf = new StringBuffer("<html><body>The following file(s) were not found on the local file system<br>");
        buf.append("<pre>");
        for (int i = 0; i < files.length; ++i) {
            buf.append(files[i]).append("<br>");
        }
        buf.append("</pre></body></html>");
        return Application.getWindowManager().showConfirm("Some Files Missing", buf.toString());
    }

    public static interface DisplayHook {
        public Tool getCurrentTool();

        public ParamSet getCurrentParamSet();

        public void resetParamSet();

        public boolean isRecordToolRun();
    }
}

