/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.meg;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.vdb.meg.Gene;

public class DefaultGene
implements Gene {
    private String fSymbol;
    private String fTitle;

    public DefaultGene() {
    }

    public DefaultGene(String symbol, String title) {
        if (symbol == null) {
            throw new IllegalArgumentException("Parameter symbol cannot be null");
        }
        this.fTitle = NamingConventions.titleize(title);
        this.fSymbol = symbol;
    }

    @Override
    public String getSymbol() {
        return this.fSymbol;
    }

    @Override
    public String getTitle() {
        return this.fTitle;
    }

    @Override
    public String getTitle_truncated() {
        return Gene.Helper.getTitle_truncated(this.fTitle);
    }

    public boolean equals(Object obj) {
        return obj instanceof Gene && ((Gene)obj).getSymbol().equalsIgnoreCase(this.getSymbol());
    }

    public String toString() {
        return this.getSymbol();
    }

    public int hashCode() {
        return this.getSymbol().hashCode();
    }
}

