/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.chip.Probe;
import edu.mit.broad.vdb.meg.Gene;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class ChipParser
extends AbstractParser {
    private static final String PROBE_SET_ID = "Probe Set ID";
    private static final String GENE_TITLE = "Gene Title";
    private static final String GENE_SYMBOL = "Gene Symbol";

    public ChipParser() {
        super(Chip.class);
    }

    @Override
    public void export(PersistentObject pob, File file) throws Exception {
        this.export((Chip)pob, file, true);
    }

    public void export(Chip chip, File file, boolean withTitles) throws Exception {
        String[] colNames = withTitles ? new String[]{PROBE_SET_ID, GENE_SYMBOL, GENE_TITLE} : new String[]{PROBE_SET_ID, GENE_SYMBOL};
        PrintWriter pw = new PrintWriter(new FileOutputStream(file));
        for (int i = 0; i < colNames.length; ++i) {
            pw.print(colNames[i]);
            if (i == colNames.length) continue;
            pw.print('\t');
        }
        pw.println();
        for (int r = 0; r < chip.getNumProbes(); ++r) {
            Probe probe = chip.getProbe(r);
            pw.print(probe.getName());
            pw.print('\t');
            Gene gene = probe.getGene();
            String symbol = null;
            String title = null;
            if (gene != null) {
                symbol = gene.getSymbol();
                title = gene.getTitle();
            }
            if (symbol == null) {
                symbol = "NULL";
            }
            if (title == null) {
                title = "NULL";
            }
            pw.print(symbol);
            if (withTitles) {
                pw.print('\t');
                pw.print(title);
            }
            pw.println();
        }
        pw.close();
        this.doneExport();
    }

    @Override
    public List parse(String sourcepath, InputStream is) throws Exception {
        if (sourcepath.endsWith("chip")) {
            return this._parse_from_dot_chip(sourcepath, is);
        }
        throw new IllegalArgumentException("Unknown chip file type for parsing: " + sourcepath);
    }

    private List _parse_from_dot_chip(String sourcepath, InputStream is) throws Exception {
        this.startImport(sourcepath);
        BufferedReader bin = new BufferedReader(new InputStreamReader(is));
        String currLine = this.nextLine(bin);
        List<String> colHeaders = ParseUtils.string2stringsList(currLine, "\t");
        int ps_index = ChipParser.indexOf(PROBE_SET_ID, colHeaders, true);
        int symbol_index = ChipParser.indexOf(GENE_SYMBOL, colHeaders, true);
        int title_index = ChipParser.indexOf(GENE_TITLE, colHeaders, true);
        ArrayList<Probe> probesList = new ArrayList<Probe>();
        currLine = this.nextLine(bin);
        HashSet<String> names = new HashSet<String>();
        while (currLine != null) {
            String[] fields = ParseUtils.string2strings(currLine, "\t", true);
            String probeName = fields[ps_index];
            if (probeName != null && !names.contains(probeName)) {
                String symbol = fields[symbol_index];
                symbol = NamingConventions.symbolize(symbol);
                String title = null;
                try {
                    title = fields[title_index];
                    if (title != null && title.equals("---")) {
                        title = null;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Probe probe = new Probe(probeName, symbol, title);
                probesList.add(probe);
            }
            if (probeName != null) {
                names.add(probeName);
            }
            currLine = this.nextLine(bin);
        }
        Probe[] probes = probesList.toArray(new Probe[probesList.size()]);
        Chip chip = new Chip(FilenameUtils.getName((String)sourcepath), sourcepath, probes);
        bin.close();
        this.log.info((Object)("Parsed from dotchip : " + probes.length));
        this.doneImport();
        return ChipParser.unmodlist(chip);
    }
}

