/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects.esmatrix.db;

import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetSignal;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentScore;
import edu.mit.broad.genome.objects.esmatrix.db.GeneSetSignalImpl;
import edu.mit.broad.genome.objects.strucs.FdrStruc;
import edu.mit.broad.vdb.chip.Chip;

public class EnrichmentResultImpl
implements EnrichmentResult {
    private EnrichmentScore fScore;
    private Vector fRndESS;
    private RankedList fRankedList;
    private Template fTemplate_opt;
    private GeneSet fGeneSet;
    private Chip fChip;
    private FdrStruc fFdr;
    private GeneSetSignal fSignal;

    public EnrichmentResultImpl(RankedList rl, Template t_opt, GeneSet gset, Chip chip, EnrichmentScore es, Vector rndEss) {
        this.init(rl, t_opt, gset, chip, es, rndEss, null);
    }

    public EnrichmentResultImpl(RankedList rl, Template t_opt, GeneSet gset, Chip chip, EnrichmentScore es, Vector rndEss, FdrStruc fdr_opt) {
        this.init(rl, t_opt, gset, chip, es, rndEss, fdr_opt);
    }

    private void init(RankedList rl, Template t_opt, GeneSet gset, Chip chip, EnrichmentScore es, Vector rndEss, FdrStruc fdr) {
        if (es == null) {
            throw new IllegalArgumentException("Param esStruc cannot be null");
        }
        if (gset == null) {
            throw new IllegalArgumentException("Param gset cannot be null");
        }
        this.fTemplate_opt = t_opt;
        this.fRankedList = rl;
        this.fGeneSet = gset;
        this.fChip = chip;
        this.fScore = es;
        this.fRndESS = rndEss;
        this.fGeneSet = gset;
        this.fFdr = fdr;
    }

    @Override
    public GeneSetSignal getSignal() {
        if (this.fSignal == null) {
            this.fSignal = new GeneSetSignalImpl(this);
        }
        return this.fSignal;
    }

    @Override
    public Vector getRndESS() {
        return this.fRndESS;
    }

    @Override
    public FdrStruc getFDR() {
        return this.fFdr;
    }

    @Override
    public EnrichmentScore getScore() {
        return this.fScore;
    }

    @Override
    public RankedList getRankedList() {
        return this.fRankedList;
    }

    @Override
    public Template getTemplate() {
        return this.fTemplate_opt;
    }

    @Override
    public GeneSet getGeneSet() {
        return this.fGeneSet;
    }

    @Override
    public String getGeneSetName() {
        return this.fGeneSet.getName(true);
    }

    @Override
    public Chip getChip() {
        return this.fChip;
    }

    @Override
    public int getNumPerms() {
        return this.fRndESS.getSize();
    }
}

