/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects.esmatrix.db;

import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.alg.gsea.EdbAlgs;
import edu.mit.broad.genome.math.LabelledVectorProcessor;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import edu.mit.broad.genome.objects.strucs.FdrStruc;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public abstract class AbstractEnrichmentDb
extends AbstractObject
implements EnrichmentDb {
    private LabelledVectorProcessor fLvp;
    private Metric fMetric;
    private Map fMetricParams;
    private SortMode fSortMode;
    private Order fOrder;
    private int fNumPerms;
    private File fEdbDir_opt;
    private Map fGeneSetNameResultMap;
    private FdrStruc[] fFdrPos;
    private FdrStruc[] fFdrNeg;

    protected AbstractEnrichmentDb() {
    }

    public void init(String name, LabelledVectorProcessor lvp, Metric metric, Map metricParams, SortMode sort, Order order, int nperm, File edb_dir_opt) {
        if (lvp == null) {
            throw new IllegalArgumentException("Param lvp cannot be null");
        }
        if (metric == null) {
            throw new IllegalArgumentException("Param metric cannot be null");
        }
        if (sort == null) {
            throw new IllegalArgumentException("Param sort cannot be null");
        }
        if (order == null) {
            throw new IllegalArgumentException("Param order cannot be null");
        }
        super.initialize(name);
        this.fLvp = lvp;
        this.fMetric = metric;
        this.fMetricParams = metricParams;
        this.fSortMode = sort;
        this.fOrder = order;
        this.fNumPerms = nperm;
        this.fEdbDir_opt = edb_dir_opt;
        this.initResultMaps();
    }

    @Override
    public File getEdbDir() {
        return this.fEdbDir_opt;
    }

    protected void initResultMaps() {
        if (this.fGeneSetNameResultMap == null) {
            this.fGeneSetNameResultMap = EdbAlgs.hashByGeneSetName(this.getResults());
        }
    }

    @Override
    public int getNumScores(boolean pos) {
        int cnt = 0;
        for (int i = 0; i < this.getNumResults(); ++i) {
            if (pos) {
                if (!XMath.isPositive(this.getResult(i).getScore().getES())) continue;
                ++cnt;
                continue;
            }
            if (!XMath.isNegative(this.getResult(i).getScore().getES())) continue;
            ++cnt;
        }
        return cnt;
    }

    @Override
    public int getNumNominallySig(float npCutoffInclusive, boolean pos) {
        int cnt = 0;
        for (int i = 0; i < this.getNumResults(); ++i) {
            EnrichmentResult res = this.getResult(i);
            if (res.getScore().getES() > 0.0f && pos && res.getScore().getNP() <= npCutoffInclusive) {
                ++cnt;
            }
            if (!(res.getScore().getES() < 0.0f) || pos || !(res.getScore().getNP() <= npCutoffInclusive)) continue;
            ++cnt;
        }
        return cnt;
    }

    @Override
    public int getNumFDRSig(float fdrCutoffInclusive, boolean pos) {
        return this.getFDRSig(fdrCutoffInclusive, pos).length;
    }

    public FdrStruc[] getFDRSig(float fdrCutoffInclusive, boolean pos) {
        FdrStruc[] fdrs = this.getFDR(pos);
        ArrayList<FdrStruc> list = new ArrayList<FdrStruc>();
        for (int i = 0; i < fdrs.length; ++i) {
            if (!(fdrs[i].getFdr() <= fdrCutoffInclusive)) continue;
            list.add(fdrs[i]);
        }
        return list.toArray(new FdrStruc[list.size()]);
    }

    private void initFDR() {
        if (this.fFdrPos != null) {
            return;
        }
        ArrayList<FdrStruc> pos = new ArrayList<FdrStruc>();
        ArrayList<FdrStruc> neg = new ArrayList<FdrStruc>();
        for (int i = 0; i < this.getNumResults(); ++i) {
            FdrStruc fdr = this.getResult(i).getFDR();
            if (fdr == null) continue;
            if (XMath.isPositive(fdr.getRealScore())) {
                pos.add(fdr);
                continue;
            }
            neg.add(fdr);
        }
        this.fFdrPos = pos.toArray(new FdrStruc[pos.size()]);
        this.fFdrNeg = neg.toArray(new FdrStruc[neg.size()]);
    }

    public FdrStruc[] getFDR(boolean pos) {
        this.initFDR();
        if (pos && this.fFdrPos == null) {
            throw new IllegalStateException("Fdrs not yet calculated: " + pos);
        }
        if (!pos && this.fFdrNeg == null) {
            throw new IllegalStateException("Fdrs not yet calculated: " + pos);
        }
        if (pos) {
            return this.fFdrPos;
        }
        return this.fFdrNeg;
    }

    @Override
    public EnrichmentResult getResultForGeneSet(String gsetName_no_aux) {
        Object obj = this.fGeneSetNameResultMap.get(gsetName_no_aux);
        if (obj == null) {
            throw new IllegalArgumentException("No such gset result: " + gsetName_no_aux);
        }
        return (EnrichmentResult)obj;
    }

    @Override
    public String getQuickInfo() {
        return null;
    }

    @Override
    public GeneSet[] getGeneSets() {
        return EdbAlgs.getGeneSets(this.getResults());
    }

    public List getGeneSetNames() {
        return EdbAlgs.getGeneSetNames(this.getResults());
    }

    public String[] getGeneSetNamesArray() {
        List list = this.getGeneSetNames();
        return list.toArray(new String[list.size()]);
    }

    @Override
    public EnrichmentResult[] getResults(Comparator comp) {
        List list = this.getResultsList(comp);
        return list.toArray(new EnrichmentResult[list.size()]);
    }

    @Override
    public EnrichmentResult getResult(int i) {
        return this.getResults()[i];
    }

    public List getResultsList(Comparator comp) {
        List list = this.getResultsList();
        Collections.sort(list, comp);
        return list;
    }

    @Override
    public EnrichmentResult[] getResults(Comparator comp, boolean pos) {
        EnrichmentResult[] all = this.getResults(comp);
        ArrayList<EnrichmentResult> sub = new ArrayList<EnrichmentResult>();
        for (int i = 0; i < all.length; ++i) {
            float es = all[i].getScore().getES();
            if (pos && XMath.isPositive(es)) {
                sub.add(all[i]);
            }
            if (pos || !XMath.isNegative(es)) continue;
            sub.add(all[i]);
        }
        return sub.toArray(new EnrichmentResult[sub.size()]);
    }

    @Override
    public int getNumResults() {
        return this.getResults().length;
    }

    @Override
    public LabelledVectorProcessor getRankedListProcessor() {
        return this.fLvp;
    }

    @Override
    public Metric getMetric() {
        return this.fMetric;
    }

    @Override
    public Map getMetricParams() {
        return this.fMetricParams;
    }

    @Override
    public SortMode getSortMode() {
        return this.fSortMode;
    }

    @Override
    public Order getOrder() {
        return this.fOrder;
    }

    @Override
    public int getNumPerm() {
        return this.fNumPerms;
    }

    public Vector getESS() {
        Vector ess = new Vector(this.getNumResults());
        for (int i = 0; i < this.getNumResults(); ++i) {
            ess.setElement(i, this.getResult(i).getScore().getES());
        }
        return ess;
    }

    @Override
    public LabelledVector getESS_lv() {
        return new LabelledVector(this.getName() + "_ess", this.getGeneSetNamesArray(), this.getESS());
    }

    @Override
    public Vector getNESS() {
        Vector ness = new Vector(this.getNumResults());
        for (int i = 0; i < this.getNumResults(); ++i) {
            ness.setElement(i, this.getResult(i).getScore().getNES());
        }
        return ness;
    }

    @Override
    public Vector getNPs() {
        Vector ess = new Vector(this.getNumResults());
        for (int i = 0; i < this.getNumResults(); ++i) {
            ess.setElement(i, this.getResult(i).getScore().getNP());
        }
        return ess;
    }

    @Override
    public Vector getFDRs() {
        Vector fdsr = new Vector(this.getNumResults());
        for (int i = 0; i < this.getNumResults(); ++i) {
            fdsr.setElement(i, this.getResult(i).getScore().getFDR());
        }
        return fdsr;
    }
}

