/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.alg.ComparatorFactory;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.ScoredDataset;
import edu.mit.broad.genome.parsers.AuxUtils;
import edu.mit.broad.vdb.chip.Probe;
import edu.mit.broad.vdb.meg.Gene;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GeneSet
extends AbstractObject
implements PersistentObject {
    private List<String> fMembers;
    private Set<String> fMembersSet;

    private GeneSet() {
    }

    public GeneSet(String name, String nameEnglish, String[] members) {
        this.init(name, nameEnglish, members, true);
    }

    public GeneSet(String name, String nameEnglish, List members, boolean checkForDuplicates) {
        this.init(name, nameEnglish, members, checkForDuplicates);
    }

    public GeneSet(String name, String[] members) {
        this.init(name, null, members, true);
    }

    public GeneSet(String name, Set members) {
        this.init(name, null, members, false);
    }

    public GeneSet(GeneSet gset, ScoredDataset sds) {
        ArrayList<String> members = new ArrayList<String>(gset.getMembers());
        Collections.sort(members, new ComparatorFactory.ScoredDatasetScoreComparator(sds));
        this.init(gset.getName() + ".orderedby." + sds.getName(), gset.getNameEnglish(), members, false);
    }

    private void init(String name, String nameEnglish, Collection members, boolean checkForDuplicates) {
        super.initialize(name, nameEnglish);
        if (members == null) {
            throw new NullPointerException("Param members cant be null");
        }
        this.fMembers = new ArrayList<String>(members.size());
        this.fMembersSet = new HashSet<String>();
        int cnt = 0;
        for (Object member : members) {
            String mn;
            ++cnt;
            if (member == null) {
                throw new NullPointerException("Member is null at: " + cnt);
            }
            if (member instanceof Gene) {
                Gene gene = (Gene)member;
                mn = gene.getSymbol();
            } else {
                mn = member instanceof Probe ? ((Probe)member).getName() : member.toString();
            }
            if (checkForDuplicates) {
                if (this.fMembersSet.contains(mn)) {
                    this.log.warn((Object)("Duplicate GeneSet member: " + mn));
                    continue;
                }
                this.fMembers.add(mn);
                this.fMembersSet.add(mn);
                continue;
            }
            this.fMembers.add(mn);
            this.fMembersSet.add(mn);
        }
    }

    private void init(String name, String nameEnglish, String[] members, boolean checkForDuplicates) {
        super.initialize(name, nameEnglish);
        if (members == null) {
            throw new NullPointerException("Members param cant be null");
        }
        this.fMembers = new ArrayList<String>(members.length);
        this.fMembersSet = new HashSet<String>();
        for (int i = 0; i < members.length; ++i) {
            if (members[i] == null) {
                throw new NullPointerException("Member is null at: " + i);
            }
            if (checkForDuplicates) {
                if (this.fMembersSet.contains(members[i])) {
                    this.log.warn((Object)("Duplicate GeneSet member: " + members[i]));
                    continue;
                }
                this.fMembers.add(members[i]);
                this.fMembersSet.add(members[i]);
                continue;
            }
            this.fMembers.add(members[i]);
            this.fMembersSet.add(members[i]);
        }
    }

    public GeneSet cloneDeep(Dataset qualify) {
        ArrayList<String> all = new ArrayList<String>(this.fMembers);
        for (int i = 0; i < this.getNumMembers(); ++i) {
            String rn = this.getMember(i);
            if (qualify.getRowIndex(rn) != -1) continue;
            all.remove(rn);
        }
        return new GeneSet(this.getName(), this.getNameEnglish(), all, false);
    }

    public GeneSet cloneDeep(RankedList qualify) {
        ArrayList<String> all = new ArrayList<String>(this.fMembers);
        for (int i = 0; i < this.getNumMembers(); ++i) {
            String rn = this.getMember(i);
            if (qualify.getRank(rn) != -1) continue;
            all.remove(rn);
        }
        return new GeneSet(this.getName(), this.getNameEnglish(), all, false);
    }

    public GeneSet cloneShallow(String newName) {
        if (newName == null) {
            throw new IllegalArgumentException("Param newName cannot be null");
        }
        GeneSet fset = new GeneSet();
        fset.initialize(newName, this.getNameEnglish());
        fset.fMembers = this.fMembers;
        fset.fMembersSet = this.fMembersSet;
        return fset;
    }

    @Override
    public String getQuickInfo() {
        StringBuffer buf = new StringBuffer().append(this.getNumMembers()).append(" members");
        return buf.toString();
    }

    public String getName(boolean stripAux) {
        if (stripAux) {
            return AuxUtils.getAuxNameOnlyNoHash(this.getName());
        }
        return this.getName();
    }

    public String getMember(int pos) {
        return this.fMembers.get(pos);
    }

    public boolean isMember(String name) {
        return this.fMembersSet.contains(name);
    }

    public int getNumMembers() {
        return this.fMembers.size();
    }

    public List<String> getMembers() {
        return Collections.unmodifiableList(this.fMembers);
    }

    public Set<String> getMembersS() {
        return Collections.unmodifiableSet(new HashSet<String>(this.fMembers));
    }

    public String[] getMembersArray() {
        return this.fMembers.toArray(new String[this.fMembers.size()]);
    }

    public int getNumMembers(RankedList rl) {
        int ntrue = 0;
        for (int i = 0; i < rl.getSize(); ++i) {
            if (!this.isMember(rl.getRankName(i))) continue;
            ++ntrue;
        }
        return ntrue;
    }
}

