/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.MismatchedSizeException;
import edu.mit.broad.genome.TraceUtils;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.meg.Gene;
import java.util.List;
import org.apache.log4j.Logger;

public class FeatureAnnot
extends AbstractObject {
    private Logger log = Logger.getLogger(this.getClass());
    private List fFeatureNamesList;
    private List fRowDescs;
    protected Chip fChip;
    protected Helper fHelper;

    public FeatureAnnot(String name, List rowNames, List rowDescs_opt) {
        this(name, rowNames, rowDescs_opt, null);
    }

    public FeatureAnnot(String name, List rowNames, List rowDescs_opt, Chip chip_opt) {
        if (rowNames == null) {
            throw new IllegalArgumentException("Param rowNames cannot be null");
        }
        if (rowDescs_opt != null && rowNames.size() != rowDescs_opt.size()) {
            throw new MismatchedSizeException("num rows", rowNames.size(), " row descs", rowDescs_opt.size());
        }
        super.initialize(name);
        this.fFeatureNamesList = rowNames;
        this.fRowDescs = rowDescs_opt;
        this.fChip = chip_opt;
        this.fHelper = new Helper();
    }

    public Chip getChip() {
        return this.fChip;
    }

    public void setChip(Chip chip) {
        if (chip != null) {
            Helper.checkChip(this.fChip, chip);
            this.fChip = chip;
        }
    }

    @Override
    public String getQuickInfo() {
        return null;
    }

    public int getNumFeatures() {
        return this.fFeatureNamesList.size();
    }

    public boolean hasNativeDescriptions() {
        return this.fRowDescs != null && !this.fRowDescs.isEmpty();
    }

    public String getNativeDesc(String featureName) {
        if (this.fRowDescs == null) {
            return null;
        }
        int index = this.fFeatureNamesList.indexOf(featureName);
        if (index == -1) {
            this.log.warn((Object)("No such such feature: >" + featureName + "< " + this.getName()));
            return null;
        }
        return this.fRowDescs.get(index).toString();
    }

    public String getGeneSymbol(String featureName) {
        return this.fHelper.getGeneSymbol(featureName, this.fChip);
    }

    public String getGeneTitle(String featureName) {
        return this.fHelper.getGeneTitle(featureName, this.fChip);
    }

    public static class Helper {
        private boolean fReportedError = false;
        private static final Logger klog = Logger.getLogger(Helper.class);

        public static void checkChip(Chip current, Chip newChip) {
            if (current != null && newChip != null && !current.getName().equalsIgnoreCase(newChip.getName()) && newChip.getName().indexOf(current.getName()) == -1 && current.getName().indexOf(newChip.getName()) == -1) {
                klog.warn((Object)("New chip: " + newChip.getName() + " does not match current: " + current.getName()));
                TraceUtils.showTrace();
            }
        }

        public String getGeneSymbol(String featureName, Chip chip) {
            Gene gene = this._hugo(featureName, chip);
            return gene != null ? gene.getSymbol() : null;
        }

        public String getGeneTitle(String featureName, Chip chip) {
            Gene gene = this._hugo(featureName, chip);
            return gene != null ? gene.getTitle_truncated() : null;
        }

        private Gene _hugo(String featureName, Chip chip) {
            if (chip == null) {
                return null;
            }
            try {
                return chip.getHugo(featureName);
            }
            catch (Throwable t) {
                if (!this.fReportedError) {
                    klog.error((Object)t.getMessage());
                    klog.error((Object)"Turning off subsequent error notifications");
                }
                this.fReportedError = true;
                return null;
            }
        }
    }
}

