/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.markers;

import edu.mit.broad.genome.StandardException;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.alg.markers.PermutationTest;
import edu.mit.broad.genome.math.LabelledVectorProcessor;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.Template;
import gnu.trove.TFloatArrayList;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractPermutationTest
implements PermutationTest {
    private final Logger log = Logger.getLogger(this.getClass());
    private Dataset fDataset;
    private Template fTemplate;
    protected int fNumMarkers;
    protected int fNumPerms;
    protected LabelledVectorProcessor fLabelledVectorProc;
    protected Metric fMetric;
    protected SortMode fSort;
    protected Order fOrder;
    protected Map fMetricParams;
    private String fName;
    public static final float[] DEFAULT_SIG_LEVELS = new float[]{0.01f, 0.05f, 0.5f};
    private TFloatArrayList fSigLevels;
    private Matrix fUpSignificanceLevelsMatrix;
    private Matrix fDnSignificanceLevelsMatrix;
    private Matrix fNmarkersUpMatrix;
    private Matrix fNmarkersDnMatrix;

    AbstractPermutationTest() {
    }

    protected void init(String name, int numMarkers, int numPerms, LabelledVectorProcessor rp, Metric metric, SortMode sort, Order order, Map metricParams, Dataset ds, Template template, float[] sigLevels, boolean categorical) {
        if (numMarkers > ds.getNumRow()) {
            throw new IllegalArgumentException("numMarkers: " + numMarkers + " cannot be larger than dataset size: " + ds.getNumRow());
        }
        if (metric == null) {
            throw new IllegalArgumentException("Param metric cannot be null");
        }
        if (template == null) {
            throw new IllegalArgumentException("Param template cannot be null");
        }
        if (categorical) {
            if (!metric.isCategorical()) {
                throw new StandardException("As the phenotype choosen was categorical, only categorical metrics are allowed. Got: " + metric.getName(), 1010);
            }
            if (!template.isCategorical()) {
                throw new IllegalArgumentException("Only categorical templates allowed. Got: " + template.getName());
            }
        }
        if (!categorical) {
            if (!metric.isContinuous()) {
                throw new StandardException("As the phenotype choosen was continuous, only continuous class metrics are allowed. Got: " + metric.getName(), 1011);
            }
            if (!template.isContinuous()) {
                throw new IllegalArgumentException("Only continuous templates allowed. Got: " + template.getName());
            }
        }
        this.fName = name;
        this.fNumMarkers = numMarkers;
        this.fNumPerms = numPerms;
        this.fLabelledVectorProc = rp;
        this.fMetric = metric;
        this.fSort = sort;
        this.fOrder = order;
        this.fMetricParams = metricParams;
        this.fDataset = ds;
        this.fTemplate = template;
        this.fSigLevels = new TFloatArrayList();
        if (sigLevels == null || sigLevels.length == 0) {
            this.fSigLevels.add(DEFAULT_SIG_LEVELS);
        } else {
            this.fSigLevels.add(sigLevels);
        }
    }

    @Override
    public int getNumMarkers() {
        return this.fNumMarkers;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    public int getNumPerms() {
        return this.fNumPerms;
    }

    @Override
    public Metric getMetric() {
        return this.fMetric;
    }

    @Override
    public Template getTemplate() {
        return this.fTemplate;
    }

    public Dataset getDataset() {
        return this.fDataset;
    }

    @Override
    public float[] getSigLevels() {
        return this.fSigLevels.toNativeArray();
    }

    @Override
    public Dataset getSigLevels(boolean up) {
        this.checkCalced();
        this.checkCalced();
        ArrayList<CallSite> ranks = new ArrayList<CallSite>();
        for (int i = 0; i < this.getNumMarkers(); ++i) {
            ranks.add((CallSite)((Object)("rank_" + i)));
        }
        ArrayList<CallSite> siglevel = new ArrayList<CallSite>();
        for (int i = 0; i < this.getSigLevels().length; ++i) {
            siglevel.add((CallSite)((Object)("sig_" + this.getSigLevels()[i])));
        }
        if (up) {
            return new DefaultDataset(this.getName() + "_up_rnd", this.fUpSignificanceLevelsMatrix, ranks, siglevel, true, null);
        }
        return new DefaultDataset(this.getName() + "_dn_rnd", this.fDnSignificanceLevelsMatrix, ranks, siglevel, true, null);
    }

    private void checkCalced() {
        if (this.fUpSignificanceLevelsMatrix == null || this.fDnSignificanceLevelsMatrix == null) {
            throw new IllegalStateException("calcAndSetSignificanceLevels not yet called");
        }
    }

    protected void calcAndSetSignificanceLevels(Matrix nMarkersTopMatrix, Matrix nMarkersBotMatrix) {
        if (this.fNmarkersUpMatrix != null) {
            this.log.warn((Object)"Already filled markers -- refilling ...");
        }
        this.fNmarkersUpMatrix = nMarkersTopMatrix;
        this.fNmarkersDnMatrix = nMarkersBotMatrix;
        int size = this.getSigLevels().length;
        int numMarkers = nMarkersTopMatrix.getNumRow();
        this.fUpSignificanceLevelsMatrix = new Matrix(nMarkersTopMatrix.getNumRow(), size);
        this.fDnSignificanceLevelsMatrix = new Matrix(nMarkersBotMatrix.getNumRow(), size);
        for (int r = 0; r < numMarkers; ++r) {
            float level;
            int c;
            Vector v = nMarkersTopMatrix.getRowV(r);
            for (c = 0; c < size; ++c) {
                level = AbstractPermutationTest._getSignificanceLevel(v, this.fSigLevels.get(c), this.fSort, this.fOrder);
                this.fUpSignificanceLevelsMatrix.setElement(r, c, level);
            }
            v = nMarkersBotMatrix.getRowV(r);
            for (c = 0; c < size; ++c) {
                level = AbstractPermutationTest._getSignificanceLevel(v, 1.0f - this.fSigLevels.get(c), this.fSort, this.fOrder);
                this.fDnSignificanceLevelsMatrix.setElement(r, c, level);
            }
        }
    }

    private static float _getSignificanceLevel(Vector scores, float level, SortMode sort, Order order) {
        if (scores.getSize() == 0) {
            return Float.NaN;
        }
        scores.sort(sort, order);
        int index = (int)(level * (float)scores.getSize());
        return scores.getElement(index);
    }
}

