/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.gsea;

import edu.mit.broad.genome.alg.gsea.AbstractGeneSetCohort;
import edu.mit.broad.genome.alg.gsea.GeneSetCohort;
import edu.mit.broad.genome.alg.gsea.GeneSetCohortGenerator;
import edu.mit.broad.genome.alg.gsea.GeneSetScoringTable;
import edu.mit.broad.genome.alg.gsea.GeneSetScoringTables;
import edu.mit.broad.genome.alg.gsea.GeneToGeneSetMap;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.RankedList;
import org.apache.log4j.Logger;

public class DefaultGeneSetCohort
extends AbstractGeneSetCohort {
    private boolean fSilent;
    private GeneSetScoringTable[] fGeneSetScoringTables;
    private GeneSetScoringTable fOrigTable;

    private DefaultGeneSetCohort(GeneSetScoringTable scoringTable, RankedList rl, GeneSet[] gsets, GeneToGeneSetMap g2gsetmap, boolean silent, boolean qualifySetsAgainstRankedList) {
        super.init(rl, gsets, g2gsetmap, silent, qualifySetsAgainstRankedList);
        this.fSilent = silent;
        this.fOrigTable = scoringTable;
        this.fGeneSetScoringTables = new GeneSetScoringTable[this.fGeneSets.length];
        for (int g = 0; g < this.fGeneSets.length; ++g) {
            this.fGeneSetScoringTables[g] = scoringTable.createTable(this.fGeneSets[g], rl, this.fOrigTable.getRankedList());
            if (silent || g < 500 || g % 500 != 0) continue;
            System.out.println("GeneSetCohorted_scored: " + (g + 1) + " / " + this.fGeneSets.length);
        }
    }

    @Override
    public GeneSetCohort clone(GeneSet[] gsets, boolean qualifySetsAgainstRankedList) {
        return new DefaultGeneSetCohort(this.fOrigTable, this.getRankedList(), gsets, GeneToGeneSetMap.generateGeneToGenesetMap(gsets), this.fSilent, qualifySetsAgainstRankedList);
    }

    @Override
    public double getHitPoints(int gsetNum, String geneName) {
        return this.fGeneSetScoringTables[gsetNum].getHitScore(geneName);
    }

    @Override
    public double getMissPoints(int gsetNum, String geneName) {
        return this.fGeneSetScoringTables[gsetNum].getMissScore(geneName);
    }

    public static class Generator
    implements GeneSetCohortGenerator {
        private Logger log = Logger.getLogger(Generator.class);
        private boolean fSilent;
        private GeneSetScoringTable fOrigTable;

        public Generator(GeneSetScoringTable scoringTable, boolean silent) {
            this.fOrigTable = scoringTable;
            this.fSilent = silent;
        }

        @Override
        public GeneSetCohort createGeneSetCohort(RankedList rl, GeneSet[] gsets, boolean qualifySetsAgainstRankedList, boolean realRl) {
            GeneToGeneSetMap g2gsetmap = GeneToGeneSetMap.generateGeneToGenesetMap(gsets);
            return this.createGeneSetCohort(rl, gsets, g2gsetmap, qualifySetsAgainstRankedList, realRl);
        }

        public GeneSetCohort createGeneSetCohort(RankedList rl, GeneSet[] gsets, GeneToGeneSetMap g2gsetMap, boolean qualifySetsAgainstRankedList, boolean realRl) {
            if (realRl && this.fOrigTable instanceof GeneSetScoringTables.WeightedDoubleSidedAs) {
                this.log.warn((Object)("### SETTING REAL RL: " + rl.getName()));
                ((GeneSetScoringTables.WeightedDoubleSidedAs)this.fOrigTable).setReal(rl);
            }
            if (realRl && this.fOrigTable instanceof GeneSetScoringTables.WeightedDoubleSidedAs1) {
                this.log.warn((Object)("### SETTING REAL RL: " + rl.getName()));
                ((GeneSetScoringTables.WeightedDoubleSidedAs1)this.fOrigTable).setReal(rl);
            }
            return new DefaultGeneSetCohort(this.fOrigTable, rl, gsets, g2gsetMap, this.fSilent, qualifySetsAgainstRankedList);
        }
    }
}

