/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.gsea;

import edu.mit.broad.genome.TraceUtils;
import edu.mit.broad.genome.alg.gsea.GeneSetCohort;
import edu.mit.broad.genome.alg.gsea.GeneToGeneSetMap;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.RankedList;
import gnu.trove.THashSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

abstract class AbstractGeneSetCohort
implements GeneSetCohort {
    protected GeneSet[] fGeneSets;
    private THashSet[] fFastSets;
    private RankedList fRankedList;
    private Map fGeneSetNameGeneSetMap;
    protected Logger log = Logger.getLogger(AbstractGeneSetCohort.class);
    protected boolean fSilent;
    private GeneToGeneSetMap fGeneToGeneSetMap;

    protected AbstractGeneSetCohort() {
    }

    protected void init(RankedList rl, GeneSet[] gsets, GeneToGeneSetMap g2gsetmap, boolean silent, boolean qualifySetsAgainstRankedList) {
        if (rl == null) {
            throw new IllegalArgumentException("Parameter rl cannot be null");
        }
        if (gsets == null) {
            throw new IllegalArgumentException("Parameter gsets cannot be null");
        }
        if (gsets.length == 0) {
            this.log.warn((Object)("zero length gsets array: " + gsets.length));
        }
        this.fRankedList = rl;
        this.fGeneSets = new GeneSet[gsets.length];
        this.fFastSets = new THashSet[gsets.length];
        this.fGeneSetNameGeneSetMap = new HashMap();
        this.fSilent = silent;
        boolean atleastonewithits = false;
        for (int g = 0; g < gsets.length; ++g) {
            this.fGeneSets[g] = qualifySetsAgainstRankedList ? gsets[g].cloneDeep(rl) : gsets[g];
            this.fFastSets[g] = new THashSet(this.fGeneSets[g].getMembers());
            this.fGeneSetNameGeneSetMap.put(this.fGeneSets[g].getName(), this.fGeneSets[g]);
            if (!atleastonewithits && this.fGeneSets[g].getNumMembers() > 0) {
                atleastonewithits = true;
            }
            if (silent || g < 500 || g % 500 != 0) continue;
            System.out.println("GeneSetCohorted: " + (g + 1) + " / " + this.fGeneSets.length);
        }
        if (!atleastonewithits) {
            System.out.println("rl: " + rl.getName() + " \n" + rl.getRankedNames().subList(0, 10));
            TraceUtils.showTrace();
            this.log.warn((Object)"No hits in the ranked list to any of the gene sets!");
        }
        this.fGeneToGeneSetMap = g2gsetmap == null ? GeneToGeneSetMap.generateGeneToGenesetMap(this.fGeneSets) : g2gsetmap;
    }

    @Override
    public int[] genesetIndicesForGene(String geneName) {
        return this.fGeneToGeneSetMap.getGenesetIndicesForGene(geneName);
    }

    @Override
    public boolean isMember(int gsetNum, String name) {
        return this.fFastSets[gsetNum].contains((Object)name);
    }

    @Override
    public int getNumGeneSets() {
        return this.fGeneSets.length;
    }

    @Override
    public int getNumTrue(int gsetNum) {
        return this.fGeneSets[gsetNum].getNumMembers();
    }

    @Override
    public int getNumLabels() {
        return this.fRankedList.getSize();
    }

    @Override
    public RankedList getRankedList() {
        return this.fRankedList;
    }
}

