/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg;

import edu.mit.broad.genome.alg.AlgMap;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.alg.VectorSplitter;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.Template;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import xtools.api.param.BadParamException;

public class DatasetStatsCore {
    private Logger log = Logger.getLogger(DatasetStatsCore.class);

    public static void check2ClassCategoricalDS(Dataset ds, Template template, Metric metric) {
        if (!metric.isCategorical()) {
            throw new IllegalArgumentException("Not a 2 class categorical metric: " + metric);
        }
        VectorSplitter splitter = new VectorSplitter(metric.getMinNumSamplesNeededPerClassForCalculation());
        Vector profile = ds.getRow(0);
        Vector[] vs = splitter.splitBiphasic_nansafe(profile, template);
        if (metric.getName().equalsIgnoreCase("Signal2Noise") || metric.getName().equalsIgnoreCase("tTest")) {
            if (ds.getNumCol() < 6) {
                throw new BadParamException("Too few samples in the dataset to use this metric", 1006);
            }
            if (vs == null) {
                throw new BadParamException("One of the classes in this dataset has too few samples in one of the classes of the dataset to use this metric", 1006);
            }
            if (vs[0].getSize() < 3) {
                throw new BadParamException("Too few samples in class A of the dataset to use this metric", 1006);
            }
            if (vs[1].getSize() < 3) {
                throw new BadParamException("Too few samples in class B of the dataset to use this metric", 1006);
            }
        }
    }

    public Map calc2ClassCategoricalMetricMarkerScores(Dataset ds, Template template, Metric metric, Map params) {
        if (!metric.isCategorical()) {
            throw new IllegalArgumentException("Not a 2 class categorical metric: " + metric);
        }
        HashMap<String, TwoClassMarkerStats> all = new HashMap<String, TwoClassMarkerStats>();
        boolean usebiased = AlgMap.isBiased(params);
        boolean fixlow = AlgMap.isFixLowVar(params);
        boolean useMedian = AlgMap.isMedian(params);
        VectorSplitter splitter = new VectorSplitter(metric.getMinNumSamplesNeededPerClassForCalculation());
        for (int r = 0; r < ds.getNumRow(); ++r) {
            String rowName = ds.getRowName(r);
            Vector profile = ds.getRow(r);
            Vector[] vs = splitter.splitBiphasic_nansafe(profile, template);
            if (r == 0 && (metric.getName().equalsIgnoreCase("Signal2Noise") || metric.getName().equalsIgnoreCase("tTest"))) {
                if (ds.getNumCol() < 6) {
                    throw new BadParamException("Too few samples in the dataset to use this metric", 1006);
                }
                if (vs == null) {
                    throw new BadParamException("One of the classes in this dataset has too few samples in one of the classes of the dataset to use this metric", 1006);
                }
                if (vs[0].getSize() < 3) {
                    throw new BadParamException("Too few samples in class A of the dataset to use this metric", 1006);
                }
                if (vs[1].getSize() < 3) {
                    throw new BadParamException("Too few samples in class B of the dataset to use this metric", 1006);
                }
            }
            TwoClassMarkerStats stats = new TwoClassMarkerStats();
            if (vs == null || vs[0] == null || vs[1] == null) {
                stats.score = Double.NaN;
                stats.me0 = Double.NaN;
                stats.me1 = Double.NaN;
                stats.me_all = Double.NaN;
                stats.stdev0 = Double.NaN;
                stats.stdev1 = Double.NaN;
                stats.stdev_all = Double.NaN;
                this.log.warn((Object)("Omitting as too few good data points: " + rowName));
            } else {
                stats.score = (float)metric.getScore(profile, template, params);
                Vector full = new Vector(vs);
                if (useMedian) {
                    stats.me0 = vs[0].median();
                    stats.me1 = vs[1].median();
                    stats.me_all = full.median();
                } else {
                    stats.me0 = vs[0].mean();
                    stats.me1 = vs[1].mean();
                    stats.me_all = full.mean();
                }
                stats.stdev0 = (float)vs[0].stddev(usebiased, fixlow);
                stats.stdev1 = (float)vs[1].stddev(usebiased, fixlow);
                stats.stdev_all = (float)full.stddev(usebiased, fixlow);
            }
            if (all.containsKey(rowName)) {
                throw new RuntimeException("Duplicate row names in dataset: " + ds.getName() + " rowname: " + rowName + " row: " + r);
            }
            all.put(rowName, stats);
        }
        return Collections.unmodifiableMap(all);
    }

    public static class TwoClassMarkerStats {
        private double score;
        private double me0;
        private double stdev0;
        private double me1;
        private double stdev1;
        private double me_all;
        private double stdev_all;

        public double getScore() {
            return this.score;
        }

        public double getMe0() {
            return this.me0;
        }

        public double getMe_all() {
            return this.me_all;
        }

        public double getStdev0() {
            return this.stdev0;
        }

        public double getMe1() {
            return this.me1;
        }

        public double getStdev1() {
            return this.stdev1;
        }

        public double getStdev_all() {
            return this.stdev_all;
        }
    }
}

