/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.bytematrix.impl;

import org.ujmp.core.Matrix;
import org.ujmp.core.bytematrix.stub.AbstractDenseByteMatrix2D;
import org.ujmp.core.doublematrix.impl.DefaultDenseDoubleMatrix2D;
import org.ujmp.core.interfaces.HasColumnMajorByteArray1D;
import org.ujmp.core.util.MathUtil;

public class DefaultDenseByteMatrix2D
extends AbstractDenseByteMatrix2D
implements HasColumnMajorByteArray1D {
    private static final long serialVersionUID = -7637602510970244322L;
    private final byte[] values;
    private final int rows;
    private final int cols;

    public DefaultDenseByteMatrix2D(Matrix m) {
        super(m.getRowCount(), m.getColumnCount());
        this.rows = MathUtil.longToInt(m.getRowCount());
        this.cols = MathUtil.longToInt(m.getColumnCount());
        if (m instanceof DefaultDenseByteMatrix2D) {
            byte[] v = ((DefaultDenseByteMatrix2D)m).values;
            this.values = new byte[v.length];
            System.arraycopy(v, 0, this.values, 0, v.length);
        } else {
            this.values = new byte[this.rows * this.cols];
            for (long[] c : m.allCoordinates()) {
                this.setByte(m.getAsByte(c), c);
            }
        }
    }

    public DefaultDenseByteMatrix2D(int rows, int cols) {
        super((long)rows, (long)cols);
        this.rows = rows;
        this.cols = cols;
        this.values = new byte[rows * cols];
    }

    public DefaultDenseByteMatrix2D(byte[] v, int rows, int cols) {
        super((long)rows, (long)cols);
        this.rows = rows;
        this.cols = cols;
        this.values = v;
    }

    public byte getByte(long row, long column) {
        return this.values[(int)(column * (long)this.rows + row)];
    }

    public void setByte(byte value, long row, long column) {
        this.values[(int)(column * (long)this.rows + row)] = value;
    }

    public byte getByte(int row, int column) {
        return this.values[column * this.rows + row];
    }

    public void setByte(byte value, int row, int column) {
        this.values[column * this.rows + row] = value;
    }

    public final Matrix plus(double v) {
        double[] result = new double[this.values.length];
        int i = result.length;
        while (--i != -1) {
            result[i] = (double)this.values[i] + v;
        }
        return new DefaultDenseDoubleMatrix2D(result, this.rows, this.cols);
    }

    public final Matrix minus(double v) {
        double[] result = new double[this.values.length];
        int i = result.length;
        while (--i != -1) {
            result[i] = (double)this.values[i] - v;
        }
        return new DefaultDenseDoubleMatrix2D(result, this.rows, this.cols);
    }

    public final Matrix times(double v) {
        double[] result = new double[this.values.length];
        int i = result.length;
        while (--i != -1) {
            result[i] = (double)this.values[i] * v;
        }
        return new DefaultDenseDoubleMatrix2D(result, this.rows, this.cols);
    }

    public final Matrix divide(double v) {
        double[] result = new double[this.values.length];
        int i = result.length;
        while (--i != -1) {
            result[i] = (double)this.values[i] / v;
        }
        return new DefaultDenseDoubleMatrix2D(result, this.rows, this.cols);
    }

    public final Matrix copy() {
        byte[] result = new byte[this.values.length];
        System.arraycopy(this.values, 0, result, 0, this.values.length);
        DefaultDenseByteMatrix2D m = new DefaultDenseByteMatrix2D(result, this.rows, this.cols);
        if (this.getMetaData() != null) {
            m.setMetaData(this.getMetaData().clone());
        }
        return m;
    }

    public final Matrix transpose() {
        byte[] result = new byte[this.cols * this.rows];
        int c = this.rows;
        while (--c != -1) {
            int r = this.cols;
            while (--r != -1) {
                result[c * this.cols + r] = this.values[r * this.rows + c];
            }
        }
        return new DefaultDenseByteMatrix2D(result, this.cols, this.rows);
    }

    public byte[] getColumnMajorByteArray1D() {
        return this.values;
    }
}

