/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.charts.XChart;
import edu.mit.broad.genome.io.FtpResultInputStream;
import edu.mit.broad.genome.io.FtpSingleUrlTransferCommand;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.AuxUtils;
import edu.mit.broad.genome.parsers.DataFormat;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.xbench.RendererFactory2;
import edu.mit.broad.xbench.core.ObjectBindery;
import edu.mit.broad.xbench.prefs.XPreferencesFactory;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.genepattern.uiutil.FTPFile;
import org.genepattern.uiutil.FTPList;
import xapps.gsea.GseaWebResources;
import xtools.api.param.AbstractParam;
import xtools.api.param.ChooserHelper;
import xtools.api.param.ParamHelper;
import xtools.api.ui.GeneSetMatrixChooserUI;
import xtools.api.ui.NamedModel;

abstract class GeneSetMatrixChooserAbstractParam
extends AbstractParam {
    private boolean fMultipleAllowed = true;
    private MyPobActionListener fAl;
    protected GeneSetMatrixChooserUI fChooser;
    private boolean fIncludeGmx = true;
    private String delimiter = ",";

    GeneSetMatrixChooserAbstractParam(String name, String nameEnglish, String desc, boolean reqd, boolean multipleAlllowed, boolean includeGeneSetMatrix) {
        super(name, nameEnglish, GeneSetMatrix[].class, desc, (Object)new GeneSetMatrix[0], (Object[])new GeneSetMatrix[0], reqd);
        this.fMultipleAllowed = multipleAlllowed;
        this.fIncludeGmx = includeGeneSetMatrix;
    }

    public GeneSetMatrix getGeneSetMatrixCombo(boolean removeNativeGmNames) throws Exception {
        return this._getGeneSets().toGm(removeNativeGmNames);
    }

    public void setAlternateDelimiter(String alternateDelimiter) {
        if (StringUtils.length((CharSequence)alternateDelimiter) > 1) {
            throw new IllegalArgumentException("Illegal alternate delimiter '" + alternateDelimiter + "'; must be a single character only.");
        }
        this.delimiter = alternateDelimiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] _getObjects() throws Exception {
        Object[] objs;
        Object val = this.getValue();
        if (val instanceof String) {
            String[] paths = this._parse(val.toString());
            objs = new Object[paths.length];
            for (int p = 0; p < paths.length; ++p) {
                if (paths[p].toLowerCase().startsWith("ftp.") || paths[p].toLowerCase().startsWith("gseaftp.")) {
                    URL ftpURL = new URL("ftp://" + paths[p]);
                    FtpSingleUrlTransferCommand ftpCommand = new FtpSingleUrlTransferCommand(ftpURL);
                    FtpResultInputStream resultInputStream = null;
                    try {
                        resultInputStream = ftpCommand.retrieveAsInputStream();
                        GeneSetMatrix gm = ParserFactory.readGeneSetMatrix(paths[p], resultInputStream, false);
                        if (AuxUtils.isAux(paths[p])) {
                            objs[p] = gm.getGeneSet(AuxUtils.getAuxNameOnlyIncludingHash(paths[p]));
                            continue;
                        }
                        objs[p] = gm;
                        continue;
                    }
                    finally {
                        File tempFile;
                        if (resultInputStream != null && !(tempFile = resultInputStream.getFile()).delete()) {
                            tempFile.deleteOnExit();
                        }
                    }
                }
                objs[p] = AuxUtils.isAux(paths[p]) ? ParserFactory.readGeneSet(new File(paths[p]), true) : ParserFactory.read(new File(paths[p]));
            }
        } else {
            objs = val instanceof Object[] ? (Object[])val : new Object[]{val};
        }
        return objs;
    }

    private String _getName(Object[] objs) {
        String name = "combo";
        if (objs.length == 1 && objs[0] instanceof GeneSetMatrix) {
            name = ((GeneSetMatrix)objs[0]).getName();
        }
        return name;
    }

    protected GeneSetsStruc _getGeneSets() throws Exception {
        Object[] objs = this._getObjects();
        if (this.isReqd() && objs.length == 0) {
            throw new IllegalArgumentException("Must specify GeneSetMatrix parameter: " + this.getNameEnglish() + " (" + this.getDesc() + ")");
        }
        ArrayList<Object> gsets = new ArrayList<Object>();
        String name = this._getName(objs);
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] instanceof GeneSetMatrix) {
                gsets.addAll(((GeneSetMatrix)objs[i]).getGeneSetsL());
                continue;
            }
            if (objs[i] instanceof GeneSet) {
                gsets.add(objs[i]);
                continue;
            }
            if (objs[i] instanceof Dataset) {
                gsets.add(((Dataset)objs[i]).getRowNamesGeneSet());
                continue;
            }
            if (objs[i] instanceof Chip) {
                gsets.add(((Chip)objs[i]).getProbeNamesAsGeneSet());
                continue;
            }
            throw new IllegalArgumentException("Unknown object: " + objs[i]);
        }
        return new GeneSetsStruc(name, gsets.toArray(new GeneSet[gsets.size()]));
    }

    private String[] _parse(String s) {
        if (s == null) {
            throw new IllegalArgumentException("Parameter s cannot be null");
        }
        Set<String> vals = ParseUtils.string2stringsSet(s, this.delimiter);
        System.out.println("to parse>" + s + "< got: " + vals);
        HashSet<String> use = new HashSet<String>();
        Iterator<String> it = vals.iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            if (key.length() <= 0) continue;
            use.add(key);
        }
        return use.toArray(new String[use.size()]);
    }

    private String format(Object[] vals) {
        if (vals == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] == null) continue;
            this.log.debug(vals[i].getClass());
            if (vals[i] instanceof PersistentObject) {
                String p = ParserFactory.getCache().getSourcePath(vals[i]);
                buf.append(p);
            } else {
                buf.append(vals[i].toString().trim());
            }
            if (i == vals.length - 1) continue;
            buf.append(this.delimiter);
        }
        return buf.toString();
    }

    protected ActionListener getActionListener() {
        if (this.fAl == null) {
            this.fAl = new MyPobActionListener(this.fMultipleAllowed, this.fIncludeGmx);
            this.fAl.setChooser(this.fChooser);
        }
        return this.fAl;
    }

    @Override
    public boolean isFileBased() {
        return true;
    }

    @Override
    public String getValueStringRepresentation(boolean full) {
        Object val = this.getValue();
        if (val == null) {
            return null;
        }
        if (val instanceof String) {
            return (String)val;
        }
        if (val instanceof Object[]) {
            Object[] objs = (Object[])val;
            return this.format(objs);
        }
        return this.format(new Object[]{val});
    }

    @Override
    public GFieldPlusChooser getSelectionComponent() {
        if (this.fChooser == null) {
            this.fChooser = new GeneSetMatrixChooserUI(false);
            this.fChooser.setCustomActionListener(this.getActionListener());
            String text = this.getValueStringRepresentation(false);
            if (text == null) {
                text = this.format((Object[])this.getDefault());
            }
            if (this.isFileBased()) {
                // empty if block
            }
            this.fChooser.setText(text);
            ParamHelper.addDocumentListener(this.fChooser.getTextField(), this);
        }
        return this.fChooser;
    }

    private static boolean isVersion(String versionSuffix, String name) {
        int index = StringUtils.indexOfIgnoreCase((CharSequence)name, (CharSequence)versionSuffix);
        return index >= 0;
    }

    public static class GeneSetsFromFTPSiteRenderer
    extends DefaultListCellRenderer {
        private boolean ifFileOnlyShowName;

        public GeneSetsFromFTPSiteRenderer(boolean ifFileOnlyShowName) {
            this.ifFileOnlyShowName = ifFileOnlyShowName;
        }

        public GeneSetsFromFTPSiteRenderer() {
            this(false);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof PersistentObject) {
                PersistentObject pob = (PersistentObject)value;
                if (pob.getQuickInfo() != null) {
                    StringBuffer buf = new StringBuffer("<html><body>").append(pob.getName());
                    buf.append("<font color=#666666> [").append(pob.getQuickInfo()).append(']').append("</font></html></body>");
                    this.setText(buf.toString());
                } else {
                    this.setText(pob.getName());
                }
                File f = null;
                if (ParserFactory.getCache().isCached(pob)) {
                    f = ParserFactory.getCache().getSourceFile(pob);
                }
                if (f != null) {
                    this.setToolTipText(f.getAbsolutePath());
                } else {
                    this.setToolTipText("Unknown origins of file: " + f);
                }
            } else if (value instanceof File) {
                if (this.ifFileOnlyShowName) {
                    this.setText(((File)value).getName());
                } else {
                    this.setText(((File)value).getAbsolutePath());
                }
                this.setIcon(DataFormat.getIcon(value));
                this.setToolTipText(((File)value).getAbsolutePath());
            } else if (value instanceof XChart) {
                this.setText(((XChart)value).getName());
                this.setIcon(XChart.ICON);
            } else if (value instanceof FTPFile) {
                Object s = ((FTPFile)value).getName();
                String slc = ((String)s).toLowerCase();
                if (slc.indexOf("c1.") != -1) {
                    s = (String)s + " [Positional]";
                } else if (slc.indexOf("c2.") != -1) {
                    s = (String)s + " [Curated]";
                } else if (slc.indexOf("c3.") != -1) {
                    s = (String)s + " [Motif]";
                } else if (slc.indexOf("c4.") != -1) {
                    s = (String)s + " [Computational]";
                } else if (slc.indexOf("c5.") != -1) {
                    s = (String)s + " [Gene ontology]";
                } else if (slc.indexOf("c6.") != -1) {
                    s = (String)s + " [Oncogenic signatures]";
                } else if (slc.indexOf("c7.") != -1) {
                    s = (String)s + " [Immunologic signatures]";
                } else if (slc.indexOf("h.") != -1) {
                    s = (String)s + " [Hallmarks]";
                }
                if (GeneSetMatrixChooserAbstractParam.isVersion(GeneSetsFromFTPSiteComparator.getHighestVersionId(), slc)) {
                    Font font = this.getFont();
                    String fontName = font.getFontName();
                    int fontSize = font.getSize();
                    this.setFont(new Font(fontName, 1, fontSize));
                }
                this.setText((String)s);
                this.setIcon(RendererFactory2.FTP_FILE_ICON);
            }
            return this;
        }
    }

    public static class MSigDBFilenameParser {
        static String MSIGDB_VERSION_V1 = "v1";
        static String MSIGDB_VERSION_V2 = "v2";
        private String filename = null;
        private String versionId = null;
        private String collectionId = null;
        private String subsetId = null;
        private int collectionIdNum = 0;

        public MSigDBFilenameParser(String filename) {
            if (filename == null) {
                throw new IllegalArgumentException("MSigDB Filename cannot be null");
            }
            this.filename = filename;
            this.collectionId = filename.substring(0, 2);
            if (this.collectionId.substring(0, 1).equals("h")) {
                this.collectionId = this.collectionId.substring(0, 1);
                this.collectionIdNum = 0;
            } else {
                this.collectionIdNum = Integer.parseInt(this.collectionId.substring(1));
            }
            this.versionId = filename.substring(filename.lastIndexOf("v"), filename.lastIndexOf(".symbols.gmt"));
            if (!this.versionId.equals(MSIGDB_VERSION_V1) && !this.versionId.equals(MSIGDB_VERSION_V2)) {
                this.subsetId = filename.substring(3, filename.lastIndexOf(this.versionId) - 1);
            }
        }

        public String getVersionId() {
            return this.versionId;
        }

        public String getCanonicalVersionId() {
            if (this.versionId.equals(MSIGDB_VERSION_V1) || this.versionId.equals(MSIGDB_VERSION_V2)) {
                return this.versionId + ".0";
            }
            return this.versionId;
        }

        public int getCollectionIdNum() {
            return this.collectionIdNum;
        }

        public String getSubsetId() {
            return this.subsetId;
        }
    }

    public static class GeneSetsFromFTPSiteComparator
    implements Comparator {
        private static String highestVersionId;
        private static DefaultArtifactVersion highestVersion;

        public static String getHighestVersionId() {
            return highestVersionId;
        }

        public int compare(Object pn1, Object pn2) {
            int collectionNum2;
            MSigDBFilenameParser p1 = new MSigDBFilenameParser(pn1.toString());
            MSigDBFilenameParser p2 = new MSigDBFilenameParser(pn2.toString());
            DefaultArtifactVersion version1 = new DefaultArtifactVersion(p1.getCanonicalVersionId());
            DefaultArtifactVersion version2 = new DefaultArtifactVersion(p2.getCanonicalVersionId());
            if (highestVersion == null) {
                if (version1.compareTo((Object)version2) < 0) {
                    highestVersion = version2;
                    highestVersionId = p2.getVersionId();
                } else {
                    highestVersion = version1;
                    highestVersionId = p2.getVersionId();
                }
            } else if (highestVersion.compareTo((Object)version2) < 0) {
                highestVersion = version2;
                highestVersionId = p2.getVersionId();
            }
            if (!version1.equals((Object)version2)) {
                return version2.compareTo((Object)version1);
            }
            int collectionNum1 = p1.getCollectionIdNum();
            if (collectionNum1 != (collectionNum2 = p2.getCollectionIdNum())) {
                return collectionNum1 - collectionNum2;
            }
            String subsetId1 = p1.getSubsetId();
            String subsetId2 = p2.getSubsetId();
            return subsetId1.compareTo(subsetId2);
        }

        @Override
        public boolean equals(Object o2) {
            return false;
        }
    }

    private static class MyPobActionListener
    implements ActionListener {
        private boolean fMultipleAllowed;
        private boolean fIncludeGmx;
        private GeneSetMatrixChooserUI fChooser;
        final DefaultListCellRenderer rend = new GeneSetsFromFTPSiteRenderer();

        public MyPobActionListener(boolean multipleAllowed, boolean includeGeneSetMatrix) {
            this.fMultipleAllowed = multipleAllowed;
            this.fIncludeGmx = includeGeneSetMatrix;
        }

        public void setChooser(GeneSetMatrixChooserUI chooser) {
            this.fChooser = chooser;
        }

        private ListModel createFTPModel() {
            if (!XPreferencesFactory.kOnlineMode.getBoolean()) {
                DefaultListModel<String> model = new DefaultListModel<String>();
                model.addElement("Offline mode");
                model.addElement("Change this in Menu=>Preferences");
                model.addElement("Choose gene sets from other tabs");
                return model;
            }
            try {
                FTPList ftpList = new FTPList(GseaWebResources.getGseaFTPServer(), GseaWebResources.getGseaFTPServerUserName(), GseaWebResources.getGseaFTPServerPassword(), GseaWebResources.getGseaFTPServerGeneSetsDir(), new GeneSetsFromFTPSiteComparator());
                ftpList.quit();
                return ftpList.getModel();
            }
            catch (Exception e) {
                AbstractParam.klog.error((Object)e);
                DefaultListModel<String> model = new DefaultListModel<String>();
                model.addElement("Error listing Broad website");
                model.addElement(e.getMessage());
                model.addElement("Choose gene sets from other tabs");
                return model;
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.fChooser == null) {
                return;
            }
            int selmode = !this.fMultipleAllowed ? 0 : 2;
            NamedModel gsetsModel = new NamedModel("Gene sets (grp)", ObjectBindery.getModel(GeneSet.class));
            NamedModel subsetsModel = new NamedModel("Subsets", ObjectBindery.getHackAuxGeneSetsBoxModel());
            NamedModel gmFromFTPModel = new NamedModel("Gene matrix (from website)", this.createFTPModel());
            NamedModel[] models = this.fIncludeGmx ? new NamedModel[]{gmFromFTPModel, gsetsModel, new NamedModel("Gene matrix (local gmx/gmt)", ObjectBindery.getModel(GeneSetMatrix.class)), subsetsModel} : new NamedModel[]{gsetsModel, subsetsModel};
            Object[] sels = this.fChooser.getJListWindow().showDirectlyWithModels(models, selmode, this.rend);
            if (sels != null && sels.length != 0) {
                String[] paths = new String[sels.length];
                for (int i = 0; i < sels.length; ++i) {
                    paths[i] = sels[i] instanceof FTPFile ? ((FTPFile)sels[i]).getPath() : ParserFactory.getCache().getSourcePath(sels[i]);
                }
                String str = ChooserHelper.formatPob(sels);
                this.fChooser.setText(str);
            }
        }
    }

    class GeneSetsStruc {
        GeneSet[] gsets;
        String name;

        GeneSetsStruc(String name, GeneSet[] gsets) {
            this.gsets = gsets;
            this.name = name;
        }

        GeneSetMatrix toGm(boolean removeNativeGmNames) {
            return new DefaultGeneSetMatrix(this.name, this.gsets, removeNativeGmNames);
        }
    }
}

