/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.core.api;

import edu.mit.broad.genome.alg.ComparatorFactory;
import edu.mit.broad.genome.parsers.ParseUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class XStore
extends AbstractListModel
implements ComboBoxModel {
    private static final Logger klog = Logger.getLogger(XStore.class);
    private File fFile;
    protected List fLines;
    private int fSelIndex = 0;
    private boolean fLoaded;
    private AdditionDecider fDecider;

    protected XStore() {
    }

    protected void init(File file, AdditionDecider dec) {
        this.fFile = file;
        this.fLines = new ArrayList();
        this.fDecider = dec;
    }

    private void load() {
        if (this.fLoaded) {
            return;
        }
        try {
            if (!this.fFile.exists()) {
                this.fFile.createNewFile();
            }
            List<String> ffn = ParseUtils.readFfn(this.fFile);
            this.fLines = new ArrayList();
            for (int i = 0; i < ffn.size(); ++i) {
                String s = ffn.get(i).toString();
                String ret = this.fDecider.addThis(s);
                if (ret == null || ret.length() == 0) continue;
                this.fLines.add(ret);
            }
            this.sort();
            this.fLoaded = true;
            this.fireContentsChanged(this, this.fLines.size() - 1, this.fLines.size());
        }
        catch (Throwable t) {
            klog.fatal((Object)("Could not init store: " + this.fFile), t);
        }
    }

    public void clearAll() {
        this.fLines.clear();
        this.save();
    }

    public void add(String text) {
        String ret;
        if (!this.fLoaded) {
            this.load();
        }
        if (text == null) {
            return;
        }
        if ((text = text.trim()).length() == 0) {
            return;
        }
        if (text.endsWith("\n")) {
            text = text.substring(0, text.length() - 1);
        }
        if ((ret = this.fDecider.addThis(text)) != null && ret.length() != 0) {
            this.fLines.add(ret);
            this.fireContentsChanged(this, this.fLines.size() - 1, this.fLines.size());
        }
    }

    public void save() {
        try {
            if (!this.fFile.exists()) {
                this.fFile.createNewFile();
            }
            if (this.fFile.canWrite()) {
                FileUtils.writeLines((File)this.fFile, (Collection)this.fLines);
            }
        }
        catch (Throwable t) {
            klog.error((Object)"Trouble saving store", t);
        }
    }

    public void trim(int maxNumLines) {
        if (!this.fLoaded) {
            this.load();
        }
        if (this.fLines.size() > maxNumLines) {
            int size = this.fLines.size();
            this.fLines = this.fLines.subList(size - maxNumLines, size);
        }
        this.save();
        this.fireContentsChanged(this, this.fLines.size() - 1, this.fLines.size());
    }

    public void removeAndSave(List objects) {
        for (int i = 0; i < objects.size(); ++i) {
            this.fLines.remove(objects.get(i));
        }
        this.save();
    }

    public void sort() {
        Collections.sort(this.fLines, new ComparatorFactory.FileExtComparator());
    }

    public void addAndSave(String text) {
        if (!this.fLoaded) {
            this.load();
        }
        if (text == null || text.length() == 0) {
            return;
        }
        this.add(text);
        this.save();
        this.sort();
    }

    @Override
    public int getSize() {
        if (!this.fLoaded) {
            this.load();
        }
        return this.fLines.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.fLines.get(index);
    }

    public boolean contains(String str) {
        return this.fLines.contains(str);
    }

    @Override
    public Object getSelectedItem() {
        if (this.fLines.size() == 0) {
            return null;
        }
        return this.fLines.get(this.fSelIndex);
    }

    @Override
    public void setSelectedItem(Object obj) {
        this.fSelIndex = this.fLines.indexOf(obj);
    }

    public static interface AdditionDecider {
        public String addThis(String var1);
    }
}

