/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.objects.Annot;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.SampleAnnot;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserException;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class GctParser
extends AbstractParser {
    public GctParser() {
        super(Dataset.class);
    }

    @Override
    public void export(PersistentObject pob, File file) throws Exception {
        this._export(pob, this.startExport(pob, file));
    }

    @Override
    public void export(PersistentObject pob, OutputStream os) throws Exception {
        this._export(pob, this.startExport(pob, os, null));
    }

    private void _export(PersistentObject pob, PrintWriter pw) throws Exception {
        Dataset ds = (Dataset)pob;
        FeatureAnnot ann = null;
        if (ds.getAnnot() != null) {
            ann = ds.getAnnot().getFeatureAnnot();
        }
        pw.println("#1.2");
        pw.println(ds.getNumRow() + "\t" + ds.getNumCol());
        pw.print("NAME\tDESCRIPTION\t");
        for (int i = 0; i < ds.getNumCol(); ++i) {
            pw.print(ds.getColumnName(i));
            if (i == ds.getNumCol() - 1) continue;
            pw.print('\t');
        }
        pw.println();
        for (int r = 0; r < ds.getNumRow(); ++r) {
            StringBuffer buf = new StringBuffer();
            String rowName = ds.getRowName(r);
            buf.append(rowName).append('\t');
            Object desc = "na";
            if (ann != null) {
                if (ann.hasNativeDescriptions()) {
                    desc = ann.getNativeDesc(rowName);
                } else {
                    String symbol = ann.getGeneSymbol(rowName);
                    if (symbol != null) {
                        desc = symbol + ":" + ann.getGeneTitle(rowName);
                    }
                }
            }
            if (desc == null) {
                desc = "na";
            }
            buf.append((String)desc).append('\t');
            buf.append(ds.getRow(r).toString('\t'));
            pw.println(buf.toString());
        }
        pw.close();
        this.doneExport();
    }

    @Override
    public List parse(String sourcepath, InputStream is) throws Exception {
        this.startImport(sourcepath);
        BufferedReader bin = new BufferedReader(new InputStreamReader(is));
        return this._parse(sourcepath, bin, true);
    }

    private List _parse(String objName, BufferedReader bin, boolean nameBeforeDesc) throws Exception {
        objName = NamingConventions.removeExtension(objName);
        String currLine = this.nextLine(bin);
        int[] nstuff = ParseUtils.string2ints(currLine, " \t");
        if (nstuff.length != 2) {
            throw new ParserException("Gct file with bad row/col info on line: " + currLine);
        }
        int nrows = nstuff[0];
        int ncols = nstuff[1];
        currLine = this.nextLine(bin);
        List<String> colnames = ParseUtils.string2stringsList(currLine, "\t");
        colnames.remove(0);
        colnames.remove(0);
        if (colnames.size() != ncols) {
            throw new ParserException("Bad gct format -- expected ncols from specification on header line: " + ncols + " but found in data: " + colnames.size());
        }
        ArrayList<String> lines = new ArrayList<String>();
        currLine = this.nextLineTrimless(bin);
        while (currLine != null) {
            lines.add(currLine);
            currLine = this.nextLineTrimless(bin);
        }
        if (lines.size() != nrows) {
            throw new ParserException("Bad gct format -- exepcted nrows from specification on header line: " + nrows + " but found in data: " + lines.size());
        }
        bin.close();
        return this._parseHasDesc(objName, lines, colnames, nameBeforeDesc);
    }

    private List _parseHasDesc(String objName, List lines, List colNames, boolean nameBeforeDesc) throws Exception {
        objName = NamingConventions.removeExtension(objName);
        Matrix matrix = new Matrix(lines.size(), colNames.size());
        ArrayList<String> rowNames = new ArrayList<String>();
        ArrayList<String> rowDescs = new ArrayList<String>();
        for (int i = 0; i < lines.size(); ++i) {
            String currLine = (String)lines.get(i);
            List fields = GctParser.string2stringsV2(currLine, colNames.size() + 2);
            if (fields.size() != colNames.size() + 1 + 1) {
                throw new ParserException("Bad format - expect ncols: " + (colNames.size() + 1 + 1) + " but found: " + fields.size() + " on line >" + currLine + "<\nIf this dataset has missing values, use ImputeDataset to fill these in before importing as a Dataset");
            }
            String rowname = fields.get(0).toString().trim();
            if (rowname.length() == 0) {
                throw new ParserException("Bad rowname - cant be empty at: " + i + " >" + currLine);
            }
            String desc = fields.get(1).toString().trim();
            if (desc.length() == 0) {
                desc = "na";
            }
            if (!nameBeforeDesc) {
                String tmp = rowname;
                rowname = desc;
                desc = tmp;
            }
            rowDescs.add(desc);
            rowNames.add(rowname);
            for (int f = 2; f < fields.size(); ++f) {
                float val;
                String s = fields.get(f).toString().trim();
                if (s.length() == 0) {
                    val = Float.NaN;
                } else {
                    try {
                        val = Float.parseFloat(s);
                    }
                    catch (Exception e) {
                        System.out.println(">" + s + "<");
                        throw e;
                    }
                }
                matrix.setElement(i, f - 2, val);
            }
        }
        FeatureAnnot ann = new FeatureAnnot(objName, rowNames, rowDescs);
        ann.addComment(this.fComment.toString());
        SampleAnnot sann = new SampleAnnot(objName, colNames);
        DefaultDataset ds = new DefaultDataset(objName, matrix, rowNames, colNames, true, new Annot(ann, sann));
        ds.addComment(this.fComment.toString());
        this.doneImport();
        return GctParser.unmodlist(new PersistentObject[]{ds});
    }
}

